package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Registration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRegistration.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Registration"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRegistration extends Registration {
  private final String name;
  private final String id;
  private final Optional<String> address;
  private final Optional<Integer> port;
  private final Optional<Registration.RegCheck> check;
  private final ImmutableList<Registration.RegCheck> checks;
  private final ImmutableList<String> tags;
  private final Optional<Boolean> enableTagOverride;

  private ImmutableRegistration(
      String name,
      String id,
      Optional<String> address,
      Optional<Integer> port,
      Optional<Registration.RegCheck> check,
      ImmutableList<Registration.RegCheck> checks,
      ImmutableList<String> tags,
      Optional<Boolean> enableTagOverride) {
    this.name = name;
    this.id = id;
    this.address = address;
    this.port = port;
    this.check = check;
    this.checks = checks;
    this.tags = tags;
    this.enableTagOverride = enableTagOverride;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "Id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty(value = "Address")
  @Override
  public Optional<String> getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty(value = "Port")
  @Override
  public Optional<Integer> getPort() {
    return port;
  }

  /**
   * @return The value of the {@code check} attribute
   */
  @JsonProperty(value = "Check")
  @Override
  public Optional<Registration.RegCheck> getCheck() {
    return check;
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty(value = "Checks")
  @Override
  public ImmutableList<Registration.RegCheck> getChecks() {
    return checks;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty(value = "Tags")
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code enableTagOverride} attribute
   */
  @JsonProperty(value = "EnableTagOverride")
  @Override
  public Optional<Boolean> getEnableTagOverride() {
    return enableTagOverride;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Registration#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRegistration withName(String value) {
    if (this.name.equals(value)) return this;
    return new ImmutableRegistration(
        Preconditions.checkNotNull(value, "name"),
        this.id,
        this.address,
        this.port,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Registration#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRegistration withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableRegistration(
        this.name,
        Preconditions.checkNotNull(value, "id"),
        this.address,
        this.port,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration#getAddress() address} attribute.
   * @param value The value for address
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withAddress(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.address.equals(newValue)) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        newValue,
        this.port,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration#getAddress() address} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for address
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withAddress(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "address");
    if (this.address.equals(value)) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        value,
        this.port,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration#getPort() port} attribute.
   * @param value The value for port
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withPort(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.port.equals(newValue)) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        newValue,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration#getPort() port} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for port
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withPort(Optional<Integer> optional) {
    Optional<Integer> value = Preconditions.checkNotNull(optional, "port");
    if (this.port.equals(value)) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        value,
        this.check,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration#getCheck() check} attribute.
   * @param value The value for check
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withCheck(Registration.RegCheck value) {
    Optional<Registration.RegCheck> newValue = Optional.of(value);
    if (this.check.isPresent() && this.check.get() == value) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        newValue,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration#getCheck() check} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for check
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withCheck(Optional<Registration.RegCheck> optional) {
    Optional<Registration.RegCheck> value = Preconditions.checkNotNull(optional, "check");
    if (!this.check.isPresent() && !value.isPresent()) return this;
    if (this.check.isPresent() && value.isPresent() && this.check.get() == value.get()) return this;
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        value,
        this.checks,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Registration#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withChecks(Registration.RegCheck... elements) {
    ImmutableList<Registration.RegCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        this.check,
        newValue,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Registration#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withChecks(Iterable<? extends Registration.RegCheck> elements) {
    if (this.checks == elements) return this;
    ImmutableList<Registration.RegCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        this.check,
        newValue,
        this.tags,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Registration#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        this.check,
        this.checks,
        newValue,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Registration#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRegistration(
        this.name,
        this.id,
        this.address,
        this.port,
        this.check,
        this.checks,
        newValue,
        this.enableTagOverride);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration#getEnableTagOverride() enableTagOverride} attribute.
   * @param value The value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withEnableTagOverride(boolean value) {
    Optional<Boolean> newValue = Optional.of(value);
    if (this.enableTagOverride.equals(newValue)) return this;
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration#getEnableTagOverride() enableTagOverride} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegistration withEnableTagOverride(Optional<Boolean> optional) {
    Optional<Boolean> value = Preconditions.checkNotNull(optional, "enableTagOverride");
    if (this.enableTagOverride.equals(value)) return this;
    return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRegistration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRegistration
        && equalTo((ImmutableRegistration) another);
  }

  private boolean equalTo(ImmutableRegistration another) {
    return name.equals(another.name)
        && id.equals(another.id)
        && address.equals(another.address)
        && port.equals(another.port)
        && check.equals(another.check)
        && checks.equals(another.checks)
        && tags.equals(another.tags)
        && enableTagOverride.equals(another.enableTagOverride);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}, {@code address}, {@code port}, {@code check}, {@code checks}, {@code tags}, {@code enableTagOverride}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + port.hashCode();
    h = h * 17 + check.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + tags.hashCode();
    h = h * 17 + enableTagOverride.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Registration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Registration")
        .omitNullValues()
        .add("name", name)
        .add("id", id)
        .add("address", address.orNull())
        .add("port", port.orNull())
        .add("check", check.orNull())
        .add("checks", checks)
        .add("tags", tags)
        .add("enableTagOverride", enableTagOverride.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Registration {
    @Nullable String name;
    @Nullable String id;
    Optional<String> address = Optional.absent();
    Optional<Integer> port = Optional.absent();
    Optional<Registration.RegCheck> check = Optional.absent();
    List<Registration.RegCheck> checks = ImmutableList.of();
    List<String> tags = ImmutableList.of();
    Optional<Boolean> enableTagOverride = Optional.absent();
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Address")
    public void setAddress(Optional<String> address) {
      this.address = address;
    }
    @JsonProperty(value = "Port")
    public void setPort(Optional<Integer> port) {
      this.port = port;
    }
    @JsonProperty(value = "Check")
    public void setCheck(Optional<Registration.RegCheck> check) {
      this.check = check;
    }
    @JsonProperty(value = "Checks")
    public void setChecks(List<Registration.RegCheck> checks) {
      this.checks = checks;
    }
    @JsonProperty(value = "Tags")
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty(value = "EnableTagOverride")
    public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Registration.RegCheck> getCheck() { throw new UnsupportedOperationException(); }
    @Override
    public List<Registration.RegCheck> getChecks() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getEnableTagOverride() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableRegistration fromJson(Json json) {
    ImmutableRegistration.Builder builder = ImmutableRegistration.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.check != null) {
      builder.check(json.check);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.enableTagOverride != null) {
      builder.enableTagOverride(json.enableTagOverride);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Registration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Registration instance
   */
  public static ImmutableRegistration copyOf(Registration instance) {
    if (instance instanceof ImmutableRegistration) {
      return (ImmutableRegistration) instance;
    }
    return ImmutableRegistration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRegistration ImmutableRegistration}.
   * @return A new ImmutableRegistration builder
   */
  public static ImmutableRegistration.Builder builder() {
    return new ImmutableRegistration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRegistration ImmutableRegistration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3;

    private @Nullable String name;
    private @Nullable String id;
    private Optional<String> address = Optional.absent();
    private Optional<Integer> port = Optional.absent();
    private Optional<Registration.RegCheck> check = Optional.absent();
    private ImmutableList.Builder<Registration.RegCheck> checksBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
    private Optional<Boolean> enableTagOverride = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Registration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Registration instance) {
      Preconditions.checkNotNull(instance, "instance");
      name(instance.getName());
      id(instance.getId());
      Optional<String> addressOptional = instance.getAddress();
      if (addressOptional.isPresent()) {
        address(addressOptional);
      }
      Optional<Integer> portOptional = instance.getPort();
      if (portOptional.isPresent()) {
        port(portOptional);
      }
      Optional<Registration.RegCheck> checkOptional = instance.getCheck();
      if (checkOptional.isPresent()) {
        check(checkOptional);
      }
      addAllChecks(instance.getChecks());
      addAllTags(instance.getTags());
      Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
      if (enableTagOverrideOptional.isPresent()) {
        enableTagOverride(enableTagOverrideOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Registration#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Registration#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getAddress() address} to address.
     * @param address The value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Optional.of(address);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getAddress() address} to address.
     * @param address The value for address
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder address(Optional<String> address) {
      this.address = Preconditions.checkNotNull(address, "address");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = Optional.of(port);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = Preconditions.checkNotNull(port, "port");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getCheck() check} to check.
     * @param check The value for check
     * @return {@code this} builder for chained invocation
     */
    public final Builder check(Registration.RegCheck check) {
      this.check = Optional.of(check);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getCheck() check} to check.
     * @param check The value for check
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder check(Optional<Registration.RegCheck> check) {
      this.check = Preconditions.checkNotNull(check, "check");
      return this;
    }

    /**
     * Adds one element to {@link Registration#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(Registration.RegCheck element) {
      checksBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Registration#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(Registration.RegCheck... elements) {
      checksBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Registration#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checks(Iterable<? extends Registration.RegCheck> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link Registration#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChecks(Iterable<? extends Registration.RegCheck> elements) {
      checksBuilder.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Registration#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String element) {
      tagsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Registration#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String... elements) {
      tagsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Registration#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(Iterable<String> elements) {
      tagsBuilder = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link Registration#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      tagsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for chained invocation
     */
    public final Builder enableTagOverride(boolean enableTagOverride) {
      this.enableTagOverride = Optional.of(enableTagOverride);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = Preconditions.checkNotNull(enableTagOverride, "enableTagOverride");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRegistration ImmutableRegistration}.
     * @return An immutable instance of Registration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRegistration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRegistration(name, id, address, port, check, checksBuilder.build(), tagsBuilder.build(), enableTagOverride);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Registration, some of required attributes are not set " + attributes;
    }
  }
}
