package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AclResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAclResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AclResponse"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAclResponse extends AclResponse {
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;
  private final Optional<String> id;
  private final Optional<String> name;
  private final Optional<String> type;
  private final Optional<String> rules;

  private ImmutableAclResponse(
      BigInteger createIndex,
      BigInteger modifyIndex,
      Optional<String> id,
      Optional<String> name,
      Optional<String> type,
      Optional<String> rules) {
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.id = id;
    this.name = name;
    this.type = type;
    this.rules = rules;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty(value = "CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty(value = "ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public Optional<String> id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public Optional<String> name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty(value = "Type")
  @Override
  public Optional<String> type() {
    return type;
  }

  /**
   * @return The value of the {@code rules} attribute
   */
  @JsonProperty(value = "Rules")
  @Override
  public Optional<String> rules() {
    return rules;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AclResponse#createIndex() createIndex} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAclResponse withCreateIndex(BigInteger value) {
    if (this.createIndex == value) return this;
    return new ImmutableAclResponse(
        Preconditions.checkNotNull(value, "createIndex"),
        this.modifyIndex,
        this.id,
        this.name,
        this.type,
        this.rules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AclResponse#modifyIndex() modifyIndex} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAclResponse withModifyIndex(BigInteger value) {
    if (this.modifyIndex == value) return this;
    return new ImmutableAclResponse(
        this.createIndex,
        Preconditions.checkNotNull(value, "modifyIndex"),
        this.id,
        this.name,
        this.type,
        this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withId(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.id.equals(newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, newValue, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#id() id} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withId(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "id");
    if (this.id.equals(value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, value, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#name() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withName(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.name.equals(newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, newValue, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#name() name} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withName(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "name");
    if (this.name.equals(value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, value, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#type() type} attribute.
   * @param value The value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withType(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.type.equals(newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, newValue, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#type() type} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withType(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "type");
    if (this.type.equals(value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, value, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#rules() rules} attribute.
   * @param value The value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withRules(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.rules.equals(newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#rules() rules} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withRules(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "rules");
    if (this.rules.equals(value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAclResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAclResponse
        && equalTo((ImmutableAclResponse) another);
  }

  private boolean equalTo(ImmutableAclResponse another) {
    return createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex)
        && id.equals(another.id)
        && name.equals(another.name)
        && type.equals(another.type)
        && rules.equals(another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code createIndex}, {@code modifyIndex}, {@code id}, {@code name}, {@code type}, {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + createIndex.hashCode();
    h = h * 17 + modifyIndex.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + rules.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AclResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AclResponse")
        .omitNullValues()
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("id", id.orNull())
        .add("name", name.orNull())
        .add("type", type.orNull())
        .add("rules", rules.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends AclResponse {
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    Optional<String> id = Optional.absent();
    Optional<String> name = Optional.absent();
    Optional<String> type = Optional.absent();
    Optional<String> rules = Optional.absent();
    @JsonProperty(value = "CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty(value = "ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty(value = "ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty(value = "Type")
    public void setType(Optional<String> type) {
      this.type = type;
    }
    @JsonProperty(value = "Rules")
    public void setRules(Optional<String> rules) {
      this.rules = rules;
    }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> type() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rules() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableAclResponse fromJson(Json json) {
    ImmutableAclResponse.Builder builder = ImmutableAclResponse.builder();
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.rules != null) {
      builder.rules(json.rules);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AclResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AclResponse instance
   */
  public static ImmutableAclResponse copyOf(AclResponse instance) {
    if (instance instanceof ImmutableAclResponse) {
      return (ImmutableAclResponse) instance;
    }
    return ImmutableAclResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAclResponse ImmutableAclResponse}.
   * @return A new ImmutableAclResponse builder
   */
  public static ImmutableAclResponse.Builder builder() {
    return new ImmutableAclResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAclResponse ImmutableAclResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATE_INDEX = 0x1L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x2L;
    private long initBits = 0x3;

    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;
    private Optional<String> id = Optional.absent();
    private Optional<String> name = Optional.absent();
    private Optional<String> type = Optional.absent();
    private Optional<String> rules = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AclResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AclResponse instance) {
      Preconditions.checkNotNull(instance, "instance");
      createIndex(instance.createIndex());
      modifyIndex(instance.modifyIndex());
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> nameOptional = instance.name();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      Optional<String> typeOptional = instance.type();
      if (typeOptional.isPresent()) {
        type(typeOptional);
      }
      Optional<String> rulesOptional = instance.rules();
      if (rulesOptional.isPresent()) {
        rules(rulesOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AclResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Preconditions.checkNotNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link AclResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Preconditions.checkNotNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(Optional<String> id) {
      this.id = Preconditions.checkNotNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = Preconditions.checkNotNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(String type) {
      this.type = Optional.of(type);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Optional<String> type) {
      this.type = Preconditions.checkNotNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for chained invocation
     */
    public final Builder rules(String rules) {
      this.rules = Optional.of(rules);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Optional<String> rules) {
      this.rules = Preconditions.checkNotNull(rules, "rules");
      return this;
    }

    /**
     * Builds a new {@link ImmutableAclResponse ImmutableAclResponse}.
     * @return An immutable instance of AclResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAclResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAclResponse(createIndex, modifyIndex, id, name, type, rules);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      return "Cannot build AclResponse, some of required attributes are not set " + attributes;
    }
  }
}
