/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Check;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCheck
extends Check {
    private final String id;
    private final String name;
    private final Optional<String> notes;
    private final Optional<String> output;
    private final Optional<String> script;
    private final Optional<String> interval;
    private final Optional<String> ttl;
    private final Optional<String> http;
    private final Optional<String> tcp;
    private final Optional<String> serviceId;
    private final ImmutableList<String> serviceTags;
    private final Optional<String> deregisterCriticalServiceAfter;

    private ImmutableCheck(String id, String name, Optional<String> notes, Optional<String> output, Optional<String> script, Optional<String> interval, Optional<String> ttl, Optional<String> http, Optional<String> tcp, Optional<String> serviceId, ImmutableList<String> serviceTags, Optional<String> deregisterCriticalServiceAfter) {
        this.id = id;
        this.name = name;
        this.notes = notes;
        this.output = output;
        this.script = script;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
        this.serviceId = serviceId;
        this.serviceTags = serviceTags;
        this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="Script")
    public Optional<String> getScript() {
        return this.script;
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return this.ttl;
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return this.http;
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return this.tcp;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @Override
    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public Optional<String> getDeregisterCriticalServiceAfter() {
        return this.deregisterCriticalServiceAfter;
    }

    public final ImmutableCheck withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.notes.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, (Optional<String>)newValue, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"notes");
        if (this.notes.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, (Optional<String>)value, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.output.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, (Optional<String>)newValue, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"output");
        if (this.output.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, (Optional<String>)value, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withScript(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.script.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, (Optional<String>)newValue, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withScript(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"script");
        if (this.script.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, (Optional<String>)value, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.interval.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, (Optional<String>)newValue, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"interval");
        if (this.interval.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, (Optional<String>)value, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.ttl.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, (Optional<String>)newValue, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"ttl");
        if (this.ttl.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, (Optional<String>)value, this.http, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.http.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, (Optional<String>)newValue, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"http");
        if (this.http.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, (Optional<String>)value, this.tcp, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tcp.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, (Optional<String>)newValue, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tcp");
        if (this.tcp.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, (Optional<String>)value, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, (Optional<String>)newValue, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceId");
        if (this.serviceId.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, (Optional<String>)value, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.deregisterCriticalServiceAfter.equals((Object)newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, (Optional<String>)newValue));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"deregisterCriticalServiceAfter");
        if (this.deregisterCriticalServiceAfter.equals((Object)value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTags, (Optional<String>)value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalTo((ImmutableCheck)another);
    }

    private boolean equalTo(ImmutableCheck another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.notes.equals(another.notes) && this.output.equals(another.output) && this.script.equals(another.script) && this.interval.equals(another.interval) && this.ttl.equals(another.ttl) && this.http.equals(another.http) && this.tcp.equals(another.tcp) && this.serviceId.equals(another.serviceId) && this.serviceTags.equals(another.serviceTags) && this.deregisterCriticalServiceAfter.equals(another.deregisterCriticalServiceAfter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.notes.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.script.hashCode();
        h = h * 17 + this.interval.hashCode();
        h = h * 17 + this.ttl.hashCode();
        h = h * 17 + this.http.hashCode();
        h = h * 17 + this.tcp.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.serviceTags.hashCode();
        h = h * 17 + this.deregisterCriticalServiceAfter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("notes", this.notes.orNull()).add("output", this.output.orNull()).add("script", this.script.orNull()).add("interval", this.interval.orNull()).add("ttl", this.ttl.orNull()).add("http", this.http.orNull()).add("tcp", this.tcp.orNull()).add("serviceId", this.serviceId.orNull()).add("serviceTags", this.serviceTags).add("deregisterCriticalServiceAfter", this.deregisterCriticalServiceAfter.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCheck fromJson(Json json) {
        Builder builder = ImmutableCheck.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.script != null) {
            builder.script(json.script);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.http != null) {
            builder.http(json.http);
        }
        if (json.tcp != null) {
            builder.tcp(json.tcp);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.deregisterCriticalServiceAfter != null) {
            builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
        }
        return builder.build();
    }

    private static ImmutableCheck validate(ImmutableCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private Optional<String> notes = Optional.absent();
        private Optional<String> output = Optional.absent();
        private Optional<String> script = Optional.absent();
        private Optional<String> interval = Optional.absent();
        private Optional<String> ttl = Optional.absent();
        private Optional<String> http = Optional.absent();
        private Optional<String> tcp = Optional.absent();
        private Optional<String> serviceId = Optional.absent();
        private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
        private Optional<String> deregisterCriticalServiceAfter = Optional.absent();

        private Builder() {
        }

        public final Builder from(Check instance) {
            Optional<String> serviceIdOptional;
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Optional<String> scriptOptional;
            Optional<String> outputOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((scriptOptional = instance.getScript()).isPresent()) {
                this.script(scriptOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            this.addAllServiceTags(instance.getServiceTags());
            Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
            if (deregisterCriticalServiceAfterOptional.isPresent()) {
                this.deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = Optional.of((Object)notes);
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = (Optional)Preconditions.checkNotNull(notes, (Object)"notes");
            return this;
        }

        public final Builder output(String output) {
            this.output = Optional.of((Object)output);
            return this;
        }

        public final Builder output(Optional<String> output) {
            this.output = (Optional)Preconditions.checkNotNull(output, (Object)"output");
            return this;
        }

        public final Builder script(String script) {
            this.script = Optional.of((Object)script);
            return this;
        }

        public final Builder script(Optional<String> script) {
            this.script = (Optional)Preconditions.checkNotNull(script, (Object)"script");
            return this;
        }

        public final Builder interval(String interval) {
            this.interval = Optional.of((Object)interval);
            return this;
        }

        public final Builder interval(Optional<String> interval) {
            this.interval = (Optional)Preconditions.checkNotNull(interval, (Object)"interval");
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Optional.of((Object)ttl);
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = (Optional)Preconditions.checkNotNull(ttl, (Object)"ttl");
            return this;
        }

        public final Builder http(String http) {
            this.http = Optional.of((Object)http);
            return this;
        }

        public final Builder http(Optional<String> http) {
            this.http = (Optional)Preconditions.checkNotNull(http, (Object)"http");
            return this;
        }

        public final Builder tcp(String tcp) {
            this.tcp = Optional.of((Object)tcp);
            return this;
        }

        public final Builder tcp(Optional<String> tcp) {
            this.tcp = (Optional)Preconditions.checkNotNull(tcp, (Object)"tcp");
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Optional.of((Object)serviceId);
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = (Optional)Preconditions.checkNotNull(serviceId, (Object)"serviceId");
            return this;
        }

        public final Builder addServiceTags(String element) {
            this.serviceTagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addServiceTags(String ... elements) {
            this.serviceTagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTagsBuilder = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTagsBuilder.addAll(elements);
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = Optional.of((Object)deregisterCriticalServiceAfter);
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = (Optional)Preconditions.checkNotNull(deregisterCriticalServiceAfter, (Object)"deregisterCriticalServiceAfter");
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.serviceId, this.serviceTagsBuilder.build(), this.deregisterCriticalServiceAfter));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Check, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Check {
        @Nullable
        String id;
        @Nullable
        String name;
        Optional<String> notes = Optional.absent();
        Optional<String> output = Optional.absent();
        Optional<String> script = Optional.absent();
        Optional<String> interval = Optional.absent();
        Optional<String> ttl = Optional.absent();
        Optional<String> http = Optional.absent();
        Optional<String> tcp = Optional.absent();
        Optional<String> serviceId = Optional.absent();
        List<String> serviceTags = ImmutableList.of();
        Optional<String> deregisterCriticalServiceAfter = Optional.absent();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="Script")
        public void setScript(Optional<String> script) {
            this.script = script;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this.interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this.http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this.tcp = tcp;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getScript() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDeregisterCriticalServiceAfter() {
            throw new UnsupportedOperationException();
        }
    }
}

