package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Config}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableConfig.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Config"})
public final class ImmutableConfig extends Config {
  private final boolean bootstrap;
  private final boolean server;
  private final String datacenter;
  private final String dataDir;
  private final String dnsRecursor;
  private final String domain;
  private final String logLevel;
  private final String nodeName;
  private final String clientAddr;
  private final String bindAddr;
  private final String advertiseAddr;
  private final Ports ports;
  private final boolean leaveOnTerm;
  private final boolean skipLeaveOnInt;
  private final String statsiteAddr;
  private final int protocol;
  private final boolean enableDebug;
  private final boolean verifyIncoming;
  private final boolean verifyOutgoing;
  private final String caFile;
  private final String certFile;
  private final String keyFile;
  private final ImmutableList<String> startJoin;
  private final String uiDir;
  private final String pidFile;
  private final boolean enableSyslog;
  private final boolean rejoinAfterLeave;

  private ImmutableConfig(
      boolean bootstrap,
      boolean server,
      String datacenter,
      String dataDir,
      String dnsRecursor,
      String domain,
      String logLevel,
      String nodeName,
      String clientAddr,
      String bindAddr,
      String advertiseAddr,
      Ports ports,
      boolean leaveOnTerm,
      boolean skipLeaveOnInt,
      String statsiteAddr,
      int protocol,
      boolean enableDebug,
      boolean verifyIncoming,
      boolean verifyOutgoing,
      String caFile,
      String certFile,
      String keyFile,
      ImmutableList<String> startJoin,
      String uiDir,
      String pidFile,
      boolean enableSyslog,
      boolean rejoinAfterLeave) {
    this.bootstrap = bootstrap;
    this.server = server;
    this.datacenter = datacenter;
    this.dataDir = dataDir;
    this.dnsRecursor = dnsRecursor;
    this.domain = domain;
    this.logLevel = logLevel;
    this.nodeName = nodeName;
    this.clientAddr = clientAddr;
    this.bindAddr = bindAddr;
    this.advertiseAddr = advertiseAddr;
    this.ports = ports;
    this.leaveOnTerm = leaveOnTerm;
    this.skipLeaveOnInt = skipLeaveOnInt;
    this.statsiteAddr = statsiteAddr;
    this.protocol = protocol;
    this.enableDebug = enableDebug;
    this.verifyIncoming = verifyIncoming;
    this.verifyOutgoing = verifyOutgoing;
    this.caFile = caFile;
    this.certFile = certFile;
    this.keyFile = keyFile;
    this.startJoin = startJoin;
    this.uiDir = uiDir;
    this.pidFile = pidFile;
    this.enableSyslog = enableSyslog;
    this.rejoinAfterLeave = rejoinAfterLeave;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code bootstrap} attribute
   */
  @JsonProperty("Bootstrap")
  @Override
  public boolean getBootstrap() {
    return bootstrap;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code server} attribute
   */
  @JsonProperty("Server")
  @Override
  public boolean getServer() {
    return server;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dataDir} attribute
   */
  @JsonProperty("DataDir")
  @Override
  public String getDataDir() {
    return dataDir;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dnsRecursor} attribute
   */
  @JsonProperty("DNSRecursor")
  @Override
  public String dnsRecursor() {
    return dnsRecursor;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code domain} attribute
   */
  @JsonProperty("Domain")
  @Override
  public String getDomain() {
    return domain;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code logLevel} attribute
   */
  @JsonProperty("LogLevel")
  @Override
  public String getLogLevel() {
    return logLevel;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code nodeName} attribute
   */
  @JsonProperty("NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code clientAddr} attribute
   */
  @JsonProperty("ClientAddr")
  @Override
  public String getClientAddr() {
    return clientAddr;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code bindAddr} attribute
   */
  @JsonProperty("BindAddr")
  @Override
  public String getBindAddr() {
    return bindAddr;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code advertiseAddr} attribute
   */
  @JsonProperty("AdvertiseAddr")
  @Override
  public String getAdvertiseAddr() {
    return advertiseAddr;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ports} attribute
   */
  @JsonProperty("Ports")
  @Override
  public Ports getPorts() {
    return ports;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code leaveOnTerm} attribute
   */
  @JsonProperty("LeaveOnTerm")
  @Override
  public boolean getLeaveOnTerm() {
    return leaveOnTerm;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code skipLeaveOnInt} attribute
   */
  @JsonProperty("SkipLeaveOnInt")
  @Override
  public boolean getSkipLeaveOnInt() {
    return skipLeaveOnInt;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code statsiteAddr} attribute
   */
  @JsonProperty("StatsiteAddr")
  @Override
  public String getStatsiteAddr() {
    return statsiteAddr;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code protocol} attribute
   */
  @JsonProperty("Protocol")
  @Override
  public int getProtocol() {
    return protocol;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enableDebug} attribute
   */
  @JsonProperty("EnableDebug")
  @Override
  public boolean getEnableDebug() {
    return enableDebug;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code verifyIncoming} attribute
   */
  @JsonProperty("VerifyIncoming")
  @Override
  public boolean getVerifyIncoming() {
    return verifyIncoming;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code verifyOutgoing} attribute
   */
  @JsonProperty("VerifyOutgoing")
  @Override
  public boolean getVerifyOutgoing() {
    return verifyOutgoing;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code caFile} attribute
   */
  @JsonProperty("CAFile")
  @Override
  public String getCaFile() {
    return caFile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code certFile} attribute
   */
  @JsonProperty("CertFile")
  @Override
  public String getCertFile() {
    return certFile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code keyFile} attribute
   */
  @JsonProperty("KeyFile")
  @Override
  public String getKeyFile() {
    return keyFile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code startJoin} attribute
   */
  @JsonProperty("StartJoin")
  @Override
  public ImmutableList<String> getStartJoin() {
    return startJoin;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code uiDir} attribute
   */
  @JsonProperty("UiDir")
  @Override
  public String getUiDir() {
    return uiDir;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pidFile} attribute
   */
  @JsonProperty("PidFile")
  @Override
  public String getPidFile() {
    return pidFile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enableSyslog} attribute
   */
  @JsonProperty("EnableSyslog")
  @Override
  public boolean getEnableSyslog() {
    return enableSyslog;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rejoinAfterLeave} attribute
   */
  @JsonProperty("RejoinAfterLeave")
  @Override
  public boolean getRejoinAfterLeave() {
    return rejoinAfterLeave;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getBootstrap() bootstrap}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for bootstrap
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withBootstrap(boolean value) {
    if (this.bootstrap == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        newValue,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getServer() server}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for server
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withServer(boolean value) {
    if (this.server == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        newValue,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getDatacenter() datacenter}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for datacenter
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withDatacenter(String value) {
    if (this.datacenter == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        newValue,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getDataDir() dataDir}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for dataDir
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withDataDir(String value) {
    if (this.dataDir == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        newValue,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#dnsRecursor() dnsRecursor}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for dnsRecursor
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withDnsRecursor(String value) {
    if (this.dnsRecursor == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        newValue,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getDomain() domain}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for domain
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withDomain(String value) {
    if (this.domain == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        newValue,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getLogLevel() logLevel}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for logLevel
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withLogLevel(String value) {
    if (this.logLevel == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        newValue,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getNodeName() nodeName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for nodeName
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withNodeName(String value) {
    if (this.nodeName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        newValue,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getClientAddr() clientAddr}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for clientAddr
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withClientAddr(String value) {
    if (this.clientAddr == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        newValue,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getBindAddr() bindAddr}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for bindAddr
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withBindAddr(String value) {
    if (this.bindAddr == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        newValue,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getAdvertiseAddr() advertiseAddr}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for advertiseAddr
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withAdvertiseAddr(String value) {
    if (this.advertiseAddr == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        newValue,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getPorts() ports}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for ports
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withPorts(Ports value) {
    if (this.ports == value) {
      return this;
    }
    Ports newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        newValue,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getLeaveOnTerm() leaveOnTerm}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for leaveOnTerm
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withLeaveOnTerm(boolean value) {
    if (this.leaveOnTerm == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        newValue,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getSkipLeaveOnInt() skipLeaveOnInt}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for skipLeaveOnInt
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withSkipLeaveOnInt(boolean value) {
    if (this.skipLeaveOnInt == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        newValue,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getStatsiteAddr() statsiteAddr}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for statsiteAddr
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withStatsiteAddr(String value) {
    if (this.statsiteAddr == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        newValue,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getProtocol() protocol}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for protocol
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withProtocol(int value) {
    if (this.protocol == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        newValue,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getEnableDebug() enableDebug}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enableDebug
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withEnableDebug(boolean value) {
    if (this.enableDebug == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        newValue,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getVerifyIncoming() verifyIncoming}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for verifyIncoming
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withVerifyIncoming(boolean value) {
    if (this.verifyIncoming == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        newValue,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getVerifyOutgoing() verifyOutgoing}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for verifyOutgoing
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withVerifyOutgoing(boolean value) {
    if (this.verifyOutgoing == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        newValue,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getCaFile() caFile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for caFile
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withCaFile(String value) {
    if (this.caFile == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        newValue,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getCertFile() certFile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for certFile
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withCertFile(String value) {
    if (this.certFile == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        newValue,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getKeyFile() keyFile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for keyFile
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withKeyFile(String value) {
    if (this.keyFile == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        newValue,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Config#getStartJoin() startJoin}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableConfig withStartJoin(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Config#getStartJoin() startJoin}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of startJoin elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableConfig withStartJoin(Iterable<String> elements) {
    if (this.startJoin == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        newValue,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getUiDir() uiDir}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for uiDir
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withUiDir(String value) {
    if (this.uiDir == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        newValue,
        this.pidFile,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getPidFile() pidFile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for pidFile
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withPidFile(String value) {
    if (this.pidFile == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        newValue,
        this.enableSyslog,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getEnableSyslog() enableSyslog}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enableSyslog
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withEnableSyslog(boolean value) {
    if (this.enableSyslog == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        newValue,
        this.rejoinAfterLeave);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Config#getRejoinAfterLeave() rejoinAfterLeave}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rejoinAfterLeave
   * @return modified copy of the {@code this} object
   */
  public final ImmutableConfig withRejoinAfterLeave(boolean value) {
    if (this.rejoinAfterLeave == value) {
      return this;
    }
    boolean newValue = value;
    return new ImmutableConfig(
        this.bootstrap,
        this.server,
        this.datacenter,
        this.dataDir,
        this.dnsRecursor,
        this.domain,
        this.logLevel,
        this.nodeName,
        this.clientAddr,
        this.bindAddr,
        this.advertiseAddr,
        this.ports,
        this.leaveOnTerm,
        this.skipLeaveOnInt,
        this.statsiteAddr,
        this.protocol,
        this.enableDebug,
        this.verifyIncoming,
        this.verifyOutgoing,
        this.caFile,
        this.certFile,
        this.keyFile,
        this.startJoin,
        this.uiDir,
        this.pidFile,
        this.enableSyslog,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableConfig && equalTo((ImmutableConfig) another));
  }
  
  private boolean equalTo(ImmutableConfig another) {
    return bootstrap == another.bootstrap
        && server == another.server
        && datacenter.equals(another.datacenter)
        && dataDir.equals(another.dataDir)
        && dnsRecursor.equals(another.dnsRecursor)
        && domain.equals(another.domain)
        && logLevel.equals(another.logLevel)
        && nodeName.equals(another.nodeName)
        && clientAddr.equals(another.clientAddr)
        && bindAddr.equals(another.bindAddr)
        && advertiseAddr.equals(another.advertiseAddr)
        && ports.equals(another.ports)
        && leaveOnTerm == another.leaveOnTerm
        && skipLeaveOnInt == another.skipLeaveOnInt
        && statsiteAddr.equals(another.statsiteAddr)
        && protocol == another.protocol
        && enableDebug == another.enableDebug
        && verifyIncoming == another.verifyIncoming
        && verifyOutgoing == another.verifyOutgoing
        && caFile.equals(another.caFile)
        && certFile.equals(another.certFile)
        && keyFile.equals(another.keyFile)
        && startJoin.equals(another.startJoin)
        && uiDir.equals(another.uiDir)
        && pidFile.equals(another.pidFile)
        && enableSyslog == another.enableSyslog
        && rejoinAfterLeave == another.rejoinAfterLeave;
  }
  
  /**
   * Computes hash code from attributes: {@code bootstrap}, {@code server}, {@code datacenter}, {@code dataDir}, {@code dnsRecursor}, {@code domain}, {@code logLevel}, {@code nodeName}, {@code clientAddr}, {@code bindAddr}, {@code advertiseAddr}, {@code ports}, {@code leaveOnTerm}, {@code skipLeaveOnInt}, {@code statsiteAddr}, {@code protocol}, {@code enableDebug}, {@code verifyIncoming}, {@code verifyOutgoing}, {@code caFile}, {@code certFile}, {@code keyFile}, {@code startJoin}, {@code uiDir}, {@code pidFile}, {@code enableSyslog}, {@code rejoinAfterLeave}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(bootstrap);
    h = h * 17 + Booleans.hashCode(server);
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + dataDir.hashCode();
    h = h * 17 + dnsRecursor.hashCode();
    h = h * 17 + domain.hashCode();
    h = h * 17 + logLevel.hashCode();
    h = h * 17 + nodeName.hashCode();
    h = h * 17 + clientAddr.hashCode();
    h = h * 17 + bindAddr.hashCode();
    h = h * 17 + advertiseAddr.hashCode();
    h = h * 17 + ports.hashCode();
    h = h * 17 + Booleans.hashCode(leaveOnTerm);
    h = h * 17 + Booleans.hashCode(skipLeaveOnInt);
    h = h * 17 + statsiteAddr.hashCode();
    h = h * 17 + protocol;
    h = h * 17 + Booleans.hashCode(enableDebug);
    h = h * 17 + Booleans.hashCode(verifyIncoming);
    h = h * 17 + Booleans.hashCode(verifyOutgoing);
    h = h * 17 + caFile.hashCode();
    h = h * 17 + certFile.hashCode();
    h = h * 17 + keyFile.hashCode();
    h = h * 17 + startJoin.hashCode();
    h = h * 17 + uiDir.hashCode();
    h = h * 17 + pidFile.hashCode();
    h = h * 17 + Booleans.hashCode(enableSyslog);
    h = h * 17 + Booleans.hashCode(rejoinAfterLeave);
    return h;
  }
  
  /**
   * Prints immutable value {@code Config{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Config")
        .add("bootstrap", bootstrap)
        .add("server", server)
        .add("datacenter", datacenter)
        .add("dataDir", dataDir)
        .add("dnsRecursor", dnsRecursor)
        .add("domain", domain)
        .add("logLevel", logLevel)
        .add("nodeName", nodeName)
        .add("clientAddr", clientAddr)
        .add("bindAddr", bindAddr)
        .add("advertiseAddr", advertiseAddr)
        .add("ports", ports)
        .add("leaveOnTerm", leaveOnTerm)
        .add("skipLeaveOnInt", skipLeaveOnInt)
        .add("statsiteAddr", statsiteAddr)
        .add("protocol", protocol)
        .add("enableDebug", enableDebug)
        .add("verifyIncoming", verifyIncoming)
        .add("verifyOutgoing", verifyOutgoing)
        .add("caFile", caFile)
        .add("certFile", certFile)
        .add("keyFile", keyFile)
        .add("startJoin", startJoin)
        .add("uiDir", uiDir)
        .add("pidFile", pidFile)
        .add("enableSyslog", enableSyslog)
        .add("rejoinAfterLeave", rejoinAfterLeave)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableConfig fromAllAttributes(
      @JsonProperty("Bootstrap") Boolean bootstrap,
      @JsonProperty("Server") Boolean server,
      @JsonProperty("Datacenter") String datacenter,
      @JsonProperty("DataDir") String dataDir,
      @JsonProperty("DNSRecursor") String dnsRecursor,
      @JsonProperty("Domain") String domain,
      @JsonProperty("LogLevel") String logLevel,
      @JsonProperty("NodeName") String nodeName,
      @JsonProperty("ClientAddr") String clientAddr,
      @JsonProperty("BindAddr") String bindAddr,
      @JsonProperty("AdvertiseAddr") String advertiseAddr,
      @JsonProperty("Ports") Ports ports,
      @JsonProperty("LeaveOnTerm") Boolean leaveOnTerm,
      @JsonProperty("SkipLeaveOnInt") Boolean skipLeaveOnInt,
      @JsonProperty("StatsiteAddr") String statsiteAddr,
      @JsonProperty("Protocol") Integer protocol,
      @JsonProperty("EnableDebug") Boolean enableDebug,
      @JsonProperty("VerifyIncoming") Boolean verifyIncoming,
      @JsonProperty("VerifyOutgoing") Boolean verifyOutgoing,
      @JsonProperty("CAFile") String caFile,
      @JsonProperty("CertFile") String certFile,
      @JsonProperty("KeyFile") String keyFile,
      @JsonProperty("StartJoin") List<String> startJoin,
      @JsonProperty("UiDir") String uiDir,
      @JsonProperty("PidFile") String pidFile,
      @JsonProperty("EnableSyslog") Boolean enableSyslog,
      @JsonProperty("RejoinAfterLeave") Boolean rejoinAfterLeave) {
    ImmutableConfig.Builder builder = ImmutableConfig.builder();
    if (bootstrap != null) {
      builder.bootstrap(bootstrap);
    }
    if (server != null) {
      builder.server(server);
    }
    if (datacenter != null) {
      builder.datacenter(datacenter);
    }
    if (dataDir != null) {
      builder.dataDir(dataDir);
    }
    if (dnsRecursor != null) {
      builder.dnsRecursor(dnsRecursor);
    }
    if (domain != null) {
      builder.domain(domain);
    }
    if (logLevel != null) {
      builder.logLevel(logLevel);
    }
    if (nodeName != null) {
      builder.nodeName(nodeName);
    }
    if (clientAddr != null) {
      builder.clientAddr(clientAddr);
    }
    if (bindAddr != null) {
      builder.bindAddr(bindAddr);
    }
    if (advertiseAddr != null) {
      builder.advertiseAddr(advertiseAddr);
    }
    if (ports != null) {
      builder.ports(ports);
    }
    if (leaveOnTerm != null) {
      builder.leaveOnTerm(leaveOnTerm);
    }
    if (skipLeaveOnInt != null) {
      builder.skipLeaveOnInt(skipLeaveOnInt);
    }
    if (statsiteAddr != null) {
      builder.statsiteAddr(statsiteAddr);
    }
    if (protocol != null) {
      builder.protocol(protocol);
    }
    if (enableDebug != null) {
      builder.enableDebug(enableDebug);
    }
    if (verifyIncoming != null) {
      builder.verifyIncoming(verifyIncoming);
    }
    if (verifyOutgoing != null) {
      builder.verifyOutgoing(verifyOutgoing);
    }
    if (caFile != null) {
      builder.caFile(caFile);
    }
    if (certFile != null) {
      builder.certFile(certFile);
    }
    if (keyFile != null) {
      builder.keyFile(keyFile);
    }
    if (startJoin != null) {
      builder.addAllStartJoin(startJoin);
    }
    if (uiDir != null) {
      builder.uiDir(uiDir);
    }
    if (pidFile != null) {
      builder.pidFile(pidFile);
    }
    if (enableSyslog != null) {
      builder.enableSyslog(enableSyslog);
    }
    if (rejoinAfterLeave != null) {
      builder.rejoinAfterLeave(rejoinAfterLeave);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Config}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Config instance
   */
  public static ImmutableConfig copyOf(Config instance) {
    if (instance instanceof ImmutableConfig) {
      return (ImmutableConfig) instance;
    }
    return ImmutableConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableConfig}.
   * @return new ImmutableConfig builder
   */
  public static ImmutableConfig.Builder builder() {
    return new ImmutableConfig.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3ffffff;
    private static final long INITIALIZED_BIT_BOOTSTRAP = 0x1L;
    private static final long INITIALIZED_BIT_SERVER = 0x2L;
    private static final long INITIALIZED_BIT_DATACENTER = 0x4L;
    private static final long INITIALIZED_BIT_DATA_DIR = 0x8L;
    private static final long INITIALIZED_BIT_DNS_RECURSOR = 0x10L;
    private static final long INITIALIZED_BIT_DOMAIN = 0x20L;
    private static final long INITIALIZED_BIT_LOG_LEVEL = 0x40L;
    private static final long INITIALIZED_BIT_NODE_NAME = 0x80L;
    private static final long INITIALIZED_BIT_CLIENT_ADDR = 0x100L;
    private static final long INITIALIZED_BIT_BIND_ADDR = 0x200L;
    private static final long INITIALIZED_BIT_ADVERTISE_ADDR = 0x400L;
    private static final long INITIALIZED_BIT_PORTS = 0x800L;
    private static final long INITIALIZED_BIT_LEAVE_ON_TERM = 0x1000L;
    private static final long INITIALIZED_BIT_SKIP_LEAVE_ON_INT = 0x2000L;
    private static final long INITIALIZED_BIT_STATSITE_ADDR = 0x4000L;
    private static final long INITIALIZED_BIT_PROTOCOL = 0x8000L;
    private static final long INITIALIZED_BIT_ENABLE_DEBUG = 0x10000L;
    private static final long INITIALIZED_BIT_VERIFY_INCOMING = 0x20000L;
    private static final long INITIALIZED_BIT_VERIFY_OUTGOING = 0x40000L;
    private static final long INITIALIZED_BIT_CA_FILE = 0x80000L;
    private static final long INITIALIZED_BIT_CERT_FILE = 0x100000L;
    private static final long INITIALIZED_BIT_KEY_FILE = 0x200000L;
    private static final long INITIALIZED_BIT_UI_DIR = 0x400000L;
    private static final long INITIALIZED_BIT_PID_FILE = 0x800000L;
    private static final long INITIALIZED_BIT_ENABLE_SYSLOG = 0x1000000L;
    private static final long INITIALIZED_BIT_REJOIN_AFTER_LEAVE = 0x2000000L;
    private long initializedBitset;
  
    private boolean bootstrap;
    private boolean server;
    private String datacenter;
    private String dataDir;
    private String dnsRecursor;
    private String domain;
    private String logLevel;
    private String nodeName;
    private String clientAddr;
    private String bindAddr;
    private String advertiseAddr;
    private Ports ports;
    private boolean leaveOnTerm;
    private boolean skipLeaveOnInt;
    private String statsiteAddr;
    private int protocol;
    private boolean enableDebug;
    private boolean verifyIncoming;
    private boolean verifyOutgoing;
    private String caFile;
    private String certFile;
    private String keyFile;
    private ImmutableList.Builder<String> startJoinBuilder = ImmutableList.builder();
    private String uiDir;
    private String pidFile;
    private boolean enableSyslog;
    private boolean rejoinAfterLeave;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Config} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Config instance) {
      Preconditions.checkNotNull(instance);
      bootstrap(instance.getBootstrap());
      server(instance.getServer());
      datacenter(instance.getDatacenter());
      dataDir(instance.getDataDir());
      dnsRecursor(instance.dnsRecursor());
      domain(instance.getDomain());
      logLevel(instance.getLogLevel());
      nodeName(instance.getNodeName());
      clientAddr(instance.getClientAddr());
      bindAddr(instance.getBindAddr());
      advertiseAddr(instance.getAdvertiseAddr());
      ports(instance.getPorts());
      leaveOnTerm(instance.getLeaveOnTerm());
      skipLeaveOnInt(instance.getSkipLeaveOnInt());
      statsiteAddr(instance.getStatsiteAddr());
      protocol(instance.getProtocol());
      enableDebug(instance.getEnableDebug());
      verifyIncoming(instance.getVerifyIncoming());
      verifyOutgoing(instance.getVerifyOutgoing());
      caFile(instance.getCaFile());
      certFile(instance.getCertFile());
      keyFile(instance.getKeyFile());
      addAllStartJoin(instance.getStartJoin());
      uiDir(instance.getUiDir());
      pidFile(instance.getPidFile());
      enableSyslog(instance.getEnableSyslog());
      rejoinAfterLeave(instance.getRejoinAfterLeave());
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getBootstrap() bootstrap}.
     * @param bootstrap value for bootstrap
     * @return {@code this} builder for chained invocation
     */
    public final Builder bootstrap(boolean bootstrap) {
      this.bootstrap = bootstrap;
      initializedBitset |= INITIALIZED_BIT_BOOTSTRAP;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getServer() server}.
     * @param server value for server
     * @return {@code this} builder for chained invocation
     */
    public final Builder server(boolean server) {
      this.server = server;
      initializedBitset |= INITIALIZED_BIT_SERVER;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getDatacenter() datacenter}.
     * @param datacenter value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter);
      initializedBitset |= INITIALIZED_BIT_DATACENTER;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getDataDir() dataDir}.
     * @param dataDir value for dataDir
     * @return {@code this} builder for chained invocation
     */
    public final Builder dataDir(String dataDir) {
      this.dataDir = Preconditions.checkNotNull(dataDir);
      initializedBitset |= INITIALIZED_BIT_DATA_DIR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#dnsRecursor() dnsRecursor}.
     * @param dnsRecursor value for dnsRecursor
     * @return {@code this} builder for chained invocation
     */
    public final Builder dnsRecursor(String dnsRecursor) {
      this.dnsRecursor = Preconditions.checkNotNull(dnsRecursor);
      initializedBitset |= INITIALIZED_BIT_DNS_RECURSOR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getDomain() domain}.
     * @param domain value for domain
     * @return {@code this} builder for chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Preconditions.checkNotNull(domain);
      initializedBitset |= INITIALIZED_BIT_DOMAIN;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getLogLevel() logLevel}.
     * @param logLevel value for logLevel
     * @return {@code this} builder for chained invocation
     */
    public final Builder logLevel(String logLevel) {
      this.logLevel = Preconditions.checkNotNull(logLevel);
      initializedBitset |= INITIALIZED_BIT_LOG_LEVEL;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getNodeName() nodeName}.
     * @param nodeName value for nodeName
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeName(String nodeName) {
      this.nodeName = Preconditions.checkNotNull(nodeName);
      initializedBitset |= INITIALIZED_BIT_NODE_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getClientAddr() clientAddr}.
     * @param clientAddr value for clientAddr
     * @return {@code this} builder for chained invocation
     */
    public final Builder clientAddr(String clientAddr) {
      this.clientAddr = Preconditions.checkNotNull(clientAddr);
      initializedBitset |= INITIALIZED_BIT_CLIENT_ADDR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getBindAddr() bindAddr}.
     * @param bindAddr value for bindAddr
     * @return {@code this} builder for chained invocation
     */
    public final Builder bindAddr(String bindAddr) {
      this.bindAddr = Preconditions.checkNotNull(bindAddr);
      initializedBitset |= INITIALIZED_BIT_BIND_ADDR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getAdvertiseAddr() advertiseAddr}.
     * @param advertiseAddr value for advertiseAddr
     * @return {@code this} builder for chained invocation
     */
    public final Builder advertiseAddr(String advertiseAddr) {
      this.advertiseAddr = Preconditions.checkNotNull(advertiseAddr);
      initializedBitset |= INITIALIZED_BIT_ADVERTISE_ADDR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getPorts() ports}.
     * @param ports value for ports
     * @return {@code this} builder for chained invocation
     */
    public final Builder ports(Ports ports) {
      this.ports = Preconditions.checkNotNull(ports);
      initializedBitset |= INITIALIZED_BIT_PORTS;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getLeaveOnTerm() leaveOnTerm}.
     * @param leaveOnTerm value for leaveOnTerm
     * @return {@code this} builder for chained invocation
     */
    public final Builder leaveOnTerm(boolean leaveOnTerm) {
      this.leaveOnTerm = leaveOnTerm;
      initializedBitset |= INITIALIZED_BIT_LEAVE_ON_TERM;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getSkipLeaveOnInt() skipLeaveOnInt}.
     * @param skipLeaveOnInt value for skipLeaveOnInt
     * @return {@code this} builder for chained invocation
     */
    public final Builder skipLeaveOnInt(boolean skipLeaveOnInt) {
      this.skipLeaveOnInt = skipLeaveOnInt;
      initializedBitset |= INITIALIZED_BIT_SKIP_LEAVE_ON_INT;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getStatsiteAddr() statsiteAddr}.
     * @param statsiteAddr value for statsiteAddr
     * @return {@code this} builder for chained invocation
     */
    public final Builder statsiteAddr(String statsiteAddr) {
      this.statsiteAddr = Preconditions.checkNotNull(statsiteAddr);
      initializedBitset |= INITIALIZED_BIT_STATSITE_ADDR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getProtocol() protocol}.
     * @param protocol value for protocol
     * @return {@code this} builder for chained invocation
     */
    public final Builder protocol(int protocol) {
      this.protocol = protocol;
      initializedBitset |= INITIALIZED_BIT_PROTOCOL;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getEnableDebug() enableDebug}.
     * @param enableDebug value for enableDebug
     * @return {@code this} builder for chained invocation
     */
    public final Builder enableDebug(boolean enableDebug) {
      this.enableDebug = enableDebug;
      initializedBitset |= INITIALIZED_BIT_ENABLE_DEBUG;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getVerifyIncoming() verifyIncoming}.
     * @param verifyIncoming value for verifyIncoming
     * @return {@code this} builder for chained invocation
     */
    public final Builder verifyIncoming(boolean verifyIncoming) {
      this.verifyIncoming = verifyIncoming;
      initializedBitset |= INITIALIZED_BIT_VERIFY_INCOMING;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getVerifyOutgoing() verifyOutgoing}.
     * @param verifyOutgoing value for verifyOutgoing
     * @return {@code this} builder for chained invocation
     */
    public final Builder verifyOutgoing(boolean verifyOutgoing) {
      this.verifyOutgoing = verifyOutgoing;
      initializedBitset |= INITIALIZED_BIT_VERIFY_OUTGOING;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getCaFile() caFile}.
     * @param caFile value for caFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder caFile(String caFile) {
      this.caFile = Preconditions.checkNotNull(caFile);
      initializedBitset |= INITIALIZED_BIT_CA_FILE;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getCertFile() certFile}.
     * @param certFile value for certFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder certFile(String certFile) {
      this.certFile = Preconditions.checkNotNull(certFile);
      initializedBitset |= INITIALIZED_BIT_CERT_FILE;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getKeyFile() keyFile}.
     * @param keyFile value for keyFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder keyFile(String keyFile) {
      this.keyFile = Preconditions.checkNotNull(keyFile);
      initializedBitset |= INITIALIZED_BIT_KEY_FILE;
      return this;
    }
  
    /**
     * Adds one element to {@link Config#getStartJoin() startJoin} list.
     * @param element startJoin element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStartJoin(String element) {
      startJoinBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Config#getStartJoin() startJoin} list.
     * @param elements array of startJoin elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStartJoin(String... elements) {
      startJoinBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link Config#getStartJoin() startJoin} list.
     * @param elements iterable of startJoin elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder startJoin(Iterable<String> elements) {
      startJoinBuilder = ImmutableList.builder();
      return addAllStartJoin(elements);
    }
  
    /**
     * Adds elements to {@link Config#getStartJoin() startJoin} list.
     * @param elements iterable of startJoin elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllStartJoin(Iterable<String> elements) {
      startJoinBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getUiDir() uiDir}.
     * @param uiDir value for uiDir
     * @return {@code this} builder for chained invocation
     */
    public final Builder uiDir(String uiDir) {
      this.uiDir = Preconditions.checkNotNull(uiDir);
      initializedBitset |= INITIALIZED_BIT_UI_DIR;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getPidFile() pidFile}.
     * @param pidFile value for pidFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Preconditions.checkNotNull(pidFile);
      initializedBitset |= INITIALIZED_BIT_PID_FILE;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getEnableSyslog() enableSyslog}.
     * @param enableSyslog value for enableSyslog
     * @return {@code this} builder for chained invocation
     */
    public final Builder enableSyslog(boolean enableSyslog) {
      this.enableSyslog = enableSyslog;
      initializedBitset |= INITIALIZED_BIT_ENABLE_SYSLOG;
      return this;
    }
  
    /**
     * Initializes value for {@link Config#getRejoinAfterLeave() rejoinAfterLeave}.
     * @param rejoinAfterLeave value for rejoinAfterLeave
     * @return {@code this} builder for chained invocation
     */
    public final Builder rejoinAfterLeave(boolean rejoinAfterLeave) {
      this.rejoinAfterLeave = rejoinAfterLeave;
      initializedBitset |= INITIALIZED_BIT_REJOIN_AFTER_LEAVE;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableConfig}.
     * @return immutable instance of Config
     */
    public ImmutableConfig build() {
      checkRequiredAttributes();
      return new ImmutableConfig(
        bootstrap,
        server,
        datacenter,
        dataDir,
        dnsRecursor,
        domain,
        logLevel,
        nodeName,
        clientAddr,
        bindAddr,
        advertiseAddr,
        ports,
        leaveOnTerm,
        skipLeaveOnInt,
        statsiteAddr,
        protocol,
        enableDebug,
        verifyIncoming,
        verifyOutgoing,
        caFile,
        certFile,
        keyFile,
        startJoinBuilder.build(),
        uiDir,
        pidFile,
        enableSyslog,
        rejoinAfterLeave);
    }
  
    private boolean bootstrapIsSet() {
      return (initializedBitset & INITIALIZED_BIT_BOOTSTRAP) != 0;
    }
  
    private boolean serverIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVER) != 0;
    }
  
    private boolean datacenterIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DATACENTER) != 0;
    }
  
    private boolean dataDirIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DATA_DIR) != 0;
    }
  
    private boolean dnsRecursorIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DNS_RECURSOR) != 0;
    }
  
    private boolean domainIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DOMAIN) != 0;
    }
  
    private boolean logLevelIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LOG_LEVEL) != 0;
    }
  
    private boolean nodeNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE_NAME) != 0;
    }
  
    private boolean clientAddrIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLIENT_ADDR) != 0;
    }
  
    private boolean bindAddrIsSet() {
      return (initializedBitset & INITIALIZED_BIT_BIND_ADDR) != 0;
    }
  
    private boolean advertiseAddrIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADVERTISE_ADDR) != 0;
    }
  
    private boolean portsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PORTS) != 0;
    }
  
    private boolean leaveOnTermIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LEAVE_ON_TERM) != 0;
    }
  
    private boolean skipLeaveOnIntIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SKIP_LEAVE_ON_INT) != 0;
    }
  
    private boolean statsiteAddrIsSet() {
      return (initializedBitset & INITIALIZED_BIT_STATSITE_ADDR) != 0;
    }
  
    private boolean protocolIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROTOCOL) != 0;
    }
  
    private boolean enableDebugIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLE_DEBUG) != 0;
    }
  
    private boolean verifyIncomingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERIFY_INCOMING) != 0;
    }
  
    private boolean verifyOutgoingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERIFY_OUTGOING) != 0;
    }
  
    private boolean caFileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CA_FILE) != 0;
    }
  
    private boolean certFileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CERT_FILE) != 0;
    }
  
    private boolean keyFileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_KEY_FILE) != 0;
    }
  
    private boolean uiDirIsSet() {
      return (initializedBitset & INITIALIZED_BIT_UI_DIR) != 0;
    }
  
    private boolean pidFileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PID_FILE) != 0;
    }
  
    private boolean enableSyslogIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLE_SYSLOG) != 0;
    }
  
    private boolean rejoinAfterLeaveIsSet() {
      return (initializedBitset & INITIALIZED_BIT_REJOIN_AFTER_LEAVE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!bootstrapIsSet()) {
        attributes.add("bootstrap");
      }
      if (!serverIsSet()) {
        attributes.add("server");
      }
      if (!datacenterIsSet()) {
        attributes.add("datacenter");
      }
      if (!dataDirIsSet()) {
        attributes.add("dataDir");
      }
      if (!dnsRecursorIsSet()) {
        attributes.add("dnsRecursor");
      }
      if (!domainIsSet()) {
        attributes.add("domain");
      }
      if (!logLevelIsSet()) {
        attributes.add("logLevel");
      }
      if (!nodeNameIsSet()) {
        attributes.add("nodeName");
      }
      if (!clientAddrIsSet()) {
        attributes.add("clientAddr");
      }
      if (!bindAddrIsSet()) {
        attributes.add("bindAddr");
      }
      if (!advertiseAddrIsSet()) {
        attributes.add("advertiseAddr");
      }
      if (!portsIsSet()) {
        attributes.add("ports");
      }
      if (!leaveOnTermIsSet()) {
        attributes.add("leaveOnTerm");
      }
      if (!skipLeaveOnIntIsSet()) {
        attributes.add("skipLeaveOnInt");
      }
      if (!statsiteAddrIsSet()) {
        attributes.add("statsiteAddr");
      }
      if (!protocolIsSet()) {
        attributes.add("protocol");
      }
      if (!enableDebugIsSet()) {
        attributes.add("enableDebug");
      }
      if (!verifyIncomingIsSet()) {
        attributes.add("verifyIncoming");
      }
      if (!verifyOutgoingIsSet()) {
        attributes.add("verifyOutgoing");
      }
      if (!caFileIsSet()) {
        attributes.add("caFile");
      }
      if (!certFileIsSet()) {
        attributes.add("certFile");
      }
      if (!keyFileIsSet()) {
        attributes.add("keyFile");
      }
      if (!uiDirIsSet()) {
        attributes.add("uiDir");
      }
      if (!pidFileIsSet()) {
        attributes.add("pidFile");
      }
      if (!enableSyslogIsSet()) {
        attributes.add("enableSyslog");
      }
      if (!rejoinAfterLeaveIsSet()) {
        attributes.add("rejoinAfterLeave");
      }
      return "Cannot build Config, some of required attributes are not set " + attributes;
    }
  }
}
