package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Node}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableNode.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Node"})
public final class ImmutableNode extends Node {
  private final String node;
  private final String address;

  private ImmutableNode(String node, String address) {
    this.node = node;
    this.address = address;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Node#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableNode withNode(String value) {
    if (this.node == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableNode(newValue, this.address);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Node#getAddress() address}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for address
   * @return modified copy of the {@code this} object
   */
  public final ImmutableNode withAddress(String value) {
    if (this.address == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableNode(this.node, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableNode} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableNode && equalTo((ImmutableNode) another));
  }
  
  private boolean equalTo(ImmutableNode another) {
    return node.equals(another.node)
        && address.equals(another.address);
  }
  
  /**
   * Computes hash code from attributes: {@code node}, {@code address}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + address.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Node{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Node")
        .add("node", node)
        .add("address", address)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableNode fromAllAttributes(
      @JsonProperty("Node") String node,
      @JsonProperty("Address") String address) {
    ImmutableNode.Builder builder = ImmutableNode.builder();
    if (node != null) {
      builder.node(node);
    }
    if (address != null) {
      builder.address(address);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Node}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Node instance
   */
  public static ImmutableNode copyOf(Node instance) {
    if (instance instanceof ImmutableNode) {
      return (ImmutableNode) instance;
    }
    return ImmutableNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.health.ImmutableNode}.
   * @return new ImmutableNode builder
   */
  public static ImmutableNode.Builder builder() {
    return new ImmutableNode.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.health.ImmutableNode}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NODE = 0x1L;
    private static final long INITIALIZED_BIT_ADDRESS = 0x2L;
    private long initializedBitset;
  
    private String node;
    private String address;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Node} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Node instance) {
      Preconditions.checkNotNull(instance);
      node(instance.getNode());
      address(instance.getAddress());
      return this;
    }
  
    /**
     * Initializes value for {@link Node#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Initializes value for {@link Node#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address);
      initializedBitset |= INITIALIZED_BIT_ADDRESS;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.health.ImmutableNode}.
     * @return immutable instance of Node
     */
    public ImmutableNode build() {
      checkRequiredAttributes();
      return new ImmutableNode(node, address);
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private boolean addressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADDRESS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      if (!addressIsSet()) {
        attributes.add("address");
      }
      return "Cannot build Node, some of required attributes are not set " + attributes;
    }
  }
}
