package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Agent}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableAgent.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Agent"})
public final class ImmutableAgent extends Agent {
  private final Config config;
  private final Member member;

  private ImmutableAgent(Config config, Member member) {
    this.config = config;
    this.member = member;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public Config getConfig() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code member} attribute
   */
  @JsonProperty("Member")
  @Override
  public Member getMember() {
    return member;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Agent#getConfig() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final ImmutableAgent withConfig(Config value) {
    if (this.config == value) {
      return this;
    }
    Config newValue = Preconditions.checkNotNull(value);
    return new ImmutableAgent(newValue, this.member);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Agent#getMember() member}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for member
   * @return modified copy of the {@code this} object
   */
  public final ImmutableAgent withMember(Member value) {
    if (this.member == value) {
      return this;
    }
    Member newValue = Preconditions.checkNotNull(value);
    return new ImmutableAgent(this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableAgent} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableAgent && equalTo((ImmutableAgent) another));
  }
  
  private boolean equalTo(ImmutableAgent another) {
    return config.equals(another.config)
        && member.equals(another.member);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code member}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + member.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Agent{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Agent")
        .add("config", config)
        .add("member", member)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableAgent fromAllAttributes(
      @JsonProperty("Config") Config config,
      @JsonProperty("Member") Member member) {
    ImmutableAgent.Builder builder = ImmutableAgent.builder();
    if (config != null) {
      builder.config(config);
    }
    if (member != null) {
      builder.member(member);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Agent}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Agent instance
   */
  public static ImmutableAgent copyOf(Agent instance) {
    if (instance instanceof ImmutableAgent) {
      return (ImmutableAgent) instance;
    }
    return ImmutableAgent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableAgent}.
   * @return new ImmutableAgent builder
   */
  public static ImmutableAgent.Builder builder() {
    return new ImmutableAgent.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableAgent}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private static final long INITIALIZED_BIT_MEMBER = 0x2L;
    private long initializedBitset;
  
    private Config config;
    private Member member;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Agent} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Agent instance) {
      Preconditions.checkNotNull(instance);
      config(instance.getConfig());
      member(instance.getMember());
      return this;
    }
  
    /**
     * Initializes value for {@link Agent#getConfig() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(Config config) {
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Initializes value for {@link Agent#getMember() member}.
     * @param member value for member
     * @return {@code this} builder for chained invocation
     */
    public final Builder member(Member member) {
      this.member = Preconditions.checkNotNull(member);
      initializedBitset |= INITIALIZED_BIT_MEMBER;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableAgent}.
     * @return immutable instance of Agent
     */
    public ImmutableAgent build() {
      checkRequiredAttributes();
      return new ImmutableAgent(config, member);
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private boolean memberIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MEMBER) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      if (!memberIsSet()) {
        attributes.add("member");
      }
      return "Cannot build Agent, some of required attributes are not set " + attributes;
    }
  }
}
