/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.base.Optional;
import com.google.common.primitives.UnsignedLongs;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.CatalogOptionsBuilder;
import com.orbitz.consul.option.PutOptions;
import com.orbitz.consul.option.PutOptionsBuilder;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.ClientUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class KeyValueClient {
    private final WebTarget webTarget;

    KeyValueClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public Optional<Value> getValue(String key) {
        return this.getValue(key, QueryOptions.BLANK);
    }

    public Optional<Value> getValue(String key, QueryOptions queryOptions) {
        WebTarget target = ClientUtil.queryConfig(this.webTarget.path(key), queryOptions);
        List values = null;
        try {
            values = (List)target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<Value>>(){});
        }
        catch (NotFoundException ex) {
            // empty catch block
        }
        return values != null && values.size() != 0 ? Optional.of(values.get(0)) : Optional.absent();
    }

    public void getValue(String key, QueryOptions queryOptions, ConsulResponseCallback<List<Value>> callback) {
        ClientUtil.response(this.webTarget.path(key), CatalogOptionsBuilder.builder().build(), queryOptions, new GenericType<List<Value>>(){}, callback);
    }

    public List<Value> getValues(String key) {
        WebTarget target = this.webTarget.path(key).queryParam("recurse", new Object[]{"true"});
        return Arrays.asList((Object[])target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Value[].class));
    }

    public void getValues(String key, QueryOptions queryOptions, ConsulResponseCallback<List<Value>> callback) {
        ClientUtil.response(this.webTarget.path(key).queryParam("recurse", new Object[]{"true"}), CatalogOptionsBuilder.builder().build(), queryOptions, new GenericType<List<Value>>(){}, callback);
    }

    public Optional<String> getValueAsString(String key) {
        Optional<Value> value = this.getValue(key);
        return value.isPresent() ? Optional.of((Object)ClientUtil.decodeBase64(((Value)value.get()).getValue())) : Optional.absent();
    }

    public List<String> getValuesAsString(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : this.getValues(key)) {
            result.add(ClientUtil.decodeBase64(value.getValue()));
        }
        return result;
    }

    public boolean putValue(String key, String value) {
        return this.putValue(key, value, 0L, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value, long flags) {
        return this.putValue(key, value, flags, PutOptions.BLANK);
    }

    private boolean putValue(String key, String value, long flags, PutOptions putOptions) {
        Integer cas = putOptions.getCas();
        String release = putOptions.getRelease();
        String acquire = putOptions.getAcquire();
        WebTarget target = this.webTarget;
        if (cas != null) {
            target = this.webTarget.queryParam("cas", new Object[]{cas});
        }
        if (!StringUtils.isEmpty((CharSequence)release)) {
            target = this.webTarget.queryParam("release", new Object[]{release});
        }
        if (!StringUtils.isEmpty((CharSequence)acquire)) {
            target = this.webTarget.queryParam("acquire", new Object[]{acquire});
        }
        if (flags != 0L) {
            target = this.webTarget.queryParam("flags", new Object[]{UnsignedLongs.toString((long)flags)});
        }
        return (Boolean)target.path(key).request().put(Entity.entity((Object)value, (MediaType)MediaType.TEXT_PLAIN_TYPE), Boolean.class);
    }

    public List<String> getKeys(String key) {
        return Arrays.asList((Object[])this.webTarget.path(key).queryParam("keys", new Object[]{"true"}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String[].class));
    }

    public void deleteKey(String key) {
        this.delete(key, Collections.EMPTY_MAP);
    }

    public void deleteKeys(String key) {
        this.delete(key, Collections.singletonMap("recurse", "true"));
    }

    private void delete(String key, Map<String, String> params) {
        Response response = this.webTarget.path(key).request().delete();
        if (response.getStatus() != 200) {
            throw new ConsulException((String)response.readEntity(String.class));
        }
    }

    public boolean acquireLock(String key, String session) {
        return this.acquireLock(key, "", session);
    }

    public boolean acquireLock(String key, String value, String session) {
        return this.putValue(key, value, 0L, PutOptionsBuilder.builder().acquire(session).build());
    }

    public Optional<String> getSession(String key) {
        Optional<Value> value = this.getValue(key);
        return value.isPresent() ? Optional.fromNullable((Object)((Value)value.get()).getSession()) : Optional.absent();
    }

    public boolean releaseLock(String key, String sessionId) {
        return this.putValue(key, "", 0L, PutOptionsBuilder.builder().release(sessionId).build());
    }
}

