package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.util.UnsignedLongDeserializer;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Value}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableValue.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Value"})
public final class ImmutableValue extends Value {
  private final long createIndex;
  private final long modifyIndex;
  private final long lockIndex;
  private final String key;
  private final long flags;
  private final Optional<String> value;
  private final Optional<String> session;

  private ImmutableValue(
      long createIndex,
      long modifyIndex,
      long lockIndex,
      String key,
      long flags,
      Optional<String> value,
      Optional<String> session) {
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.lockIndex = lockIndex;
    this.key = key;
    this.flags = flags;
    this.value = value;
    this.session = session;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public long getCreateIndex() {
    return createIndex;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public long getModifyIndex() {
    return modifyIndex;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code lockIndex} attribute
   */
  @JsonProperty("LockIndex")
  @Override
  public long getLockIndex() {
    return lockIndex;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code key} attribute
   */
  @JsonProperty("Key")
  @Override
  public String getKey() {
    return key;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code flags} attribute
   */
  @JsonDeserialize(using = UnsignedLongDeserializer.class)
  @JsonProperty("Flags")
  @Override
  public long getFlags() {
    return flags;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code value} attribute
   */
  @JsonProperty("Value")
  @Override
  public Optional<String> getValue() {
    return value;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code session} attribute
   */
  @JsonProperty("Session")
  @Override
  public Optional<String> getSession() {
    return session;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Value#getCreateIndex() createIndex}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for createIndex
   * @return modified copy of the {@code this} object
   */
  public final ImmutableValue withCreateIndex(long value) {
    if (this.createIndex == value) {
      return this;
    }
    long newValue = value;
    return new ImmutableValue(newValue, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, this.session);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Value#getModifyIndex() modifyIndex}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for modifyIndex
   * @return modified copy of the {@code this} object
   */
  public final ImmutableValue withModifyIndex(long value) {
    if (this.modifyIndex == value) {
      return this;
    }
    long newValue = value;
    return new ImmutableValue(this.createIndex, newValue, this.lockIndex, this.key, this.flags, this.value, this.session);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Value#getLockIndex() lockIndex}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for lockIndex
   * @return modified copy of the {@code this} object
   */
  public final ImmutableValue withLockIndex(long value) {
    if (this.lockIndex == value) {
      return this;
    }
    long newValue = value;
    return new ImmutableValue(this.createIndex, this.modifyIndex, newValue, this.key, this.flags, this.value, this.session);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Value#getKey() key}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for key
   * @return modified copy of the {@code this} object
   */
  public final ImmutableValue withKey(String value) {
    if (this.key == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, newValue, this.flags, this.value, this.session);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Value#getFlags() flags}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for flags
   * @return modified copy of the {@code this} object
   */
  public final ImmutableValue withFlags(long value) {
    if (this.flags == value) {
      return this;
    }
    long newValue = value;
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, newValue, this.value, this.session);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Value#getValue() value}.
   * @param value value for value
   * @return modified copy of {@code this} object
   */
  public final ImmutableValue withValue(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, newValue, this.session);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Value#getValue() value}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for value
   * @return modified copy of {@code this} object
   */
  public final ImmutableValue withValue(Optional<String> optional) {
    if (this.value == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, newValue, this.session);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Value#getSession() session}.
   * @param value value for session
   * @return modified copy of {@code this} object
   */
  public final ImmutableValue withSession(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Value#getSession() session}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for session
   * @return modified copy of {@code this} object
   */
  public final ImmutableValue withSession(Optional<String> optional) {
    if (this.session == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableValue} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableValue && equalTo((ImmutableValue) another));
  }
  
  private boolean equalTo(ImmutableValue another) {
    return createIndex == another.createIndex
        && modifyIndex == another.modifyIndex
        && lockIndex == another.lockIndex
        && key.equals(another.key)
        && flags == another.flags
        && value.equals(another.value)
        && session.equals(another.session);
  }
  
  /**
   * Computes hash code from attributes: {@code createIndex}, {@code modifyIndex}, {@code lockIndex}, {@code key}, {@code flags}, {@code value}, {@code session}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(createIndex);
    h = h * 17 + Longs.hashCode(modifyIndex);
    h = h * 17 + Longs.hashCode(lockIndex);
    h = h * 17 + key.hashCode();
    h = h * 17 + Longs.hashCode(flags);
    h = h * 17 + value.hashCode();
    h = h * 17 + session.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Value{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Value")
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("lockIndex", lockIndex)
        .add("key", key)
        .add("flags", flags)
        .add("value", value)
        .add("session", session)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableValue fromAllAttributes(
      @JsonProperty("CreateIndex") Long createIndex,
      @JsonProperty("ModifyIndex") Long modifyIndex,
      @JsonProperty("LockIndex") Long lockIndex,
      @JsonProperty("Key") String key,
      @JsonDeserialize(using = UnsignedLongDeserializer.class)
      @JsonProperty("Flags") Long flags,
      @JsonProperty("Value") Optional<String> value,
      @JsonProperty("Session") Optional<String> session) {
    ImmutableValue.Builder builder = ImmutableValue.builder();
    if (createIndex != null) {
      builder.createIndex(createIndex);
    }
    if (modifyIndex != null) {
      builder.modifyIndex(modifyIndex);
    }
    if (lockIndex != null) {
      builder.lockIndex(lockIndex);
    }
    if (key != null) {
      builder.key(key);
    }
    if (flags != null) {
      builder.flags(flags);
    }
    if (value != null) {
      builder.value(value);
    }
    if (session != null) {
      builder.session(session);
    }
    return builder.build();
  }

  private volatile long lazyInitBitmap;

  private static final long VALUE_AS_STRING_LAZY_INIT_BIT = 0x1L;

  private Optional<String> valueAsString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns lazily initialized value of {@link Value#getValueAsString() valueAsString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return lazily initialized value of {@code l.name}
   */
  @Override
  public Optional<String> getValueAsString() {
    if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALUE_AS_STRING_LAZY_INIT_BIT) == 0) {
          this.valueAsString = Preconditions.checkNotNull(super.getValueAsString());
          lazyInitBitmap |= VALUE_AS_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return valueAsString;
  }
  
  /**
   * Creates immutable copy of {@link Value}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Value instance
   */
  public static ImmutableValue copyOf(Value instance) {
    if (instance instanceof ImmutableValue) {
      return (ImmutableValue) instance;
    }
    return ImmutableValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.kv.ImmutableValue}.
   * @return new ImmutableValue builder
   */
  public static ImmutableValue.Builder builder() {
    return new ImmutableValue.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.kv.ImmutableValue}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_CREATE_INDEX = 0x1L;
    private static final long INITIALIZED_BIT_MODIFY_INDEX = 0x2L;
    private static final long INITIALIZED_BIT_LOCK_INDEX = 0x4L;
    private static final long INITIALIZED_BIT_KEY = 0x8L;
    private static final long INITIALIZED_BIT_FLAGS = 0x10L;
    private long initializedBitset;
  
    private long createIndex;
    private long modifyIndex;
    private long lockIndex;
    private String key;
    private long flags;
    private Optional<String> value = Optional.absent();
    private Optional<String> session = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Value} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Value instance) {
      Preconditions.checkNotNull(instance);
      createIndex(instance.getCreateIndex());
      modifyIndex(instance.getModifyIndex());
      lockIndex(instance.getLockIndex());
      key(instance.getKey());
      flags(instance.getFlags());
      Optional<String> valueOptional = instance.getValue();
      if (valueOptional.isPresent()) {
        value(valueOptional);
      }
      Optional<String> sessionOptional = instance.getSession();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link Value#getCreateIndex() createIndex}.
     * @param createIndex value for createIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder createIndex(long createIndex) {
      this.createIndex = createIndex;
      initializedBitset |= INITIALIZED_BIT_CREATE_INDEX;
      return this;
    }
  
    /**
     * Initializes value for {@link Value#getModifyIndex() modifyIndex}.
     * @param modifyIndex value for modifyIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder modifyIndex(long modifyIndex) {
      this.modifyIndex = modifyIndex;
      initializedBitset |= INITIALIZED_BIT_MODIFY_INDEX;
      return this;
    }
  
    /**
     * Initializes value for {@link Value#getLockIndex() lockIndex}.
     * @param lockIndex value for lockIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder lockIndex(long lockIndex) {
      this.lockIndex = lockIndex;
      initializedBitset |= INITIALIZED_BIT_LOCK_INDEX;
      return this;
    }
  
    /**
     * Initializes value for {@link Value#getKey() key}.
     * @param key value for key
     * @return {@code this} builder for chained invocation
     */
    public final Builder key(String key) {
      this.key = Preconditions.checkNotNull(key);
      initializedBitset |= INITIALIZED_BIT_KEY;
      return this;
    }
  
    /**
     * Initializes value for {@link Value#getFlags() flags}.
     * @param flags value for flags
     * @return {@code this} builder for chained invocation
     */
    public final Builder flags(long flags) {
      this.flags = flags;
      initializedBitset |= INITIALIZED_BIT_FLAGS;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Value#getValue() value}.
     * @param value value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(String value) {
      this.value = Optional.of(value);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Value#getValue() value}.
     * @param value value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(Optional<String> value) {
      this.value = Preconditions.checkNotNull(value);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Value#getSession() session}.
     * @param session value for session
     * @return {@code this} builder for chained invocation
     */
    public final Builder session(String session) {
      this.session = Optional.of(session);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Value#getSession() session}.
     * @param session value for session
     * @return {@code this} builder for chained invocation
     */
    public final Builder session(Optional<String> session) {
      this.session = Preconditions.checkNotNull(session);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.kv.ImmutableValue}.
     * @return immutable instance of Value
     */
    public ImmutableValue build() {
      checkRequiredAttributes();
      return new ImmutableValue(createIndex, modifyIndex, lockIndex, key, flags, value, session);
    }
  
    private boolean createIndexIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CREATE_INDEX) != 0;
    }
  
    private boolean modifyIndexIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MODIFY_INDEX) != 0;
    }
  
    private boolean lockIndexIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LOCK_INDEX) != 0;
    }
  
    private boolean keyIsSet() {
      return (initializedBitset & INITIALIZED_BIT_KEY) != 0;
    }
  
    private boolean flagsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FLAGS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!createIndexIsSet()) {
        attributes.add("createIndex");
      }
      if (!modifyIndexIsSet()) {
        attributes.add("modifyIndex");
      }
      if (!lockIndexIsSet()) {
        attributes.add("lockIndex");
      }
      if (!keyIsSet()) {
        attributes.add("key");
      }
      if (!flagsIsSet()) {
        attributes.add("flags");
      }
      return "Cannot build Value, some of required attributes are not set " + attributes;
    }
  }
}
