package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.util.SecondsDeserializer;
import com.orbitz.consul.util.SecondsSerializer;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link SessionInfo}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableSessionInfo.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "SessionInfo"})
public final class ImmutableSessionInfo extends SessionInfo {
  private final long createIndex;
  private final Long lockDelay;
  private final Optional<String> name;
  private final String node;
  private final ImmutableList<String> checks;
  private final String behavior;
  private final Optional<Long> ttl;
  private final String id;

  private ImmutableSessionInfo(
      long createIndex,
      Long lockDelay,
      Optional<String> name,
      String node,
      ImmutableList<String> checks,
      String behavior,
      Optional<Long> ttl,
      String id) {
    this.createIndex = createIndex;
    this.lockDelay = lockDelay;
    this.name = name;
    this.node = node;
    this.checks = checks;
    this.behavior = behavior;
    this.ttl = ttl;
    this.id = id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public long getCreateIndex() {
    return createIndex;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code lockDelay} attribute
   */
  @JsonSerialize(using = SecondsSerializer.class)
  @JsonDeserialize(using = SecondsDeserializer.class)
  @JsonProperty("LockDelay")
  @Override
  public Long getLockDelay() {
    return lockDelay;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public Optional<String> getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checks} attribute
   */
  @JsonProperty("Checks")
  @Override
  public ImmutableList<String> getChecks() {
    return checks;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code behavior} attribute
   */
  @JsonProperty("Behavior")
  @Override
  public String getBehavior() {
    return behavior;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ttl} attribute
   */
  @JsonSerialize(using = SecondsSerializer.class)
  @JsonDeserialize(using = SecondsDeserializer.class)
  @JsonProperty("TTL")
  @Override
  public Optional<Long> getTtl() {
    return ttl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionInfo#getCreateIndex() createIndex}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for createIndex
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withCreateIndex(long value) {
    if (this.createIndex == value) {
      return this;
    }
    long newValue = value;
    return new ImmutableSessionInfo(newValue, this.lockDelay, this.name, this.node, this.checks, this.behavior, this.ttl, this.id);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionInfo#getLockDelay() lockDelay}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for lockDelay
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withLockDelay(Long value) {
    if (this.lockDelay == value) {
      return this;
    }
    Long newValue = Preconditions.checkNotNull(value);
    return new ImmutableSessionInfo(this.createIndex, newValue, this.name, this.node, this.checks, this.behavior, this.ttl, this.id);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link SessionInfo#getName() name}.
   * @param value value for name
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        newValue,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link SessionInfo#getName() name}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for name
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withName(Optional<String> optional) {
    if (this.name == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        newValue,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionInfo#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withNode(String value) {
    if (this.node == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        newValue,
        this.checks,
        this.behavior,
        this.ttl,
        this.id);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link SessionInfo#getChecks() checks}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withChecks(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl, this.id);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link SessionInfo#getChecks() checks}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of checks elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withChecks(Iterable<String> elements) {
    if (this.checks == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl, this.id);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionInfo#getBehavior() behavior}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for behavior
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withBehavior(String value) {
    if (this.behavior == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checks, newValue, this.ttl, this.id);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link SessionInfo#getTtl() ttl}.
   * @param value value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withTtl(long value) {
    Optional<Long> newValue = Optional.of(value);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        newValue,
        this.id);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link SessionInfo#getTtl() ttl}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableSessionInfo withTtl(Optional<Long> optional) {
    if (this.ttl == optional) {
      return this;
    }
    Optional<Long> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        newValue,
        this.id);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionInfo#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionInfo withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableSessionInfo(
        this.createIndex,
        this.lockDelay,
        this.name,
        this.node,
        this.checks,
        this.behavior,
        this.ttl,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableSessionInfo} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableSessionInfo && equalTo((ImmutableSessionInfo) another));
  }
  
  private boolean equalTo(ImmutableSessionInfo another) {
    return createIndex == another.createIndex
        && lockDelay.equals(another.lockDelay)
        && name.equals(another.name)
        && node.equals(another.node)
        && checks.equals(another.checks)
        && behavior.equals(another.behavior)
        && ttl.equals(another.ttl)
        && id.equals(another.id);
  }
  
  /**
   * Computes hash code from attributes: {@code createIndex}, {@code lockDelay}, {@code name}, {@code node}, {@code checks}, {@code behavior}, {@code ttl}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(createIndex);
    h = h * 17 + lockDelay.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + node.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + behavior.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + id.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code SessionInfo{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SessionInfo")
        .add("createIndex", createIndex)
        .add("lockDelay", lockDelay)
        .add("name", name)
        .add("node", node)
        .add("checks", checks)
        .add("behavior", behavior)
        .add("ttl", ttl)
        .add("id", id)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableSessionInfo fromAllAttributes(
      @JsonProperty("CreateIndex") Long createIndex,
      @JsonSerialize(using = SecondsSerializer.class)
      @JsonDeserialize(using = SecondsDeserializer.class)
      @JsonProperty("LockDelay") Long lockDelay,
      @JsonProperty("Name") Optional<String> name,
      @JsonProperty("Node") String node,
      @JsonProperty("Checks") List<String> checks,
      @JsonProperty("Behavior") String behavior,
      @JsonSerialize(using = SecondsSerializer.class)
      @JsonDeserialize(using = SecondsDeserializer.class)
      @JsonProperty("TTL") Optional<Long> ttl,
      @JsonProperty("ID") String id) {
    ImmutableSessionInfo.Builder builder = ImmutableSessionInfo.builder();
    if (createIndex != null) {
      builder.createIndex(createIndex);
    }
    if (lockDelay != null) {
      builder.lockDelay(lockDelay);
    }
    if (name != null) {
      builder.name(name);
    }
    if (node != null) {
      builder.node(node);
    }
    if (checks != null) {
      builder.addAllChecks(checks);
    }
    if (behavior != null) {
      builder.behavior(behavior);
    }
    if (ttl != null) {
      builder.ttl(ttl);
    }
    if (id != null) {
      builder.id(id);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link SessionInfo}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable SessionInfo instance
   */
  public static ImmutableSessionInfo copyOf(SessionInfo instance) {
    if (instance instanceof ImmutableSessionInfo) {
      return (ImmutableSessionInfo) instance;
    }
    return ImmutableSessionInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.session.ImmutableSessionInfo}.
   * @return new ImmutableSessionInfo builder
   */
  public static ImmutableSessionInfo.Builder builder() {
    return new ImmutableSessionInfo.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.session.ImmutableSessionInfo}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_CREATE_INDEX = 0x1L;
    private static final long INITIALIZED_BIT_LOCK_DELAY = 0x2L;
    private static final long INITIALIZED_BIT_NODE = 0x4L;
    private static final long INITIALIZED_BIT_BEHAVIOR = 0x8L;
    private static final long INITIALIZED_BIT_ID = 0x10L;
    private long initializedBitset;
  
    private long createIndex;
    private Long lockDelay;
    private Optional<String> name = Optional.absent();
    private String node;
    private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
    private String behavior;
    private Optional<Long> ttl = Optional.absent();
    private String id;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link SessionInfo} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(SessionInfo instance) {
      Preconditions.checkNotNull(instance);
      createIndex(instance.getCreateIndex());
      lockDelay(instance.getLockDelay());
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      node(instance.getNode());
      addAllChecks(instance.getChecks());
      behavior(instance.getBehavior());
      Optional<Long> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      id(instance.getId());
      return this;
    }
  
    /**
     * Initializes value for {@link SessionInfo#getCreateIndex() createIndex}.
     * @param createIndex value for createIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder createIndex(long createIndex) {
      this.createIndex = createIndex;
      initializedBitset |= INITIALIZED_BIT_CREATE_INDEX;
      return this;
    }
  
    /**
     * Initializes value for {@link SessionInfo#getLockDelay() lockDelay}.
     * @param lockDelay value for lockDelay
     * @return {@code this} builder for chained invocation
     */
    public final Builder lockDelay(Long lockDelay) {
      this.lockDelay = Preconditions.checkNotNull(lockDelay);
      initializedBitset |= INITIALIZED_BIT_LOCK_DELAY;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link SessionInfo#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }
  
    /**
     * Initializes optional value for {@link SessionInfo#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = Preconditions.checkNotNull(name);
      return this;
    }
  
    /**
     * Initializes value for {@link SessionInfo#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Adds one element to {@link SessionInfo#getChecks() checks} list.
     * @param element checks element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(String element) {
      checksBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link SessionInfo#getChecks() checks} list.
     * @param elements array of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(String... elements) {
      checksBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link SessionInfo#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder checks(Iterable<String> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }
  
    /**
     * Adds elements to {@link SessionInfo#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllChecks(Iterable<String> elements) {
      checksBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link SessionInfo#getBehavior() behavior}.
     * @param behavior value for behavior
     * @return {@code this} builder for chained invocation
     */
    public final Builder behavior(String behavior) {
      this.behavior = Preconditions.checkNotNull(behavior);
      initializedBitset |= INITIALIZED_BIT_BEHAVIOR;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link SessionInfo#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(long ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }
  
    /**
     * Initializes optional value for {@link SessionInfo#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(Optional<Long> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl);
      return this;
    }
  
    /**
     * Initializes value for {@link SessionInfo#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.session.ImmutableSessionInfo}.
     * @return immutable instance of SessionInfo
     */
    public ImmutableSessionInfo build() {
      checkRequiredAttributes();
      return new ImmutableSessionInfo(createIndex, lockDelay, name, node, checksBuilder.build(), behavior, ttl, id);
    }
  
    private boolean createIndexIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CREATE_INDEX) != 0;
    }
  
    private boolean lockDelayIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LOCK_DELAY) != 0;
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private boolean behaviorIsSet() {
      return (initializedBitset & INITIALIZED_BIT_BEHAVIOR) != 0;
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!createIndexIsSet()) {
        attributes.add("createIndex");
      }
      if (!lockDelayIsSet()) {
        attributes.add("lockDelay");
      }
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      if (!behaviorIsSet()) {
        attributes.add("behavior");
      }
      if (!idIsSet()) {
        attributes.add("id");
      }
      return "Cannot build SessionInfo, some of required attributes are not set " + attributes;
    }
  }
}
