/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.AclClient;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.CoordinateClient;
import com.orbitz.consul.EventClient;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.OperatorClient;
import com.orbitz.consul.PreparedQueryClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.StatusClient;
import com.orbitz.consul.cache.TimeoutInterceptor;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.util.Jackson;
import com.orbitz.consul.util.bookend.ConsulBookend;
import com.orbitz.consul.util.bookend.ConsulBookendInterceptor;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.internal.Util;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Consul {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8500;
    private final AgentClient agentClient;
    private final AclClient aclClient;
    private final HealthClient healthClient;
    private final KeyValueClient keyValueClient;
    private final CatalogClient catalogClient;
    private final StatusClient statusClient;
    private final SessionClient sessionClient;
    private final EventClient eventClient;
    private final PreparedQueryClient preparedQueryClient;
    private final CoordinateClient coordinateClient;
    private final OperatorClient operatorClient;
    private final ExecutorService executorService;

    private Consul(AgentClient agentClient, HealthClient healthClient, KeyValueClient keyValueClient, CatalogClient catalogClient, StatusClient statusClient, SessionClient sessionClient, EventClient eventClient, PreparedQueryClient preparedQueryClient, CoordinateClient coordinateClient, OperatorClient operatorClient, ExecutorService executorService, AclClient aclClient) {
        this.agentClient = agentClient;
        this.healthClient = healthClient;
        this.keyValueClient = keyValueClient;
        this.catalogClient = catalogClient;
        this.statusClient = statusClient;
        this.sessionClient = sessionClient;
        this.eventClient = eventClient;
        this.preparedQueryClient = preparedQueryClient;
        this.coordinateClient = coordinateClient;
        this.operatorClient = operatorClient;
        this.executorService = executorService;
        this.aclClient = aclClient;
    }

    public void destroy() {
        this.executorService.shutdownNow();
    }

    public AgentClient agentClient() {
        return this.agentClient;
    }

    public AclClient aclClient() {
        return this.aclClient;
    }

    public CatalogClient catalogClient() {
        return this.catalogClient;
    }

    public HealthClient healthClient() {
        return this.healthClient;
    }

    public KeyValueClient keyValueClient() {
        return this.keyValueClient;
    }

    public StatusClient statusClient() {
        return this.statusClient;
    }

    public SessionClient sessionClient() {
        return this.sessionClient;
    }

    public EventClient eventClient() {
        return this.eventClient;
    }

    public PreparedQueryClient preparedQueryClient() {
        return this.preparedQueryClient;
    }

    public CoordinateClient coordinateClient() {
        return this.coordinateClient;
    }

    public OperatorClient operatorClient() {
        return this.operatorClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static Consul newClient() {
        return Consul.builder().build();
    }

    public static class Builder {
        private URL url;
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private Proxy proxy;
        private boolean ping = true;
        private Interceptor basicAuthInterceptor;
        private Interceptor aclTokenInterceptor;
        private Interceptor headerInterceptor;
        private Interceptor consulBookendInterceptor;
        private Long connectTimeoutMillis;
        private Long readTimeoutMillis;
        private Long writeTimeoutMillis;
        private ExecutorService executorService;
        private ClientConfig clientConfig;

        Builder() {
            try {
                this.url = new URL("http", Consul.DEFAULT_HTTP_HOST, 8500, "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withPing(boolean ping) {
            this.ping = ping;
            return this;
        }

        public Builder withBasicAuth(String username, String password) {
            String credentials = username + ":" + password;
            String basic = "Basic " + BaseEncoding.base64().encode(credentials.getBytes());
            this.basicAuthInterceptor = chain -> {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", basic).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            };
            return this;
        }

        public Builder withAclToken(String token) {
            this.aclTokenInterceptor = chain -> {
                Request original = chain.request();
                HttpUrl originalUrl = original.url();
                String rewrittenUrl = originalUrl.queryParameterNames().isEmpty() ? originalUrl.url().toExternalForm() + "?token=" + token : originalUrl.url().toExternalForm() + "&token=" + token;
                Request.Builder requestBuilder = original.newBuilder().url(rewrittenUrl).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            };
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.headerInterceptor = chain -> {
                Request.Builder requestBuilder = chain.request().newBuilder();
                for (Map.Entry header : headers.entrySet()) {
                    requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
                }
                return chain.proceed(requestBuilder.build());
            };
            return this;
        }

        public Builder withConsulBookend(ConsulBookend consulBookend) {
            this.consulBookendInterceptor = new ConsulBookendInterceptor(consulBookend);
            return this;
        }

        public Builder withHostAndPort(HostAndPort hostAndPort) {
            try {
                this.url = new URL("http", hostAndPort.getHost(), hostAndPort.getPort(), "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withUrl(String url) {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withConnectTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.connectTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withReadTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.readTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withWriteTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.writeTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder withClientConfiguration(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Consul build() {
            Retrofit retrofit;
            ExecutorService executorService = this.executorService;
            if (executorService == null) {
                executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttp Dispatcher", (boolean)true));
            }
            ClientConfig config = this.clientConfig != null ? this.clientConfig : new ClientConfig();
            try {
                retrofit = this.createRetrofit(this.buildUrl(this.url), this.sslContext, this.hostnameVerifier, this.proxy, Jackson.MAPPER, executorService, config);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            AgentClient agentClient = new AgentClient(retrofit, config);
            HealthClient healthClient = new HealthClient(retrofit, config);
            KeyValueClient keyValueClient = new KeyValueClient(retrofit, config);
            CatalogClient catalogClient = new CatalogClient(retrofit, config);
            StatusClient statusClient = new StatusClient(retrofit, config);
            SessionClient sessionClient = new SessionClient(retrofit, config);
            EventClient eventClient = new EventClient(retrofit, config);
            PreparedQueryClient preparedQueryClient = new PreparedQueryClient(retrofit, config);
            CoordinateClient coordinateClient = new CoordinateClient(retrofit, config);
            OperatorClient operatorClient = new OperatorClient(retrofit, config);
            AclClient aclClient = new AclClient(retrofit, config);
            if (this.ping) {
                agentClient.ping();
            }
            return new Consul(agentClient, healthClient, keyValueClient, catalogClient, statusClient, sessionClient, eventClient, preparedQueryClient, coordinateClient, operatorClient, executorService, aclClient);
        }

        private String buildUrl(URL url) {
            return url.toExternalForm().replaceAll("/$", "") + "/v1/";
        }

        private Retrofit createRetrofit(String url, SSLContext sslContext, HostnameVerifier hostnameVerifier, Proxy proxy, ObjectMapper mapper, ExecutorService executorService, ClientConfig clientConfig) throws MalformedURLException {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.basicAuthInterceptor != null) {
                builder.addInterceptor(this.basicAuthInterceptor);
            }
            if (this.aclTokenInterceptor != null) {
                builder.addInterceptor(this.aclTokenInterceptor);
            }
            if (this.headerInterceptor != null) {
                builder.addInterceptor(this.headerInterceptor);
            }
            if (this.consulBookendInterceptor != null) {
                builder.addInterceptor(this.consulBookendInterceptor);
            }
            if (sslContext != null) {
                builder.sslSocketFactory(sslContext.getSocketFactory());
            }
            if (hostnameVerifier != null) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            if (proxy != null) {
                builder.proxy(proxy);
            }
            if (this.connectTimeoutMillis != null) {
                builder.connectTimeout(this.connectTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
            }
            if (this.readTimeoutMillis != null) {
                builder.readTimeout(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
            }
            if (this.writeTimeoutMillis != null) {
                builder.writeTimeout(this.writeTimeoutMillis.longValue(), TimeUnit.MILLISECONDS);
            }
            builder.addInterceptor((Interceptor)new TimeoutInterceptor(clientConfig.getCacheConfig()));
            Dispatcher dispatcher = new Dispatcher(executorService);
            dispatcher.setMaxRequests(Integer.MAX_VALUE);
            dispatcher.setMaxRequestsPerHost(Integer.MAX_VALUE);
            builder.dispatcher(dispatcher);
            URL consulUrl = new URL(url);
            return new Retrofit.Builder().baseUrl(new URL(consulUrl.getProtocol(), consulUrl.getHost(), consulUrl.getPort(), consulUrl.getFile()).toExternalForm()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(builder.build()).build();
        }
    }
}

