package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Check}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheck.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Check"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCheck extends Check {
  private final String id;
  private final String name;
  private final @Nullable String notes;
  private final @Nullable String output;
  private final @Nullable String script;
  private final @Nullable String interval;
  private final @Nullable String ttl;
  private final @Nullable String http;
  private final @Nullable String tcp;
  private final @Nullable String serviceId;
  private final ImmutableList<String> serviceTags;
  private final @Nullable String deregisterCriticalServiceAfter;

  private ImmutableCheck(
      String id,
      String name,
      @Nullable String notes,
      @Nullable String output,
      @Nullable String script,
      @Nullable String interval,
      @Nullable String ttl,
      @Nullable String http,
      @Nullable String tcp,
      @Nullable String serviceId,
      ImmutableList<String> serviceTags,
      @Nullable String deregisterCriticalServiceAfter) {
    this.id = id;
    this.name = name;
    this.notes = notes;
    this.output = output;
    this.script = script;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.tcp = tcp;
    this.serviceId = serviceId;
    this.serviceTags = serviceTags;
    this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty(value = "Notes")
  @Override
  public Optional<String> getNotes() {
    return Optional.ofNullable(notes);
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty(value = "Output")
  @Override
  public Optional<String> getOutput() {
    return Optional.ofNullable(output);
  }

  /**
   * @return The value of the {@code script} attribute
   */
  @JsonProperty(value = "Script")
  @Override
  public Optional<String> getScript() {
    return Optional.ofNullable(script);
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @JsonProperty(value = "Interval")
  @Override
  public Optional<String> getInterval() {
    return Optional.ofNullable(interval);
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty(value = "TTL")
  @Override
  public Optional<String> getTtl() {
    return Optional.ofNullable(ttl);
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty(value = "HTTP")
  @Override
  public Optional<String> getHttp() {
    return Optional.ofNullable(http);
  }

  /**
   * @return The value of the {@code tcp} attribute
   */
  @JsonProperty(value = "TCP")
  @Override
  public Optional<String> getTcp() {
    return Optional.ofNullable(tcp);
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty(value = "ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return Optional.ofNullable(serviceId);
  }

  /**
   * @return The value of the {@code serviceTags} attribute
   */
  @JsonProperty(value = "ServiceTags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }

  /**
   * @return The value of the {@code deregisterCriticalServiceAfter} attribute
   */
  @JsonProperty(value = "DeregisterCriticalServiceAfter")
  @Override
  public Optional<String> getDeregisterCriticalServiceAfter() {
    return Optional.ofNullable(deregisterCriticalServiceAfter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withId(String value) {
    if (this.id.equals(value)) return this;
    return validate(new ImmutableCheck(
        Preconditions.checkNotNull(value, "id"),
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withName(String value) {
    if (this.name.equals(value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        Preconditions.checkNotNull(value, "name"),
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "notes");
    if (Objects.equals(this.notes, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        newValue,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getNotes() notes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notes, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        value,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getOutput() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "output");
    if (Objects.equals(this.output, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        newValue,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getOutput() output} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.output, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        value,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getScript() script} attribute.
   * @param value The value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "script");
    if (Objects.equals(this.script, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        newValue,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getScript() script} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for script
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.script, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        value,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getInterval() interval} attribute.
   * @param value The value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "interval");
    if (Objects.equals(this.interval, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        newValue,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getInterval() interval} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.interval, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        value,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "ttl");
    if (Objects.equals(this.ttl, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        newValue,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTtl() ttl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.ttl, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        value,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getHttp() http} attribute.
   * @param value The value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "http");
    if (Objects.equals(this.http, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        newValue,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getHttp() http} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.http, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        value,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTcp() tcp} attribute.
   * @param value The value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "tcp");
    if (Objects.equals(this.tcp, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        newValue,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTcp() tcp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tcp, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        value,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getServiceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "serviceId");
    if (Objects.equals(this.serviceId, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        newValue,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getServiceId() serviceId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceId, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        value,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Check#getServiceTags() serviceTags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        newValue,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Check#getServiceTags() serviceTags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceTags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        newValue,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * @param value The value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withDeregisterCriticalServiceAfter(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "deregisterCriticalServiceAfter");
    if (Objects.equals(this.deregisterCriticalServiceAfter, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.deregisterCriticalServiceAfter, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.script,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.serviceId,
        this.serviceTags,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheck
        && equalTo((ImmutableCheck) another);
  }

  private boolean equalTo(ImmutableCheck another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(notes, another.notes)
        && Objects.equals(output, another.output)
        && Objects.equals(script, another.script)
        && Objects.equals(interval, another.interval)
        && Objects.equals(ttl, another.ttl)
        && Objects.equals(http, another.http)
        && Objects.equals(tcp, another.tcp)
        && Objects.equals(serviceId, another.serviceId)
        && serviceTags.equals(another.serviceTags)
        && Objects.equals(deregisterCriticalServiceAfter, another.deregisterCriticalServiceAfter);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code notes}, {@code output}, {@code script}, {@code interval}, {@code ttl}, {@code http}, {@code tcp}, {@code serviceId}, {@code serviceTags}, {@code deregisterCriticalServiceAfter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(notes);
    h = h * 17 + com.google.common.base.Objects.hashCode(output);
    h = h * 17 + com.google.common.base.Objects.hashCode(script);
    h = h * 17 + com.google.common.base.Objects.hashCode(interval);
    h = h * 17 + com.google.common.base.Objects.hashCode(ttl);
    h = h * 17 + com.google.common.base.Objects.hashCode(http);
    h = h * 17 + com.google.common.base.Objects.hashCode(tcp);
    h = h * 17 + com.google.common.base.Objects.hashCode(serviceId);
    h = h * 17 + serviceTags.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(deregisterCriticalServiceAfter);
    return h;
  }

  /**
   * Prints the immutable value {@code Check} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Check")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("notes", notes)
        .add("output", output)
        .add("script", script)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .add("tcp", tcp)
        .add("serviceId", serviceId)
        .add("serviceTags", serviceTags)
        .add("deregisterCriticalServiceAfter", deregisterCriticalServiceAfter)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Check {
    @Nullable String id;
    @Nullable String name;
    Optional<String> notes = Optional.empty();
    Optional<String> output = Optional.empty();
    Optional<String> script = Optional.empty();
    Optional<String> interval = Optional.empty();
    Optional<String> ttl = Optional.empty();
    Optional<String> http = Optional.empty();
    Optional<String> tcp = Optional.empty();
    Optional<String> serviceId = Optional.empty();
    List<String> serviceTags = ImmutableList.of();
    Optional<String> deregisterCriticalServiceAfter = Optional.empty();
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty(value = "Output")
    public void setOutput(Optional<String> output) {
      this.output = output;
    }
    @JsonProperty(value = "Script")
    public void setScript(Optional<String> script) {
      this.script = script;
    }
    @JsonProperty(value = "Interval")
    public void setInterval(Optional<String> interval) {
      this.interval = interval;
    }
    @JsonProperty(value = "TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty(value = "HTTP")
    public void setHttp(Optional<String> http) {
      this.http = http;
    }
    @JsonProperty(value = "TCP")
    public void setTcp(Optional<String> tcp) {
      this.tcp = tcp;
    }
    @JsonProperty(value = "ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty(value = "ServiceTags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setServiceTags(List<String> serviceTags) {
      this.serviceTags = serviceTags;
    }
    @JsonProperty(value = "DeregisterCriticalServiceAfter")
    public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOutput() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getScript() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInterval() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHttp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTcp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getServiceTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDeregisterCriticalServiceAfter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCheck fromJson(Json json) {
    ImmutableCheck.Builder builder = ImmutableCheck.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.script != null) {
      builder.script(json.script);
    }
    if (json.interval != null) {
      builder.interval(json.interval);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.http != null) {
      builder.http(json.http);
    }
    if (json.tcp != null) {
      builder.tcp(json.tcp);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceTags != null) {
      builder.addAllServiceTags(json.serviceTags);
    }
    if (json.deregisterCriticalServiceAfter != null) {
      builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
    }
    return builder.build();
  }

  private static ImmutableCheck validate(ImmutableCheck instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Check} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Check instance
   */
  public static ImmutableCheck copyOf(Check instance) {
    if (instance instanceof ImmutableCheck) {
      return (ImmutableCheck) instance;
    }
    return ImmutableCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheck ImmutableCheck}.
   * @return A new ImmutableCheck builder
   */
  public static ImmutableCheck.Builder builder() {
    return new ImmutableCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheck ImmutableCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String notes;
    private @Nullable String output;
    private @Nullable String script;
    private @Nullable String interval;
    private @Nullable String ttl;
    private @Nullable String http;
    private @Nullable String tcp;
    private @Nullable String serviceId;
    private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
    private @Nullable String deregisterCriticalServiceAfter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Check} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Check instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<String> scriptOptional = instance.getScript();
      if (scriptOptional.isPresent()) {
        script(scriptOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> tcpOptional = instance.getTcp();
      if (tcpOptional.isPresent()) {
        tcp(tcpOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      addAllServiceTags(instance.getServiceTags());
      Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
      if (deregisterCriticalServiceAfterOptional.isPresent()) {
        deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(String notes) {
      this.notes = Preconditions.checkNotNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder notes(Optional<String> notes) {
      this.notes = notes.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(String output) {
      this.output = Preconditions.checkNotNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(Optional<String> output) {
      this.output = output.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(String script) {
      this.script = Preconditions.checkNotNull(script, "script");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getScript() script} to script.
     * @param script The value for script
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder script(Optional<String> script) {
      this.script = script.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(String interval) {
      this.interval = Preconditions.checkNotNull(interval, "interval");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder interval(Optional<String> interval) {
      this.interval = interval.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Preconditions.checkNotNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = ttl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(String http) {
      this.http = Preconditions.checkNotNull(http, "http");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder http(Optional<String> http) {
      this.http = http.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for chained invocation
     */
    public final Builder tcp(String tcp) {
      this.tcp = Preconditions.checkNotNull(tcp, "tcp");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcp(Optional<String> tcp) {
      this.tcp = tcp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = serviceId.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Check#getServiceTags() serviceTags} list.
     * @param element A serviceTags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addServiceTags(String element) {
      serviceTagsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Check#getServiceTags() serviceTags} list.
     * @param elements An array of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addServiceTags(String... elements) {
      serviceTagsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Check#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceTags(Iterable<String> elements) {
      serviceTagsBuilder = ImmutableList.builder();
      return addAllServiceTags(elements);
    }

    /**
     * Adds elements to {@link Check#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceTags(Iterable<String> elements) {
      serviceTagsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for chained invocation
     */
    public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = Preconditions.checkNotNull(deregisterCriticalServiceAfter, "deregisterCriticalServiceAfter");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheck ImmutableCheck}.
     * @return An immutable instance of Check
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableCheck.validate(new ImmutableCheck(
          id,
          name,
          notes,
          output,
          script,
          interval,
          ttl,
          http,
          tcp,
          serviceId,
          serviceTagsBuilder.build(),
          deregisterCriticalServiceAfter));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Check, some of required attributes are not set " + attributes;
    }
  }
}
