/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.monitoring.ClientEventHandler;
import com.orbitz.consul.option.QueryOptions;
import java.util.function.Function;

public class ServiceCatalogCache
extends ConsulCache<String, CatalogService> {
    private ServiceCatalogCache(Function<CatalogService, String> keyConversion, ConsulCache.CallbackConsumer<CatalogService> callbackConsumer, CacheConfig cacheConfig, ClientEventHandler eventHandler) {
        super(keyConversion, callbackConsumer, cacheConfig, eventHandler);
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds) {
        ConsulCache.CallbackConsumer<CatalogService> callbackConsumer = (index, callback) -> catalogClient.getService(serviceName, ServiceCatalogCache.watchParams(index, watchSeconds, queryOptions), callback);
        return new ServiceCatalogCache(CatalogService::getServiceId, callbackConsumer, catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler());
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return ServiceCatalogCache.newCache(catalogClient, serviceName, QueryOptions.BLANK, watchSeconds);
    }
}

