package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AclToken}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAclToken.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AclToken"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAclToken extends AclToken {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String type;
  private final @Nullable String rules;

  private ImmutableAclToken(
      @Nullable String id,
      @Nullable String name,
      @Nullable String type,
      @Nullable String rules) {
    this.id = id;
    this.name = name;
    this.type = type;
    this.rules = rules;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public Optional<String> name() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty(value = "Type")
  @Override
  public Optional<String> type() {
    return Optional.ofNullable(type);
  }

  /**
   * @return The value of the {@code rules} attribute
   */
  @JsonProperty(value = "Rules")
  @Override
  public Optional<String> rules() {
    return Optional.ofNullable(rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclToken#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withId(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableAclToken(newValue, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclToken#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAclToken(value, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclToken#name() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withName(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableAclToken(this.id, newValue, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclToken#name() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableAclToken(this.id, value, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclToken#type() type} attribute.
   * @param value The value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withType(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "type");
    if (Objects.equals(this.type, newValue)) return this;
    return new ImmutableAclToken(this.id, this.name, newValue, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclToken#type() type} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAclToken(this.id, this.name, value, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclToken#rules() rules} attribute.
   * @param value The value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withRules(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "rules");
    if (Objects.equals(this.rules, newValue)) return this;
    return new ImmutableAclToken(this.id, this.name, this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclToken#rules() rules} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclToken withRules(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rules, value)) return this;
    return new ImmutableAclToken(this.id, this.name, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAclToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAclToken
        && equalTo((ImmutableAclToken) another);
  }

  private boolean equalTo(ImmutableAclToken another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(type, another.type)
        && Objects.equals(rules, another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code type}, {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + com.google.common.base.Objects.hashCode(id);
    h = h * 17 + com.google.common.base.Objects.hashCode(name);
    h = h * 17 + com.google.common.base.Objects.hashCode(type);
    h = h * 17 + com.google.common.base.Objects.hashCode(rules);
    return h;
  }

  /**
   * Prints the immutable value {@code AclToken} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AclToken")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("type", type)
        .add("rules", rules)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends AclToken {
    Optional<String> id = Optional.empty();
    Optional<String> name = Optional.empty();
    Optional<String> type = Optional.empty();
    Optional<String> rules = Optional.empty();
    @JsonProperty(value = "ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty(value = "Type")
    public void setType(Optional<String> type) {
      this.type = type;
    }
    @JsonProperty(value = "Rules")
    public void setRules(Optional<String> rules) {
      this.rules = rules;
    }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> type() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rules() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableAclToken fromJson(Json json) {
    ImmutableAclToken.Builder builder = ImmutableAclToken.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.rules != null) {
      builder.rules(json.rules);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AclToken} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AclToken instance
   */
  public static ImmutableAclToken copyOf(AclToken instance) {
    if (instance instanceof ImmutableAclToken) {
      return (ImmutableAclToken) instance;
    }
    return ImmutableAclToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAclToken ImmutableAclToken}.
   * @return A new ImmutableAclToken builder
   */
  public static ImmutableAclToken.Builder builder() {
    return new ImmutableAclToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAclToken ImmutableAclToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String type;
    private @Nullable String rules;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AclToken} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AclToken instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> nameOptional = instance.name();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      Optional<String> typeOptional = instance.type();
      if (typeOptional.isPresent()) {
        type(typeOptional);
      }
      Optional<String> rulesOptional = instance.rules();
      if (rulesOptional.isPresent()) {
        rules(rulesOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(String type) {
      this.type = Preconditions.checkNotNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Optional<String> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for chained invocation
     */
    public final Builder rules(String rules) {
      this.rules = Preconditions.checkNotNull(rules, "rules");
      return this;
    }

    /**
     * Initializes the optional value {@link AclToken#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Optional<String> rules) {
      this.rules = rules.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAclToken ImmutableAclToken}.
     * @return An immutable instance of AclToken
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAclToken build() {
      return new ImmutableAclToken(id, name, type, rules);
    }
  }
}
