package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Config}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Config"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableConfig extends Config {
  private final String datacenter;
  private final String nodeName;
  private final String revision;
  private final boolean server;
  private final String version;

  private ImmutableConfig(
      String datacenter,
      String nodeName,
      String revision,
      boolean server,
      String version) {
    this.datacenter = datacenter;
    this.nodeName = nodeName;
    this.revision = revision;
    this.server = server;
    this.version = version;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public String getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code nodeName} attribute
   */
  @JsonProperty(value = "NodeName")
  @Override
  public String getNodeName() {
    return nodeName;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @JsonProperty(value = "Revision")
  @Override
  public String getRevision() {
    return revision;
  }

  /**
   * @return The value of the {@code server} attribute
   */
  @JsonProperty(value = "Server")
  @Override
  public boolean getServer() {
    return server;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty(value = "Version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getDatacenter() datacenter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datacenter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withDatacenter(String value) {
    if (this.datacenter.equals(value)) return this;
    return new ImmutableConfig(
        Preconditions.checkNotNull(value, "datacenter"),
        this.nodeName,
        this.revision,
        this.server,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getNodeName() nodeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withNodeName(String value) {
    if (this.nodeName.equals(value)) return this;
    return new ImmutableConfig(
        this.datacenter,
        Preconditions.checkNotNull(value, "nodeName"),
        this.revision,
        this.server,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getRevision() revision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withRevision(String value) {
    if (this.revision.equals(value)) return this;
    return new ImmutableConfig(
        this.datacenter,
        this.nodeName,
        Preconditions.checkNotNull(value, "revision"),
        this.server,
        this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getServer() server} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for server
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withServer(boolean value) {
    if (this.server == value) return this;
    return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, value, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Config#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withVersion(String value) {
    if (this.version.equals(value)) return this;
    return new ImmutableConfig(
        this.datacenter,
        this.nodeName,
        this.revision,
        this.server,
        Preconditions.checkNotNull(value, "version"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfig
        && equalTo((ImmutableConfig) another);
  }

  private boolean equalTo(ImmutableConfig another) {
    return datacenter.equals(another.datacenter)
        && nodeName.equals(another.nodeName)
        && revision.equals(another.revision)
        && server == another.server
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code nodeName}, {@code revision}, {@code server}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + nodeName.hashCode();
    h = h * 17 + revision.hashCode();
    h = h * 17 + Booleans.hashCode(server);
    h = h * 17 + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Config} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Config")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("nodeName", nodeName)
        .add("revision", revision)
        .add("server", server)
        .add("version", version)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Config {
    @Nullable String datacenter;
    @Nullable String nodeName;
    @Nullable String revision;
    @Nullable Boolean server;
    @Nullable String version;
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(String datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "NodeName")
    public void setNodeName(String nodeName) {
      this.nodeName = nodeName;
    }
    @JsonProperty(value = "Revision")
    public void setRevision(String revision) {
      this.revision = revision;
    }
    @JsonProperty(value = "Server")
    public void setServer(boolean server) {
      this.server = server;
    }
    @JsonProperty(value = "Version")
    public void setVersion(String version) {
      this.version = version;
    }
    @Override
    public String getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getNodeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevision() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getServer() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableConfig fromJson(Json json) {
    ImmutableConfig.Builder builder = ImmutableConfig.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.nodeName != null) {
      builder.nodeName(json.nodeName);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    if (json.server != null) {
      builder.server(json.server);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Config} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Config instance
   */
  public static ImmutableConfig copyOf(Config instance) {
    if (instance instanceof ImmutableConfig) {
      return (ImmutableConfig) instance;
    }
    return ImmutableConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfig ImmutableConfig}.
   * @return A new ImmutableConfig builder
   */
  public static ImmutableConfig.Builder builder() {
    return new ImmutableConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfig ImmutableConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATACENTER = 0x1L;
    private static final long INIT_BIT_NODE_NAME = 0x2L;
    private static final long INIT_BIT_REVISION = 0x4L;
    private static final long INIT_BIT_SERVER = 0x8L;
    private static final long INIT_BIT_VERSION = 0x10L;
    private long initBits = 0x1f;

    private @Nullable String datacenter;
    private @Nullable String nodeName;
    private @Nullable String revision;
    private boolean server;
    private @Nullable String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Config} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Config instance) {
      Preconditions.checkNotNull(instance, "instance");
      datacenter(instance.getDatacenter());
      nodeName(instance.getNodeName());
      revision(instance.getRevision());
      server(instance.getServer());
      version(instance.getVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getDatacenter() datacenter} attribute.
     * @param datacenter The value for datacenter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      initBits &= ~INIT_BIT_DATACENTER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getNodeName() nodeName} attribute.
     * @param nodeName The value for nodeName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeName(String nodeName) {
      this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName");
      initBits &= ~INIT_BIT_NODE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder revision(String revision) {
      this.revision = Preconditions.checkNotNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getServer() server} attribute.
     * @param server The value for server 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder server(boolean server) {
      this.server = server;
      initBits &= ~INIT_BIT_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link Config#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfig ImmutableConfig}.
     * @return An immutable instance of Config
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConfig(datacenter, nodeName, revision, server, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_DATACENTER) != 0) attributes.add("datacenter");
      if ((initBits & INIT_BIT_NODE_NAME) != 0) attributes.add("nodeName");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      if ((initBits & INIT_BIT_SERVER) != 0) attributes.add("server");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build Config, some of required attributes are not set " + attributes;
    }
  }
}
