/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.orbitz.consul.model.coordinate.Coord;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCoord
extends Coord {
    private final double adjustment;
    private final double error;
    private final double height;
    private final double[] vec;

    private ImmutableCoord(double adjustment, double error, double height, double[] vec) {
        this.adjustment = adjustment;
        this.error = error;
        this.height = height;
        this.vec = vec;
    }

    @Override
    @JsonProperty(value="Adjustment")
    public double getAdjustment() {
        return this.adjustment;
    }

    @Override
    @JsonProperty(value="Error")
    public double getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="Height")
    public double getHeight() {
        return this.height;
    }

    @Override
    @JsonProperty(value="Vec")
    public double[] getVec() {
        return (double[])this.vec.clone();
    }

    public final ImmutableCoord withAdjustment(double value) {
        if (Double.doubleToLongBits(this.adjustment) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCoord(value, this.error, this.height, this.vec);
    }

    public final ImmutableCoord withError(double value) {
        if (Double.doubleToLongBits(this.error) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCoord(this.adjustment, value, this.height, this.vec);
    }

    public final ImmutableCoord withHeight(double value) {
        if (Double.doubleToLongBits(this.height) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCoord(this.adjustment, this.error, value, this.vec);
    }

    public final ImmutableCoord withVec(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableCoord(this.adjustment, this.error, this.height, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCoord && this.equalTo((ImmutableCoord)another);
    }

    private boolean equalTo(ImmutableCoord another) {
        return Double.doubleToLongBits(this.adjustment) == Double.doubleToLongBits(another.adjustment) && Double.doubleToLongBits(this.error) == Double.doubleToLongBits(another.error) && Double.doubleToLongBits(this.height) == Double.doubleToLongBits(another.height) && Arrays.equals(this.vec, another.vec);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Doubles.hashCode((double)this.adjustment);
        h = h * 17 + Doubles.hashCode((double)this.error);
        h = h * 17 + Doubles.hashCode((double)this.height);
        h = h * 17 + Arrays.hashCode(this.vec);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Coord").omitNullValues().add("adjustment", this.adjustment).add("error", this.error).add("height", this.height).add("vec", (Object)Arrays.toString(this.vec)).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCoord fromJson(Json json) {
        Builder builder = ImmutableCoord.builder();
        if (json.adjustment != null) {
            builder.adjustment(json.adjustment);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.height != null) {
            builder.height(json.height);
        }
        if (json.vec != null) {
            builder.vec(json.vec);
        }
        return builder.build();
    }

    public static ImmutableCoord copyOf(Coord instance) {
        if (instance instanceof ImmutableCoord) {
            return (ImmutableCoord)instance;
        }
        return ImmutableCoord.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ADJUSTMENT = 1L;
        private static final long INIT_BIT_ERROR = 2L;
        private static final long INIT_BIT_HEIGHT = 4L;
        private static final long INIT_BIT_VEC = 8L;
        private long initBits = 15L;
        private double adjustment;
        private double error;
        private double height;
        @Nullable
        private double[] vec;

        private Builder() {
        }

        public final Builder from(Coord instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.adjustment(instance.getAdjustment());
            this.error(instance.getError());
            this.height(instance.getHeight());
            this.vec(instance.getVec());
            return this;
        }

        public final Builder adjustment(double adjustment) {
            this.adjustment = adjustment;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder error(double error) {
            this.error = error;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder height(double height) {
            this.height = height;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder vec(double ... elements) {
            this.vec = (double[])elements.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCoord build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCoord(this.adjustment, this.error, this.height, this.vec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adjustment");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("height");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("vec");
            }
            return "Cannot build Coord, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Coord {
        @Nullable
        Double adjustment;
        @Nullable
        Double error;
        @Nullable
        Double height;
        @Nullable
        double[] vec;

        Json() {
        }

        @JsonProperty(value="Adjustment")
        public void setAdjustment(double adjustment) {
            this.adjustment = adjustment;
        }

        @JsonProperty(value="Error")
        public void setError(double error) {
            this.error = error;
        }

        @JsonProperty(value="Height")
        public void setHeight(double height) {
            this.height = height;
        }

        @JsonProperty(value="Vec")
        public void setVec(double[] vec) {
            this.vec = vec;
        }

        @Override
        public double getAdjustment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getHeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] getVec() {
            throw new UnsupportedOperationException();
        }
    }
}

