package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.ServiceWeights;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Service}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableService.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Service"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableService extends Service {
  private final String id;
  private final String service;
  private final @Nullable Boolean enableTagOverride;
  private final ImmutableList<String> tags;
  private final String address;
  private final ImmutableMap<String, String> meta;
  private final int port;
  private final @Nullable ServiceWeights weights;

  private ImmutableService(
      String id,
      String service,
      @Nullable Boolean enableTagOverride,
      ImmutableList<String> tags,
      String address,
      ImmutableMap<String, String> meta,
      int port,
      @Nullable ServiceWeights weights) {
    this.id = id;
    this.service = service;
    this.enableTagOverride = enableTagOverride;
    this.tags = tags;
    this.address = address;
    this.meta = meta;
    this.port = port;
    this.weights = weights;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty(value = "Service")
  @Override
  public String getService() {
    return service;
  }

  /**
   * @return The value of the {@code enableTagOverride} attribute
   */
  @JsonProperty(value = "EnableTagOverride")
  @Override
  public Optional<Boolean> getEnableTagOverride() {
    return Optional.ofNullable(enableTagOverride);
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty(value = "Tags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty(value = "Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty(value = "Meta")
  @Override
  public ImmutableMap<String, String> getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty(value = "Port")
  @Override
  public int getPort() {
    return port;
  }

  /**
   * @return The value of the {@code weights} attribute
   */
  @JsonProperty(value = "Weights")
  @Override
  public Optional<ServiceWeights> getWeights() {
    return Optional.ofNullable(weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableService(
        Preconditions.checkNotNull(value, "id"),
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getService() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withService(String value) {
    if (this.service.equals(value)) return this;
    return new ImmutableService(
        this.id,
        Preconditions.checkNotNull(value, "service"),
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Service#getEnableTagOverride() enableTagOverride} attribute.
   * @param value The value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withEnableTagOverride(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.enableTagOverride, newValue)) return this;
    return new ImmutableService(this.id, this.service, newValue, this.tags, this.address, this.meta, this.port, this.weights);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Service#getEnableTagOverride() enableTagOverride} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withEnableTagOverride(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.enableTagOverride, value)) return this;
    return new ImmutableService(this.id, this.service, value, this.tags, this.address, this.meta, this.port, this.weights);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Service#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        newValue,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Service#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        newValue,
        this.address,
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withAddress(String value) {
    if (this.address.equals(value)) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        Preconditions.checkNotNull(value, "address"),
        this.meta,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by replacing the {@link Service#getMeta() meta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the meta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withMeta(Map<String, ? extends String> entries) {
    if (this.meta == entries) return this;
    ImmutableMap<String, String> value = ImmutableMap.copyOf(entries);
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        value,
        this.port,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Service#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableService withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        value,
        this.weights);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Service#getWeights() weights} attribute.
   * @param value The value for weights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withWeights(ServiceWeights value) {
    @Nullable ServiceWeights newValue = Preconditions.checkNotNull(value, "weights");
    if (this.weights == newValue) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Service#getWeights() weights} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for weights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableService withWeights(Optional<ServiceWeights> optional) {
    @Nullable ServiceWeights value = optional.orElse(null);
    if (this.weights == value) return this;
    return new ImmutableService(
        this.id,
        this.service,
        this.enableTagOverride,
        this.tags,
        this.address,
        this.meta,
        this.port,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableService
        && equalTo((ImmutableService) another);
  }

  private boolean equalTo(ImmutableService another) {
    return id.equals(another.id)
        && service.equals(another.service)
        && Objects.equals(enableTagOverride, another.enableTagOverride)
        && tags.equals(another.tags)
        && address.equals(another.address)
        && meta.equals(another.meta)
        && port == another.port
        && Objects.equals(weights, another.weights);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code service}, {@code enableTagOverride}, {@code tags}, {@code address}, {@code meta}, {@code port}, {@code weights}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(enableTagOverride);
    h = h * 17 + tags.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + meta.hashCode();
    h = h * 17 + port;
    h = h * 17 + com.google.common.base.Objects.hashCode(weights);
    return h;
  }

  /**
   * Prints the immutable value {@code Service} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Service")
        .omitNullValues()
        .add("id", id)
        .add("service", service)
        .add("enableTagOverride", enableTagOverride)
        .add("tags", tags)
        .add("address", address)
        .add("meta", meta)
        .add("port", port)
        .add("weights", weights)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Service {
    @Nullable String id;
    @Nullable String service;
    Optional<Boolean> enableTagOverride = Optional.empty();
    List<String> tags = ImmutableList.of();
    @Nullable String address;
    @Nullable Map<String, String> meta;
    @Nullable Integer port;
    Optional<ServiceWeights> weights = Optional.empty();
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty(value = "EnableTagOverride")
    public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
    }
    @JsonProperty(value = "Tags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty(value = "Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty(value = "Meta")
    public void setMeta(Map<String, String> meta) {
      this.meta = meta;
    }
    @JsonProperty(value = "Port")
    public void setPort(int port) {
      this.port = port;
    }
    @JsonProperty(value = "Weights")
    public void setWeights(Optional<ServiceWeights> weights) {
      this.weights = weights;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getEnableTagOverride() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public int getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceWeights> getWeights() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableService fromJson(Json json) {
    ImmutableService.Builder builder = ImmutableService.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.enableTagOverride != null) {
      builder.enableTagOverride(json.enableTagOverride);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.meta != null) {
      builder.putAllMeta(json.meta);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.weights != null) {
      builder.weights(json.weights);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Service} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Service instance
   */
  public static ImmutableService copyOf(Service instance) {
    if (instance instanceof ImmutableService) {
      return (ImmutableService) instance;
    }
    return ImmutableService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableService ImmutableService}.
   * @return A new ImmutableService builder
   */
  public static ImmutableService.Builder builder() {
    return new ImmutableService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableService ImmutableService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private static final long INIT_BIT_ADDRESS = 0x4L;
    private static final long INIT_BIT_PORT = 0x8L;
    private long initBits = 0xf;

    private @Nullable String id;
    private @Nullable String service;
    private @Nullable Boolean enableTagOverride;
    private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
    private @Nullable String address;
    private ImmutableMap.Builder<String, String> metaBuilder = ImmutableMap.builder();
    private int port;
    private @Nullable ServiceWeights weights;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Service} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Service instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      service(instance.getService());
      Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
      if (enableTagOverrideOptional.isPresent()) {
        enableTagOverride(enableTagOverrideOptional);
      }
      addAllTags(instance.getTags());
      address(instance.getAddress());
      putAllMeta(instance.getMeta());
      port(instance.getPort());
      Optional<ServiceWeights> weightsOptional = instance.getWeights();
      if (weightsOptional.isPresent()) {
        weights(weightsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String service) {
      this.service = Preconditions.checkNotNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for chained invocation
     */
    public final Builder enableTagOverride(boolean enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Service#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String element) {
      tagsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String... elements) {
      tagsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Service#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(Iterable<String> elements) {
      tagsBuilder = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      tagsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Put one entry to the {@link Service#getMeta() meta} map.
     * @param key The key in the meta map
     * @param value The associated value in the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMeta(String key, String value) {
      metaBuilder.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
      metaBuilder.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(Map<String, ? extends String> entries) {
      metaBuilder = ImmutableMap.builder();
      return putAllMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Service#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMeta(Map<String, ? extends String> entries) {
      metaBuilder.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link Service#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for chained invocation
     */
    public final Builder weights(ServiceWeights weights) {
      this.weights = Preconditions.checkNotNull(weights, "weights");
      return this;
    }

    /**
     * Initializes the optional value {@link Service#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder weights(Optional<ServiceWeights> weights) {
      this.weights = weights.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableService ImmutableService}.
     * @return An immutable instance of Service
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableService(
          id,
          service,
          enableTagOverride,
          tagsBuilder.build(),
          address,
          metaBuilder.build(),
          port,
          weights);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build Service, some of required attributes are not set " + attributes;
    }
  }
}
