package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Session}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSession.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Session"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableSession extends Session {
  private final @Nullable String lockDelay;
  private final @Nullable String name;
  private final @Nullable String node;
  private final ImmutableList<String> checks;
  private final @Nullable String behavior;
  private final @Nullable String ttl;

  private ImmutableSession(
      @Nullable String lockDelay,
      @Nullable String name,
      @Nullable String node,
      ImmutableList<String> checks,
      @Nullable String behavior,
      @Nullable String ttl) {
    this.lockDelay = lockDelay;
    this.name = name;
    this.node = node;
    this.checks = checks;
    this.behavior = behavior;
    this.ttl = ttl;
  }

  /**
   * @return The value of the {@code lockDelay} attribute
   */
  @JsonProperty(value = "LockDelay")
  @Override
  public Optional<String> getLockDelay() {
    return Optional.ofNullable(lockDelay);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public Optional<String> getNode() {
    return Optional.ofNullable(node);
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty(value = "Checks")
  @Override
  public ImmutableList<String> getChecks() {
    return checks;
  }

  /**
   * @return The value of the {@code behavior} attribute
   */
  @JsonProperty(value = "Behavior")
  @Override
  public Optional<String> getBehavior() {
    return Optional.ofNullable(behavior);
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty(value = "TTL")
  @Override
  public Optional<String> getTtl() {
    return Optional.ofNullable(ttl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Session#getLockDelay() lockDelay} attribute.
   * @param value The value for lockDelay
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withLockDelay(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "lockDelay");
    if (Objects.equals(this.lockDelay, newValue)) return this;
    return new ImmutableSession(newValue, this.name, this.node, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Session#getLockDelay() lockDelay} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lockDelay
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withLockDelay(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lockDelay, value)) return this;
    return new ImmutableSession(value, this.name, this.node, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Session#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withName(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableSession(this.lockDelay, newValue, this.node, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Session#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableSession(this.lockDelay, value, this.node, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Session#getNode() node} attribute.
   * @param value The value for node
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withNode(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "node");
    if (Objects.equals(this.node, newValue)) return this;
    return new ImmutableSession(this.lockDelay, this.name, newValue, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Session#getNode() node} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for node
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withNode(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.node, value)) return this;
    return new ImmutableSession(this.lockDelay, this.name, value, this.checks, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Session#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withChecks(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSession(this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Session#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withChecks(Iterable<String> elements) {
    if (this.checks == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSession(this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Session#getBehavior() behavior} attribute.
   * @param value The value for behavior
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withBehavior(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "behavior");
    if (Objects.equals(this.behavior, newValue)) return this;
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, newValue, this.ttl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Session#getBehavior() behavior} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for behavior
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withBehavior(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.behavior, value)) return this;
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, value, this.ttl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Session#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withTtl(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "ttl");
    if (Objects.equals(this.ttl, newValue)) return this;
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Session#getTtl() ttl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSession withTtl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.ttl, value)) return this;
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSession} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSession
        && equalTo((ImmutableSession) another);
  }

  private boolean equalTo(ImmutableSession another) {
    return Objects.equals(lockDelay, another.lockDelay)
        && Objects.equals(name, another.name)
        && Objects.equals(node, another.node)
        && checks.equals(another.checks)
        && Objects.equals(behavior, another.behavior)
        && Objects.equals(ttl, another.ttl);
  }

  /**
   * Computes a hash code from attributes: {@code lockDelay}, {@code name}, {@code node}, {@code checks}, {@code behavior}, {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + com.google.common.base.Objects.hashCode(lockDelay);
    h = h * 17 + com.google.common.base.Objects.hashCode(name);
    h = h * 17 + com.google.common.base.Objects.hashCode(node);
    h = h * 17 + checks.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(behavior);
    h = h * 17 + com.google.common.base.Objects.hashCode(ttl);
    return h;
  }

  /**
   * Prints the immutable value {@code Session} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Session")
        .omitNullValues()
        .add("lockDelay", lockDelay)
        .add("name", name)
        .add("node", node)
        .add("checks", checks)
        .add("behavior", behavior)
        .add("ttl", ttl)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Session {
    Optional<String> lockDelay = Optional.empty();
    Optional<String> name = Optional.empty();
    Optional<String> node = Optional.empty();
    List<String> checks = ImmutableList.of();
    Optional<String> behavior = Optional.empty();
    Optional<String> ttl = Optional.empty();
    @JsonProperty(value = "LockDelay")
    public void setLockDelay(Optional<String> lockDelay) {
      this.lockDelay = lockDelay;
    }
    @JsonProperty(value = "Name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty(value = "Node")
    public void setNode(Optional<String> node) {
      this.node = node;
    }
    @JsonProperty(value = "Checks")
    public void setChecks(List<String> checks) {
      this.checks = checks;
    }
    @JsonProperty(value = "Behavior")
    public void setBehavior(Optional<String> behavior) {
      this.behavior = behavior;
    }
    @JsonProperty(value = "TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @Override
    public Optional<String> getLockDelay() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNode() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChecks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBehavior() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableSession fromJson(Json json) {
    ImmutableSession.Builder builder = ImmutableSession.builder();
    if (json.lockDelay != null) {
      builder.lockDelay(json.lockDelay);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    if (json.behavior != null) {
      builder.behavior(json.behavior);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Session} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Session instance
   */
  public static ImmutableSession copyOf(Session instance) {
    if (instance instanceof ImmutableSession) {
      return (ImmutableSession) instance;
    }
    return ImmutableSession.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSession ImmutableSession}.
   * @return A new ImmutableSession builder
   */
  public static ImmutableSession.Builder builder() {
    return new ImmutableSession.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSession ImmutableSession}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String lockDelay;
    private @Nullable String name;
    private @Nullable String node;
    private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
    private @Nullable String behavior;
    private @Nullable String ttl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Session} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Session instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> lockDelayOptional = instance.getLockDelay();
      if (lockDelayOptional.isPresent()) {
        lockDelay(lockDelayOptional);
      }
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      Optional<String> nodeOptional = instance.getNode();
      if (nodeOptional.isPresent()) {
        node(nodeOptional);
      }
      addAllChecks(instance.getChecks());
      Optional<String> behaviorOptional = instance.getBehavior();
      if (behaviorOptional.isPresent()) {
        behavior(behaviorOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getLockDelay() lockDelay} to lockDelay.
     * @param lockDelay The value for lockDelay
     * @return {@code this} builder for chained invocation
     */
    public final Builder lockDelay(String lockDelay) {
      this.lockDelay = Preconditions.checkNotNull(lockDelay, "lockDelay");
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getLockDelay() lockDelay} to lockDelay.
     * @param lockDelay The value for lockDelay
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lockDelay(Optional<String> lockDelay) {
      this.lockDelay = lockDelay.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getNode() node} to node.
     * @param node The value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getNode() node} to node.
     * @param node The value for node
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(Optional<String> node) {
      this.node = node.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Session#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(String element) {
      checksBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Session#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChecks(String... elements) {
      checksBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Session#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checks(Iterable<String> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link Session#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChecks(Iterable<String> elements) {
      checksBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getBehavior() behavior} to behavior.
     * @param behavior The value for behavior
     * @return {@code this} builder for chained invocation
     */
    public final Builder behavior(String behavior) {
      this.behavior = Preconditions.checkNotNull(behavior, "behavior");
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getBehavior() behavior} to behavior.
     * @param behavior The value for behavior
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder behavior(Optional<String> behavior) {
      this.behavior = behavior.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Preconditions.checkNotNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Session#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = ttl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSession ImmutableSession}.
     * @return An immutable instance of Session
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSession build() {
      return new ImmutableSession(lockDelay, name, node, checksBuilder.build(), behavior, ttl);
    }
  }
}
