/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.acl.Token;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutablePolicyLink
extends Token.PolicyLink {
    @Nullable
    private final String id;
    @Nullable
    private final String name;

    private ImmutablePolicyLink(@Nullable String id, @Nullable String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public final ImmutablePolicyLink withId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutablePolicyLink(newValue, this.name);
    }

    public final ImmutablePolicyLink withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePolicyLink(value, this.name);
    }

    public final ImmutablePolicyLink withName(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutablePolicyLink(this.id, newValue);
    }

    public final ImmutablePolicyLink withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutablePolicyLink(this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicyLink && this.equalTo((ImmutablePolicyLink)another);
    }

    private boolean equalTo(ImmutablePolicyLink another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolicyLink").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePolicyLink fromJson(Json json) {
        Builder builder = ImmutablePolicyLink.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutablePolicyLink copyOf(Token.PolicyLink instance) {
        if (instance instanceof ImmutablePolicyLink) {
            return (ImmutablePolicyLink)instance;
        }
        return ImmutablePolicyLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(Token.PolicyLink instance) {
            Optional<String> nameOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((nameOptional = instance.name()).isPresent()) {
                this.name(nameOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public ImmutablePolicyLink build() {
            return new ImmutablePolicyLink(this.id, this.name);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Token.PolicyLink {
        Optional<String> id = Optional.empty();
        Optional<String> name = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> name() {
            throw new UnsupportedOperationException();
        }
    }
}

