/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.acl.BasePolicyResponse;
import com.orbitz.consul.model.acl.PolicyResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutablePolicyResponse
extends PolicyResponse {
    private final String id;
    private final String name;
    @Nullable
    private final String datacenters;
    private final String hash;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;

    private ImmutablePolicyResponse(String id, String name, @Nullable String datacenters, String hash, BigInteger createIndex, BigInteger modifyIndex) {
        this.id = id;
        this.name = name;
        this.datacenters = datacenters;
        this.hash = hash;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    @Override
    @JsonProperty(value="Hash")
    public String hash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    public final ImmutablePolicyResponse withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutablePolicyResponse((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.name, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withDatacenters(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenters");
        if (Objects.equals(this.datacenters, newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, newValue, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withDatacenters(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenters, value)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, value, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withHash(String value) {
        if (this.hash.equals(value)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, (String)Preconditions.checkNotNull((Object)value, (Object)"hash"), this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withCreateIndex(BigInteger value) {
        if (this.createIndex == value) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"createIndex"), this.modifyIndex);
    }

    public final ImmutablePolicyResponse withModifyIndex(BigInteger value) {
        if (this.modifyIndex == value) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, this.createIndex, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"modifyIndex"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicyResponse && this.equalTo((ImmutablePolicyResponse)another);
    }

    private boolean equalTo(ImmutablePolicyResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.datacenters, another.datacenters) && this.hash.equals(another.hash) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenters});
        h = h * 17 + this.hash.hashCode();
        h = h * 17 + this.createIndex.hashCode();
        h = h * 17 + this.modifyIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolicyResponse").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("datacenters", (Object)this.datacenters).add("hash", (Object)this.hash).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePolicyResponse fromJson(Json json) {
        Builder builder = ImmutablePolicyResponse.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.modifyIndex(json.modifyIndex);
        }
        return builder.build();
    }

    public static ImmutablePolicyResponse copyOf(PolicyResponse instance) {
        if (instance instanceof ImmutablePolicyResponse) {
            return (ImmutablePolicyResponse)instance;
        }
        return ImmutablePolicyResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long INIT_BIT_CREATE_INDEX = 8L;
        private static final long INIT_BIT_MODIFY_INDEX = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String datacenters;
        @Nullable
        private String hash;
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;

        private Builder() {
        }

        public final Builder from(BasePolicyResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PolicyResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof BasePolicyResponse) {
                BasePolicyResponse instance = (BasePolicyResponse)object;
                Optional<String> datacentersOptional = instance.datacenters();
                if (datacentersOptional.isPresent()) {
                    this.datacenters(datacentersOptional);
                }
                this.name(instance.name());
                this.id(instance.id());
                this.modifyIndex(instance.modifyIndex());
                this.createIndex(instance.createIndex());
                this.hash(instance.hash());
            }
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder datacenters(String datacenters) {
            this.datacenters = (String)Preconditions.checkNotNull((Object)datacenters, (Object)"datacenters");
            return this;
        }

        public final Builder datacenters(Optional<String> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = (String)Preconditions.checkNotNull((Object)hash, (Object)"hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = (BigInteger)Preconditions.checkNotNull((Object)createIndex, (Object)"createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = (BigInteger)Preconditions.checkNotNull((Object)modifyIndex, (Object)"modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutablePolicyResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("modifyIndex");
            }
            return "Cannot build PolicyResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends PolicyResponse {
        @Nullable
        String id;
        @Nullable
        String name;
        Optional<String> datacenters = Optional.empty();
        @Nullable
        String hash;
        @Nullable
        BigInteger createIndex;
        @Nullable
        BigInteger modifyIndex;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

