package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Token}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToken.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Token"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableToken extends Token {
  private final @Nullable String id;
  private final @Nullable String description;
  private final boolean local;
  private final ImmutableList<Token.PolicyLink> policies;

  private ImmutableToken(
      @Nullable String id,
      @Nullable String description,
      boolean local,
      ImmutableList<Token.PolicyLink> policies) {
    this.id = id;
    this.description = description;
    this.local = local;
    this.policies = policies;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty(value = "Description")
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code local} attribute
   */
  @JsonProperty(value = "Local")
  @Override
  public boolean local() {
    return local;
  }

  /**
   * @return The value of the {@code policies} attribute
   */
  @JsonProperty(value = "Policies")
  @JsonDeserialize(as = ImmutableList.class, contentAs = Token.PolicyLink.class)
  @Override
  public ImmutableList<Token.PolicyLink> policies() {
    return policies;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Token#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withId(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableToken(newValue, this.description, this.local, this.policies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Token#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableToken(value, this.description, this.local, this.policies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Token#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withDescription(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableToken(this.id, newValue, this.local, this.policies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Token#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableToken(this.id, value, this.local, this.policies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#local() local} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for local
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withLocal(boolean value) {
    if (this.local == value) return this;
    return new ImmutableToken(this.id, this.description, value, this.policies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Token#policies() policies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withPolicies(Token.PolicyLink... elements) {
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableToken(this.id, this.description, this.local, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Token#policies() policies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of policies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToken withPolicies(Iterable<? extends Token.PolicyLink> elements) {
    if (this.policies == elements) return this;
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableToken(this.id, this.description, this.local, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToken
        && equalTo((ImmutableToken) another);
  }

  private boolean equalTo(ImmutableToken another) {
    return Objects.equals(id, another.id)
        && Objects.equals(description, another.description)
        && local == another.local
        && policies.equals(another.policies);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code description}, {@code local}, {@code policies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + com.google.common.base.Objects.hashCode(id);
    h = h * 17 + com.google.common.base.Objects.hashCode(description);
    h = h * 17 + Booleans.hashCode(local);
    h = h * 17 + policies.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Token} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Token")
        .omitNullValues()
        .add("id", id)
        .add("description", description)
        .add("local", local)
        .add("policies", policies)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Token {
    Optional<String> id = Optional.empty();
    Optional<String> description = Optional.empty();
    @Nullable Boolean local;
    List<Token.PolicyLink> policies = ImmutableList.of();
    @JsonProperty(value = "ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty(value = "Description")
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty(value = "Local")
    public void setLocal(boolean local) {
      this.local = local;
    }
    @JsonProperty(value = "Policies")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Token.PolicyLink.class)
    public void setPolicies(List<Token.PolicyLink> policies) {
      this.policies = policies;
    }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public boolean local() { throw new UnsupportedOperationException(); }
    @Override
    public List<Token.PolicyLink> policies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableToken fromJson(Json json) {
    ImmutableToken.Builder builder = ImmutableToken.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.local != null) {
      builder.local(json.local);
    }
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Token} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Token instance
   */
  public static ImmutableToken copyOf(Token instance) {
    if (instance instanceof ImmutableToken) {
      return (ImmutableToken) instance;
    }
    return ImmutableToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToken ImmutableToken}.
   * @return A new ImmutableToken builder
   */
  public static ImmutableToken.Builder builder() {
    return new ImmutableToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToken ImmutableToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LOCAL = 0x1L;
    private long initBits = 0x1;

    private @Nullable String id;
    private @Nullable String description;
    private boolean local;
    private ImmutableList.Builder<Token.PolicyLink> policiesBuilder = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Token} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Token instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      local(instance.local());
      addAllPolicies(instance.policies());
      return this;
    }

    /**
     * Initializes the optional value {@link Token#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link Token#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Token#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    public final Builder description(String description) {
      this.description = Preconditions.checkNotNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Token#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Token#local() local} attribute.
     * @param local The value for local 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder local(boolean local) {
      this.local = local;
      initBits &= ~INIT_BIT_LOCAL;
      return this;
    }

    /**
     * Adds one element to {@link Token#policies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPolicies(Token.PolicyLink element) {
      policiesBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Token#policies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPolicies(Token.PolicyLink... elements) {
      policiesBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Token#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
      policiesBuilder = ImmutableList.builder();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link Token#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
      policiesBuilder.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableToken ImmutableToken}.
     * @return An immutable instance of Token
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToken build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToken(id, description, local, policiesBuilder.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_LOCAL) != 0) attributes.add("local");
      return "Cannot build Token, some of required attributes are not set " + attributes;
    }
  }
}
