package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TokenListResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTokenListResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TokenListResponse"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTokenListResponse extends TokenListResponse {
  private final String accessorId;
  private final String description;
  private final ImmutableList<Token.PolicyLink> policies;
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;
  private final boolean local;
  private final Date createTime;
  private final String hash;

  private ImmutableTokenListResponse(
      String accessorId,
      String description,
      ImmutableList<Token.PolicyLink> policies,
      BigInteger createIndex,
      BigInteger modifyIndex,
      boolean local,
      Date createTime,
      String hash) {
    this.accessorId = accessorId;
    this.description = description;
    this.policies = policies;
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.local = local;
    this.createTime = createTime;
    this.hash = hash;
  }

  /**
   * @return The value of the {@code accessorId} attribute
   */
  @JsonProperty(value = "AccessorID")
  @Override
  public String accessorId() {
    return accessorId;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty(value = "Description")
  @Override
  public String description() {
    return description;
  }

  /**
   * @return The value of the {@code policies} attribute
   */
  @JsonProperty(value = "Policies")
  @Override
  public ImmutableList<Token.PolicyLink> policies() {
    return policies;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty(value = "CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty(value = "ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code local} attribute
   */
  @JsonProperty(value = "Local")
  @Override
  public boolean local() {
    return local;
  }

  /**
   * @return The value of the {@code createTime} attribute
   */
  @JsonProperty(value = "CreateTime")
  @Override
  public Date createTime() {
    return createTime;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty(value = "Hash")
  @Override
  public String hash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#accessorId() accessorId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accessorId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withAccessorId(String value) {
    if (this.accessorId.equals(value)) return this;
    return new ImmutableTokenListResponse(
        Preconditions.checkNotNull(value, "accessorId"),
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withDescription(String value) {
    if (this.description.equals(value)) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        Preconditions.checkNotNull(value, "description"),
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokenListResponse#policies() policies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenListResponse withPolicies(Token.PolicyLink... elements) {
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokenListResponse#policies() policies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of policies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenListResponse withPolicies(Iterable<? extends Token.PolicyLink> elements) {
    if (this.policies == elements) return this;
    ImmutableList<Token.PolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        newValue,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#createIndex() createIndex} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withCreateIndex(BigInteger value) {
    if (this.createIndex == value) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        this.policies,
        Preconditions.checkNotNull(value, "createIndex"),
        this.modifyIndex,
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#modifyIndex() modifyIndex} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withModifyIndex(BigInteger value) {
    if (this.modifyIndex == value) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        Preconditions.checkNotNull(value, "modifyIndex"),
        this.local,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#local() local} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for local
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withLocal(boolean value) {
    if (this.local == value) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        value,
        this.createTime,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#createTime() createTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withCreateTime(Date value) {
    if (this.createTime == value) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        Preconditions.checkNotNull(value, "createTime"),
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TokenListResponse#hash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenListResponse withHash(String value) {
    if (this.hash.equals(value)) return this;
    return new ImmutableTokenListResponse(
        this.accessorId,
        this.description,
        this.policies,
        this.createIndex,
        this.modifyIndex,
        this.local,
        this.createTime,
        Preconditions.checkNotNull(value, "hash"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTokenListResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTokenListResponse
        && equalTo((ImmutableTokenListResponse) another);
  }

  private boolean equalTo(ImmutableTokenListResponse another) {
    return accessorId.equals(another.accessorId)
        && description.equals(another.description)
        && policies.equals(another.policies)
        && createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex)
        && local == another.local
        && createTime.equals(another.createTime)
        && hash.equals(another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code accessorId}, {@code description}, {@code policies}, {@code createIndex}, {@code modifyIndex}, {@code local}, {@code createTime}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + accessorId.hashCode();
    h = h * 17 + description.hashCode();
    h = h * 17 + policies.hashCode();
    h = h * 17 + createIndex.hashCode();
    h = h * 17 + modifyIndex.hashCode();
    h = h * 17 + Booleans.hashCode(local);
    h = h * 17 + createTime.hashCode();
    h = h * 17 + hash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TokenListResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TokenListResponse")
        .omitNullValues()
        .add("accessorId", accessorId)
        .add("description", description)
        .add("policies", policies)
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("local", local)
        .add("createTime", createTime)
        .add("hash", hash)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends TokenListResponse {
    @Nullable String accessorId;
    @Nullable String description;
    List<Token.PolicyLink> policies = ImmutableList.of();
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    @Nullable Boolean local;
    @Nullable Date createTime;
    @Nullable String hash;
    @JsonProperty(value = "AccessorID")
    public void setAccessorId(String accessorId) {
      this.accessorId = accessorId;
    }
    @JsonProperty(value = "Description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty(value = "Policies")
    public void setPolicies(List<Token.PolicyLink> policies) {
      this.policies = policies;
    }
    @JsonProperty(value = "CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty(value = "ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty(value = "Local")
    public void setLocal(boolean local) {
      this.local = local;
    }
    @JsonProperty(value = "CreateTime")
    public void setCreateTime(Date createTime) {
      this.createTime = createTime;
    }
    @JsonProperty(value = "Hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @Override
    public String accessorId() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public List<Token.PolicyLink> policies() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public boolean local() { throw new UnsupportedOperationException(); }
    @Override
    public Date createTime() { throw new UnsupportedOperationException(); }
    @Override
    public String hash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableTokenListResponse fromJson(Json json) {
    ImmutableTokenListResponse.Builder builder = ImmutableTokenListResponse.builder();
    if (json.accessorId != null) {
      builder.accessorId(json.accessorId);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.local != null) {
      builder.local(json.local);
    }
    if (json.createTime != null) {
      builder.createTime(json.createTime);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TokenListResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TokenListResponse instance
   */
  public static ImmutableTokenListResponse copyOf(TokenListResponse instance) {
    if (instance instanceof ImmutableTokenListResponse) {
      return (ImmutableTokenListResponse) instance;
    }
    return ImmutableTokenListResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTokenListResponse ImmutableTokenListResponse}.
   * @return A new ImmutableTokenListResponse builder
   */
  public static ImmutableTokenListResponse.Builder builder() {
    return new ImmutableTokenListResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTokenListResponse ImmutableTokenListResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACCESSOR_ID = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_CREATE_INDEX = 0x4L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x8L;
    private static final long INIT_BIT_LOCAL = 0x10L;
    private static final long INIT_BIT_CREATE_TIME = 0x20L;
    private static final long INIT_BIT_HASH = 0x40L;
    private long initBits = 0x7f;

    private @Nullable String accessorId;
    private @Nullable String description;
    private ImmutableList.Builder<Token.PolicyLink> policiesBuilder = ImmutableList.builder();
    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;
    private boolean local;
    private @Nullable Date createTime;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.model.acl.BaseTokenResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseTokenResponse instance) {
      Preconditions.checkNotNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.model.acl.TokenListResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TokenListResponse instance) {
      Preconditions.checkNotNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BaseTokenResponse) {
        BaseTokenResponse instance = (BaseTokenResponse) object;
        modifyIndex(instance.modifyIndex());
        createTime(instance.createTime());
        accessorId(instance.accessorId());
        addAllPolicies(instance.policies());
        description(instance.description());
        createIndex(instance.createIndex());
        local(instance.local());
        hash(instance.hash());
      }
    }

    /**
     * Initializes the value for the {@link TokenListResponse#accessorId() accessorId} attribute.
     * @param accessorId The value for accessorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessorId(String accessorId) {
      this.accessorId = Preconditions.checkNotNull(accessorId, "accessorId");
      initBits &= ~INIT_BIT_ACCESSOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Preconditions.checkNotNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Adds one element to {@link TokenListResponse#policies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPolicies(Token.PolicyLink element) {
      policiesBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TokenListResponse#policies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPolicies(Token.PolicyLink... elements) {
      policiesBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link TokenListResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
      policiesBuilder = ImmutableList.builder();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link TokenListResponse#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
      policiesBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Preconditions.checkNotNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Preconditions.checkNotNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#local() local} attribute.
     * @param local The value for local 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder local(boolean local) {
      this.local = local;
      initBits &= ~INIT_BIT_LOCAL;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#createTime() createTime} attribute.
     * @param createTime The value for createTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createTime(Date createTime) {
      this.createTime = Preconditions.checkNotNull(createTime, "createTime");
      initBits &= ~INIT_BIT_CREATE_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link TokenListResponse#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hash(String hash) {
      this.hash = Preconditions.checkNotNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTokenListResponse ImmutableTokenListResponse}.
     * @return An immutable instance of TokenListResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTokenListResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTokenListResponse(
          accessorId,
          description,
          policiesBuilder.build(),
          createIndex,
          modifyIndex,
          local,
          createTime,
          hash);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ACCESSOR_ID) != 0) attributes.add("accessorId");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      if ((initBits & INIT_BIT_LOCAL) != 0) attributes.add("local");
      if ((initBits & INIT_BIT_CREATE_TIME) != 0) attributes.add("createTime");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      return "Cannot build TokenListResponse, some of required attributes are not set " + attributes;
    }
  }
}
