/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.model.acl.BaseTokenResponse;
import com.orbitz.consul.model.acl.Token;
import com.orbitz.consul.model.acl.TokenListResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTokenListResponse
extends TokenListResponse {
    private final String accessorId;
    private final String description;
    private final ImmutableList<Token.PolicyLink> policies;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;
    private final boolean local;
    private final Date createTime;
    private final String hash;

    private ImmutableTokenListResponse(String accessorId, String description, ImmutableList<Token.PolicyLink> policies, BigInteger createIndex, BigInteger modifyIndex, boolean local, Date createTime, String hash) {
        this.accessorId = accessorId;
        this.description = description;
        this.policies = policies;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.local = local;
        this.createTime = createTime;
        this.hash = hash;
    }

    @Override
    @JsonProperty(value="AccessorID")
    public String accessorId() {
        return this.accessorId;
    }

    @Override
    @JsonProperty(value="Description")
    public String description() {
        return this.description;
    }

    @JsonProperty(value="Policies")
    public ImmutableList<Token.PolicyLink> policies() {
        return this.policies;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    @Override
    @JsonProperty(value="Local")
    public boolean local() {
        return this.local;
    }

    @Override
    @JsonProperty(value="CreateTime")
    public Date createTime() {
        return this.createTime;
    }

    @Override
    @JsonProperty(value="Hash")
    public String hash() {
        return this.hash;
    }

    public final ImmutableTokenListResponse withAccessorId(String value) {
        if (this.accessorId.equals(value)) {
            return this;
        }
        return new ImmutableTokenListResponse((String)Preconditions.checkNotNull((Object)value, (Object)"accessorId"), this.description, this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, (String)Preconditions.checkNotNull((Object)value, (Object)"description"), this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withPolicies(Token.PolicyLink ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTokenListResponse(this.accessorId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withPolicies(Iterable<? extends Token.PolicyLink> elements) {
        if (this.policies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTokenListResponse(this.accessorId, this.description, (ImmutableList<Token.PolicyLink>)newValue, this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withCreateIndex(BigInteger value) {
        if (this.createIndex == value) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"createIndex"), this.modifyIndex, this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withModifyIndex(BigInteger value) {
        if (this.modifyIndex == value) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"modifyIndex"), this.local, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withLocal(boolean value) {
        if (this.local == value) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, value, this.createTime, this.hash);
    }

    public final ImmutableTokenListResponse withCreateTime(Date value) {
        if (this.createTime == value) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, this.local, (Date)Preconditions.checkNotNull((Object)value, (Object)"createTime"), this.hash);
    }

    public final ImmutableTokenListResponse withHash(String value) {
        if (this.hash.equals(value)) {
            return this;
        }
        return new ImmutableTokenListResponse(this.accessorId, this.description, this.policies, this.createIndex, this.modifyIndex, this.local, this.createTime, (String)Preconditions.checkNotNull((Object)value, (Object)"hash"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenListResponse && this.equalTo((ImmutableTokenListResponse)another);
    }

    private boolean equalTo(ImmutableTokenListResponse another) {
        return this.accessorId.equals(another.accessorId) && this.description.equals(another.description) && this.policies.equals(another.policies) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex) && this.local == another.local && this.createTime.equals(another.createTime) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.accessorId.hashCode();
        h = h * 17 + this.description.hashCode();
        h = h * 17 + this.policies.hashCode();
        h = h * 17 + this.createIndex.hashCode();
        h = h * 17 + this.modifyIndex.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.local);
        h = h * 17 + this.createTime.hashCode();
        h = h * 17 + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TokenListResponse").omitNullValues().add("accessorId", (Object)this.accessorId).add("description", (Object)this.description).add("policies", this.policies).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).add("local", this.local).add("createTime", (Object)this.createTime).add("hash", (Object)this.hash).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTokenListResponse fromJson(Json json) {
        Builder builder = ImmutableTokenListResponse.builder();
        if (json.accessorId != null) {
            builder.accessorId(json.accessorId);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.modifyIndex(json.modifyIndex);
        }
        if (json.local != null) {
            builder.local(json.local);
        }
        if (json.createTime != null) {
            builder.createTime(json.createTime);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    public static ImmutableTokenListResponse copyOf(TokenListResponse instance) {
        if (instance instanceof ImmutableTokenListResponse) {
            return (ImmutableTokenListResponse)instance;
        }
        return ImmutableTokenListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESSOR_ID = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_CREATE_INDEX = 4L;
        private static final long INIT_BIT_MODIFY_INDEX = 8L;
        private static final long INIT_BIT_LOCAL = 16L;
        private static final long INIT_BIT_CREATE_TIME = 32L;
        private static final long INIT_BIT_HASH = 64L;
        private long initBits = 127L;
        @Nullable
        private String accessorId;
        @Nullable
        private String description;
        private ImmutableList.Builder<Token.PolicyLink> policiesBuilder = ImmutableList.builder();
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;
        private boolean local;
        @Nullable
        private Date createTime;
        @Nullable
        private String hash;

        private Builder() {
        }

        public final Builder from(BaseTokenResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TokenListResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof BaseTokenResponse) {
                BaseTokenResponse instance = (BaseTokenResponse)object;
                this.modifyIndex(instance.modifyIndex());
                this.createTime(instance.createTime());
                this.accessorId(instance.accessorId());
                this.addAllPolicies(instance.policies());
                this.description(instance.description());
                this.createIndex(instance.createIndex());
                this.local(instance.local());
                this.hash(instance.hash());
            }
        }

        public final Builder accessorId(String accessorId) {
            this.accessorId = (String)Preconditions.checkNotNull((Object)accessorId, (Object)"accessorId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPolicies(Token.PolicyLink element) {
            this.policiesBuilder.add((Object)element);
            return this;
        }

        public final Builder addPolicies(Token.PolicyLink ... elements) {
            this.policiesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder policies(Iterable<? extends Token.PolicyLink> elements) {
            this.policiesBuilder = ImmutableList.builder();
            return this.addAllPolicies(elements);
        }

        public final Builder addAllPolicies(Iterable<? extends Token.PolicyLink> elements) {
            this.policiesBuilder.addAll(elements);
            return this;
        }

        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = (BigInteger)Preconditions.checkNotNull((Object)createIndex, (Object)"createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = (BigInteger)Preconditions.checkNotNull((Object)modifyIndex, (Object)"modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder local(boolean local) {
            this.local = local;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder createTime(Date createTime) {
            this.createTime = (Date)Preconditions.checkNotNull((Object)createTime, (Object)"createTime");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = (String)Preconditions.checkNotNull((Object)hash, (Object)"hash");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableTokenListResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenListResponse(this.accessorId, this.description, this.policiesBuilder.build(), this.createIndex, this.modifyIndex, this.local, this.createTime, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessorId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modifyIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("local");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build TokenListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends TokenListResponse {
        @Nullable
        String accessorId;
        @Nullable
        String description;
        List<Token.PolicyLink> policies = ImmutableList.of();
        @Nullable
        BigInteger createIndex;
        @Nullable
        BigInteger modifyIndex;
        @Nullable
        Boolean local;
        @Nullable
        Date createTime;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="AccessorID")
        public void setAccessorId(String accessorId) {
            this.accessorId = accessorId;
        }

        @JsonProperty(value="Description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="Policies")
        public void setPolicies(List<Token.PolicyLink> policies) {
            this.policies = policies;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @JsonProperty(value="Local")
        public void setLocal(boolean local) {
            this.local = local;
        }

        @JsonProperty(value="CreateTime")
        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public String accessorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Token.PolicyLink> policies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean local() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date createTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }
    }
}

