package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PolicyListResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePolicyListResponse.builder()}.
 */
@Generated(from = "PolicyListResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutablePolicyListResponse extends PolicyListResponse {
  private final String id;
  private final String name;
  private final @Nullable String datacenters;
  private final String hash;
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;

  private ImmutablePolicyListResponse(
      String id,
      String name,
      @Nullable String datacenters,
      String hash,
      BigInteger createIndex,
      BigInteger modifyIndex) {
    this.id = id;
    this.name = name;
    this.datacenters = datacenters;
    this.hash = hash;
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty("Datacenters")
  @Override
  public Optional<String> datacenters() {
    return Optional.ofNullable(datacenters);
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("Hash")
  @Override
  public String hash() {
    return hash;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolicyListResponse#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicyListResponse withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutablePolicyListResponse(newValue, this.name, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolicyListResponse#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicyListResponse withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePolicyListResponse(this.id, newValue, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PolicyListResponse#datacenters() datacenters} attribute.
   * @param value The value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicyListResponse withDatacenters(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datacenters");
    if (Objects.equals(this.datacenters, newValue)) return this;
    return new ImmutablePolicyListResponse(this.id, this.name, newValue, this.hash, this.createIndex, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PolicyListResponse#datacenters() datacenters} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicyListResponse withDatacenters(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenters, value)) return this;
    return new ImmutablePolicyListResponse(this.id, this.name, value, this.hash, this.createIndex, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolicyListResponse#hash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicyListResponse withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutablePolicyListResponse(this.id, this.name, this.datacenters, newValue, this.createIndex, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolicyListResponse#createIndex() createIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicyListResponse withCreateIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "createIndex");
    if (this.createIndex.equals(newValue)) return this;
    return new ImmutablePolicyListResponse(this.id, this.name, this.datacenters, this.hash, newValue, this.modifyIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolicyListResponse#modifyIndex() modifyIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicyListResponse withModifyIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
    if (this.modifyIndex.equals(newValue)) return this;
    return new ImmutablePolicyListResponse(this.id, this.name, this.datacenters, this.hash, this.createIndex, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePolicyListResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePolicyListResponse
        && equalTo((ImmutablePolicyListResponse) another);
  }

  private boolean equalTo(ImmutablePolicyListResponse another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(datacenters, another.datacenters)
        && hash.equals(another.hash)
        && createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code datacenters}, {@code hash}, {@code createIndex}, {@code modifyIndex}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(datacenters);
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + createIndex.hashCode();
    h += (h << 5) + modifyIndex.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PolicyListResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PolicyListResponse")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("datacenters", datacenters)
        .add("hash", hash)
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PolicyListResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PolicyListResponse {
    @Nullable String id;
    @Nullable String name;
    @Nullable Optional<String> datacenters = Optional.empty();
    @Nullable String hash;
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Datacenters")
    public void setDatacenters(Optional<String> datacenters) {
      this.datacenters = datacenters;
    }
    @JsonProperty("Hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty("ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datacenters() { throw new UnsupportedOperationException(); }
    @Override
    public String hash() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePolicyListResponse fromJson(Json json) {
    ImmutablePolicyListResponse.Builder builder = ImmutablePolicyListResponse.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.datacenters != null) {
      builder.datacenters(json.datacenters);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PolicyListResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PolicyListResponse instance
   */
  public static ImmutablePolicyListResponse copyOf(PolicyListResponse instance) {
    if (instance instanceof ImmutablePolicyListResponse) {
      return (ImmutablePolicyListResponse) instance;
    }
    return ImmutablePolicyListResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePolicyListResponse ImmutablePolicyListResponse}.
   * <pre>
   * ImmutablePolicyListResponse.builder()
   *    .id(String) // required {@link PolicyListResponse#id() id}
   *    .name(String) // required {@link PolicyListResponse#name() name}
   *    .datacenters(String) // optional {@link PolicyListResponse#datacenters() datacenters}
   *    .hash(String) // required {@link PolicyListResponse#hash() hash}
   *    .createIndex(java.math.BigInteger) // required {@link PolicyListResponse#createIndex() createIndex}
   *    .modifyIndex(java.math.BigInteger) // required {@link PolicyListResponse#modifyIndex() modifyIndex}
   *    .build();
   * </pre>
   * @return A new ImmutablePolicyListResponse builder
   */
  public static ImmutablePolicyListResponse.Builder builder() {
    return new ImmutablePolicyListResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePolicyListResponse ImmutablePolicyListResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PolicyListResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_HASH = 0x4L;
    private static final long INIT_BIT_CREATE_INDEX = 0x8L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String datacenters;
    private @Nullable String hash;
    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.model.acl.BasePolicyResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BasePolicyResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.model.acl.PolicyListResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PolicyListResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BasePolicyResponse) {
        BasePolicyResponse instance = (BasePolicyResponse) object;
        Optional<String> datacentersOptional = instance.datacenters();
        if (datacentersOptional.isPresent()) {
          datacenters(datacentersOptional);
        }
        name(instance.name());
        id(instance.id());
        modifyIndex(instance.modifyIndex());
        createIndex(instance.createIndex());
        hash(instance.hash());
      }
    }

    /**
     * Initializes the value for the {@link PolicyListResponse#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PolicyListResponse#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link PolicyListResponse#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenters(String datacenters) {
      this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
      return this;
    }

    /**
     * Initializes the optional value {@link PolicyListResponse#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenters")
    public final Builder datacenters(Optional<String> datacenters) {
      this.datacenters = datacenters.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PolicyListResponse#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link PolicyListResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateIndex")
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link PolicyListResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ModifyIndex")
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePolicyListResponse ImmutablePolicyListResponse}.
     * @return An immutable instance of PolicyListResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePolicyListResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePolicyListResponse(id, name, datacenters, hash, createIndex, modifyIndex);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      return "Cannot build PolicyListResponse, some of required attributes are not set " + attributes;
    }
  }
}
