package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CatalogRegistration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogRegistration.builder()}.
 */
@Generated(from = "CatalogRegistration", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogRegistration extends CatalogRegistration {
  private final @Nullable String datacenter;
  private final String node;
  private final String address;
  private final @Nullable TaggedAddresses taggedAddresses;
  private final @Nullable Service service;
  private final @Nullable Check check;
  private final @Nullable WriteRequest writeRequest;

  private ImmutableCatalogRegistration(
      @Nullable String datacenter,
      String node,
      String address,
      @Nullable TaggedAddresses taggedAddresses,
      @Nullable Service service,
      @Nullable Check check,
      @Nullable WriteRequest writeRequest) {
    this.datacenter = datacenter;
    this.node = node;
    this.address = address;
    this.taggedAddresses = taggedAddresses;
    this.service = service;
    this.check = check;
    this.writeRequest = writeRequest;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty("Datacenter")
  @Override
  public Optional<String> datacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String node() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String address() {
    return address;
  }

  /**
   * @return The value of the {@code taggedAddresses} attribute
   */
  @JsonProperty("TaggedAddresses")
  @Override
  public Optional<TaggedAddresses> taggedAddresses() {
    return Optional.ofNullable(taggedAddresses);
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public Optional<Service> service() {
    return Optional.ofNullable(service);
  }

  /**
   * @return The value of the {@code check} attribute
   */
  @JsonProperty("Check")
  @Override
  public Optional<Check> check() {
    return Optional.ofNullable(check);
  }

  /**
   * @return The value of the {@code writeRequest} attribute
   */
  @JsonProperty("WriteRequest")
  @Override
  public Optional<WriteRequest> writeRequest() {
    return Optional.ofNullable(writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#datacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withDatacenter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableCatalogRegistration(
        newValue,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#datacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableCatalogRegistration(
        value,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogRegistration#node() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogRegistration withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        newValue,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogRegistration#address() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogRegistration withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        newValue,
        this.taggedAddresses,
        this.service,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#taggedAddresses() taggedAddresses} attribute.
   * @param value The value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withTaggedAddresses(TaggedAddresses value) {
    @Nullable TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
    if (this.taggedAddresses == newValue) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, newValue, this.service, this.check, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#taggedAddresses() taggedAddresses} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for taggedAddresses
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCatalogRegistration withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
    @Nullable TaggedAddresses value = optional.orElse(null);
    if (this.taggedAddresses == value) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, value, this.service, this.check, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#service() service} attribute.
   * @param value The value for service
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withService(Service value) {
    @Nullable Service newValue = Objects.requireNonNull(value, "service");
    if (this.service == newValue) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        newValue,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#service() service} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for service
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCatalogRegistration withService(Optional<? extends Service> optional) {
    @Nullable Service value = optional.orElse(null);
    if (this.service == value) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        value,
        this.check,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#check() check} attribute.
   * @param value The value for check
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withCheck(Check value) {
    @Nullable Check newValue = Objects.requireNonNull(value, "check");
    if (this.check == newValue) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        newValue,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#check() check} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for check
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCatalogRegistration withCheck(Optional<? extends Check> optional) {
    @Nullable Check value = optional.orElse(null);
    if (this.check == value) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        value,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogRegistration#writeRequest() writeRequest} attribute.
   * @param value The value for writeRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogRegistration withWriteRequest(WriteRequest value) {
    @Nullable WriteRequest newValue = Objects.requireNonNull(value, "writeRequest");
    if (this.writeRequest == newValue) return this;
    return new ImmutableCatalogRegistration(
        this.datacenter,
        this.node,
        this.address,
        this.taggedAddresses,
        this.service,
        this.check,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogRegistration#writeRequest() writeRequest} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for writeRequest
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCatalogRegistration withWriteRequest(Optional<? extends WriteRequest> optional) {
    @Nullable WriteRequest value = optional.orElse(null);
    if (this.writeRequest == value) return this;
    return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogRegistration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogRegistration
        && equalTo((ImmutableCatalogRegistration) another);
  }

  private boolean equalTo(ImmutableCatalogRegistration another) {
    return Objects.equals(datacenter, another.datacenter)
        && node.equals(another.node)
        && address.equals(another.address)
        && Objects.equals(taggedAddresses, another.taggedAddresses)
        && Objects.equals(service, another.service)
        && Objects.equals(check, another.check)
        && Objects.equals(writeRequest, another.writeRequest);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code node}, {@code address}, {@code taggedAddresses}, {@code service}, {@code check}, {@code writeRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + node.hashCode();
    h += (h << 5) + address.hashCode();
    h += (h << 5) + Objects.hashCode(taggedAddresses);
    h += (h << 5) + Objects.hashCode(service);
    h += (h << 5) + Objects.hashCode(check);
    h += (h << 5) + Objects.hashCode(writeRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogRegistration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogRegistration")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("node", node)
        .add("address", address)
        .add("taggedAddresses", taggedAddresses)
        .add("service", service)
        .add("check", check)
        .add("writeRequest", writeRequest)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CatalogRegistration", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends CatalogRegistration {
    @Nullable Optional<String> datacenter = Optional.empty();
    @Nullable String node;
    @Nullable String address;
    @Nullable Optional<TaggedAddresses> taggedAddresses = Optional.empty();
    @Nullable Optional<Service> service = Optional.empty();
    @Nullable Optional<Check> check = Optional.empty();
    @Nullable Optional<WriteRequest> writeRequest = Optional.empty();
    @JsonProperty("Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("TaggedAddresses")
    public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses;
    }
    @JsonProperty("Service")
    public void setService(Optional<Service> service) {
      this.service = service;
    }
    @JsonProperty("Check")
    public void setCheck(Optional<Check> check) {
      this.check = check;
    }
    @JsonProperty("WriteRequest")
    public void setWriteRequest(Optional<WriteRequest> writeRequest) {
      this.writeRequest = writeRequest;
    }
    @Override
    public Optional<String> datacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String node() { throw new UnsupportedOperationException(); }
    @Override
    public String address() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<TaggedAddresses> taggedAddresses() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Service> service() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Check> check() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<WriteRequest> writeRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCatalogRegistration fromJson(Json json) {
    ImmutableCatalogRegistration.Builder builder = ImmutableCatalogRegistration.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.taggedAddresses != null) {
      builder.taggedAddresses(json.taggedAddresses);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.check != null) {
      builder.check(json.check);
    }
    if (json.writeRequest != null) {
      builder.writeRequest(json.writeRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogRegistration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogRegistration instance
   */
  public static ImmutableCatalogRegistration copyOf(CatalogRegistration instance) {
    if (instance instanceof ImmutableCatalogRegistration) {
      return (ImmutableCatalogRegistration) instance;
    }
    return ImmutableCatalogRegistration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
   * <pre>
   * ImmutableCatalogRegistration.builder()
   *    .datacenter(String) // optional {@link CatalogRegistration#datacenter() datacenter}
   *    .node(String) // required {@link CatalogRegistration#node() node}
   *    .address(String) // required {@link CatalogRegistration#address() address}
   *    .taggedAddresses(com.orbitz.consul.model.catalog.TaggedAddresses) // optional {@link CatalogRegistration#taggedAddresses() taggedAddresses}
   *    .service(com.orbitz.consul.model.health.Service) // optional {@link CatalogRegistration#service() service}
   *    .check(com.orbitz.consul.model.agent.Check) // optional {@link CatalogRegistration#check() check}
   *    .writeRequest(com.orbitz.consul.model.catalog.WriteRequest) // optional {@link CatalogRegistration#writeRequest() writeRequest}
   *    .build();
   * </pre>
   * @return A new ImmutableCatalogRegistration builder
   */
  public static ImmutableCatalogRegistration.Builder builder() {
    return new ImmutableCatalogRegistration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CatalogRegistration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String datacenter;
    private @Nullable String node;
    private @Nullable String address;
    private @Nullable TaggedAddresses taggedAddresses;
    private @Nullable Service service;
    private @Nullable Check check;
    private @Nullable WriteRequest writeRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogRegistration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CatalogRegistration instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> datacenterOptional = instance.datacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      node(instance.node());
      address(instance.address());
      Optional<TaggedAddresses> taggedAddressesOptional = instance.taggedAddresses();
      if (taggedAddressesOptional.isPresent()) {
        taggedAddresses(taggedAddressesOptional);
      }
      Optional<Service> serviceOptional = instance.service();
      if (serviceOptional.isPresent()) {
        service(serviceOptional);
      }
      Optional<Check> checkOptional = instance.check();
      if (checkOptional.isPresent()) {
        check(checkOptional);
      }
      Optional<WriteRequest> writeRequestOptional = instance.writeRequest();
      if (writeRequestOptional.isPresent()) {
        writeRequest(writeRequestOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenter")
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogRegistration#node() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogRegistration#address() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#taggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
      this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#taggedAddresses() taggedAddresses} to taggedAddresses.
     * @param taggedAddresses The value for taggedAddresses
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TaggedAddresses")
    public final Builder taggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
      this.taggedAddresses = taggedAddresses.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#service() service} to service.
     * @param service The value for service
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder service(Service service) {
      this.service = Objects.requireNonNull(service, "service");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#service() service} to service.
     * @param service The value for service
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(Optional<? extends Service> service) {
      this.service = service.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#check() check} to check.
     * @param check The value for check
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder check(Check check) {
      this.check = Objects.requireNonNull(check, "check");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#check() check} to check.
     * @param check The value for check
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Check")
    public final Builder check(Optional<? extends Check> check) {
      this.check = check.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder writeRequest(WriteRequest writeRequest) {
      this.writeRequest = Objects.requireNonNull(writeRequest, "writeRequest");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogRegistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("WriteRequest")
    public final Builder writeRequest(Optional<? extends WriteRequest> writeRequest) {
      this.writeRequest = writeRequest.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogRegistration ImmutableCatalogRegistration}.
     * @return An immutable instance of CatalogRegistration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogRegistration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogRegistration(datacenter, node, address, taggedAddresses, service, check, writeRequest);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      return "Cannot build CatalogRegistration, some of required attributes are not set " + attributes;
    }
  }
}
