package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Coordinate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCoordinate.builder()}.
 */
@Generated(from = "Coordinate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCoordinate extends Coordinate {
  private final String node;
  private final Coord coord;

  private ImmutableCoordinate(String node, Coord coord) {
    this.node = node;
    this.coord = coord;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code coord} attribute
   */
  @JsonProperty("Coord")
  @Override
  public Coord getCoord() {
    return coord;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Coordinate#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCoordinate withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableCoordinate(newValue, this.coord);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Coordinate#getCoord() coord} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for coord
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCoordinate withCoord(Coord value) {
    if (this.coord == value) return this;
    Coord newValue = Objects.requireNonNull(value, "coord");
    return new ImmutableCoordinate(this.node, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCoordinate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCoordinate
        && equalTo((ImmutableCoordinate) another);
  }

  private boolean equalTo(ImmutableCoordinate another) {
    return node.equals(another.node)
        && coord.equals(another.coord);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code coord}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + coord.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Coordinate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Coordinate")
        .omitNullValues()
        .add("node", node)
        .add("coord", coord)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Coordinate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Coordinate {
    @Nullable String node;
    @Nullable Coord coord;
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("Coord")
    public void setCoord(Coord coord) {
      this.coord = coord;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public Coord getCoord() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCoordinate fromJson(Json json) {
    ImmutableCoordinate.Builder builder = ImmutableCoordinate.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.coord != null) {
      builder.coord(json.coord);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Coordinate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Coordinate instance
   */
  public static ImmutableCoordinate copyOf(Coordinate instance) {
    if (instance instanceof ImmutableCoordinate) {
      return (ImmutableCoordinate) instance;
    }
    return ImmutableCoordinate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCoordinate ImmutableCoordinate}.
   * <pre>
   * ImmutableCoordinate.builder()
   *    .node(String) // required {@link Coordinate#getNode() node}
   *    .coord(com.orbitz.consul.model.coordinate.Coord) // required {@link Coordinate#getCoord() coord}
   *    .build();
   * </pre>
   * @return A new ImmutableCoordinate builder
   */
  public static ImmutableCoordinate.Builder builder() {
    return new ImmutableCoordinate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCoordinate ImmutableCoordinate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Coordinate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_COORD = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String node;
    private @Nullable Coord coord;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Coordinate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Coordinate instance) {
      Objects.requireNonNull(instance, "instance");
      node(instance.getNode());
      coord(instance.getCoord());
      return this;
    }

    /**
     * Initializes the value for the {@link Coordinate#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Coordinate#getCoord() coord} attribute.
     * @param coord The value for coord 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Coord")
    public final Builder coord(Coord coord) {
      this.coord = Objects.requireNonNull(coord, "coord");
      initBits &= ~INIT_BIT_COORD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCoordinate ImmutableCoordinate}.
     * @return An immutable instance of Coordinate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCoordinate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCoordinate(node, coord);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_COORD) != 0) attributes.add("coord");
      return "Cannot build Coordinate, some of required attributes are not set " + attributes;
    }
  }
}
