package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Agent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAgent.builder()}.
 */
@Generated(from = "Agent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAgent extends Agent {
  private final Config config;
  private final @Nullable DebugConfig debugConfig;
  private final Member member;

  private ImmutableAgent(
      Config config,
      @Nullable DebugConfig debugConfig,
      Member member) {
    this.config = config;
    this.debugConfig = debugConfig;
    this.member = member;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public Config getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code debugConfig} attribute
   */
  @JsonProperty("DebugConfig")
  @Override
  public @Nullable DebugConfig getDebugConfig() {
    return debugConfig;
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @JsonProperty("Member")
  @Override
  public Member getMember() {
    return member;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getConfig() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withConfig(Config value) {
    if (this.config == value) return this;
    Config newValue = Objects.requireNonNull(value, "config");
    return new ImmutableAgent(newValue, this.debugConfig, this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getDebugConfig() debugConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for debugConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withDebugConfig(@Nullable DebugConfig value) {
    if (this.debugConfig == value) return this;
    return new ImmutableAgent(this.config, value, this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Agent#getMember() member} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for member
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgent withMember(Member value) {
    if (this.member == value) return this;
    Member newValue = Objects.requireNonNull(value, "member");
    return new ImmutableAgent(this.config, this.debugConfig, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAgent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAgent
        && equalTo((ImmutableAgent) another);
  }

  private boolean equalTo(ImmutableAgent another) {
    return config.equals(another.config)
        && Objects.equals(debugConfig, another.debugConfig)
        && member.equals(another.member);
  }

  /**
   * Computes a hash code from attributes: {@code config}, {@code debugConfig}, {@code member}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + config.hashCode();
    h += (h << 5) + Objects.hashCode(debugConfig);
    h += (h << 5) + member.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Agent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Agent")
        .omitNullValues()
        .add("config", config)
        .add("debugConfig", debugConfig)
        .add("member", member)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Agent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Agent {
    @Nullable Config config;
    @Nullable DebugConfig debugConfig;
    @Nullable Member member;
    @JsonProperty("Config")
    public void setConfig(Config config) {
      this.config = config;
    }
    @JsonProperty("DebugConfig")
    public void setDebugConfig(@Nullable DebugConfig debugConfig) {
      this.debugConfig = debugConfig;
    }
    @JsonProperty("Member")
    public void setMember(Member member) {
      this.member = member;
    }
    @Override
    public Config getConfig() { throw new UnsupportedOperationException(); }
    @Override
    public DebugConfig getDebugConfig() { throw new UnsupportedOperationException(); }
    @Override
    public Member getMember() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAgent fromJson(Json json) {
    ImmutableAgent.Builder builder = ImmutableAgent.builder();
    if (json.config != null) {
      builder.config(json.config);
    }
    if (json.debugConfig != null) {
      builder.debugConfig(json.debugConfig);
    }
    if (json.member != null) {
      builder.member(json.member);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Agent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Agent instance
   */
  public static ImmutableAgent copyOf(Agent instance) {
    if (instance instanceof ImmutableAgent) {
      return (ImmutableAgent) instance;
    }
    return ImmutableAgent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAgent ImmutableAgent}.
   * <pre>
   * ImmutableAgent.builder()
   *    .config(com.orbitz.consul.model.agent.Config) // required {@link Agent#getConfig() config}
   *    .debugConfig(com.orbitz.consul.model.agent.DebugConfig | null) // nullable {@link Agent#getDebugConfig() debugConfig}
   *    .member(com.orbitz.consul.model.agent.Member) // required {@link Agent#getMember() member}
   *    .build();
   * </pre>
   * @return A new ImmutableAgent builder
   */
  public static ImmutableAgent.Builder builder() {
    return new ImmutableAgent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAgent ImmutableAgent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Agent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONFIG = 0x1L;
    private static final long INIT_BIT_MEMBER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Config config;
    private @Nullable DebugConfig debugConfig;
    private @Nullable Member member;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Agent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Agent instance) {
      Objects.requireNonNull(instance, "instance");
      config(instance.getConfig());
      @Nullable DebugConfig debugConfigValue = instance.getDebugConfig();
      if (debugConfigValue != null) {
        debugConfig(debugConfigValue);
      }
      member(instance.getMember());
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getConfig() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Config")
    public final Builder config(Config config) {
      this.config = Objects.requireNonNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getDebugConfig() debugConfig} attribute.
     * @param debugConfig The value for debugConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DebugConfig")
    public final Builder debugConfig(@Nullable DebugConfig debugConfig) {
      this.debugConfig = debugConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link Agent#getMember() member} attribute.
     * @param member The value for member 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Member")
    public final Builder member(Member member) {
      this.member = Objects.requireNonNull(member, "member");
      initBits &= ~INIT_BIT_MEMBER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAgent ImmutableAgent}.
     * @return An immutable instance of Agent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAgent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAgent(config, debugConfig, member);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_MEMBER) != 0) attributes.add("member");
      return "Cannot build Agent, some of required attributes are not set " + attributes;
    }
  }
}
