package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Check}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheck.builder()}.
 */
@Generated(from = "Check", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCheck extends Check {
  private final String id;
  private final String name;
  private final @Nullable String notes;
  private final @Nullable String output;
  private final @Nullable List<String> args;
  private final @Nullable String interval;
  private final @Nullable String ttl;
  private final @Nullable String http;
  private final @Nullable String tcp;
  private final @Nullable String grpc;
  private final @Nullable Boolean grpcUseTls;
  private final @Nullable String serviceId;
  private final ImmutableList<String> serviceTags;
  private final @Nullable String deregisterCriticalServiceAfter;

  private ImmutableCheck(
      String id,
      String name,
      @Nullable String notes,
      @Nullable String output,
      @Nullable List<String> args,
      @Nullable String interval,
      @Nullable String ttl,
      @Nullable String http,
      @Nullable String tcp,
      @Nullable String grpc,
      @Nullable Boolean grpcUseTls,
      @Nullable String serviceId,
      ImmutableList<String> serviceTags,
      @Nullable String deregisterCriticalServiceAfter) {
    this.id = id;
    this.name = name;
    this.notes = notes;
    this.output = output;
    this.args = args;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.tcp = tcp;
    this.grpc = grpc;
    this.grpcUseTls = grpcUseTls;
    this.serviceId = serviceId;
    this.serviceTags = serviceTags;
    this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty("Notes")
  @Override
  public Optional<String> getNotes() {
    return Optional.ofNullable(notes);
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty("Output")
  @Override
  public Optional<String> getOutput() {
    return Optional.ofNullable(output);
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @JsonProperty("Args")
  @Override
  public Optional<List<String>> getArgs() {
    return Optional.ofNullable(args);
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @JsonProperty("Interval")
  @Override
  public Optional<String> getInterval() {
    return Optional.ofNullable(interval);
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public Optional<String> getTtl() {
    return Optional.ofNullable(ttl);
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty("HTTP")
  @Override
  public Optional<String> getHttp() {
    return Optional.ofNullable(http);
  }

  /**
   * @return The value of the {@code tcp} attribute
   */
  @JsonProperty("TCP")
  @Override
  public Optional<String> getTcp() {
    return Optional.ofNullable(tcp);
  }

  /**
   * @return The value of the {@code grpc} attribute
   */
  @JsonProperty("GRPC")
  @Override
  public Optional<String> getGrpc() {
    return Optional.ofNullable(grpc);
  }

  /**
   * @return The value of the {@code grpcUseTls} attribute
   */
  @JsonProperty("GRPCUseTLS")
  @Override
  public Optional<Boolean> getGrpcUseTls() {
    return Optional.ofNullable(grpcUseTls);
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return Optional.ofNullable(serviceId);
  }

  /**
   * @return The value of the {@code serviceTags} attribute
   */
  @JsonProperty("ServiceTags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }

  /**
   * @return The value of the {@code deregisterCriticalServiceAfter} attribute
   */
  @JsonProperty("DeregisterCriticalServiceAfter")
  @Override
  public Optional<String> getDeregisterCriticalServiceAfter() {
    return Optional.ofNullable(deregisterCriticalServiceAfter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        newValue,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Check#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheck withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        newValue,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "notes");
    if (Objects.equals(this.notes, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        newValue,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getNotes() notes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notes, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        value,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getOutput() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "output");
    if (Objects.equals(this.output, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        newValue,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getOutput() output} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withOutput(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.output, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        value,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getArgs() args} attribute.
   * @param value The value for args
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withArgs(List<String> value) {
    @Nullable List<String> newValue = Objects.requireNonNull(value, "args");
    if (this.args == newValue) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        newValue,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getArgs() args} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for args
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheck withArgs(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.args == value) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        value,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getInterval() interval} attribute.
   * @param value The value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "interval");
    if (Objects.equals(this.interval, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        newValue,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getInterval() interval} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.interval, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        value,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "ttl");
    if (Objects.equals(this.ttl, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        newValue,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTtl() ttl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.ttl, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        value,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getHttp() http} attribute.
   * @param value The value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "http");
    if (Objects.equals(this.http, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        newValue,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getHttp() http} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.http, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        value,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getTcp() tcp} attribute.
   * @param value The value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "tcp");
    if (Objects.equals(this.tcp, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        newValue,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getTcp() tcp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withTcp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tcp, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        value,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getGrpc() grpc} attribute.
   * @param value The value for grpc
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withGrpc(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "grpc");
    if (Objects.equals(this.grpc, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        newValue,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getGrpc() grpc} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for grpc
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withGrpc(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.grpc, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        value,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getGrpcUseTls() grpcUseTls} attribute.
   * @param value The value for grpcUseTls
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withGrpcUseTls(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.grpcUseTls, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        newValue,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getGrpcUseTls() grpcUseTls} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for grpcUseTls
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withGrpcUseTls(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.grpcUseTls, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        value,
        this.serviceId,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getServiceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serviceId");
    if (Objects.equals(this.serviceId, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        newValue,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getServiceId() serviceId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceId, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        value,
        this.serviceTags,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Check#getServiceTags() serviceTags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        newValue,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Check#getServiceTags() serviceTags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceTags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        newValue,
        this.deregisterCriticalServiceAfter));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * @param value The value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withDeregisterCriticalServiceAfter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "deregisterCriticalServiceAfter");
    if (Objects.equals(this.deregisterCriticalServiceAfter, newValue)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.deregisterCriticalServiceAfter, value)) return this;
    return validate(new ImmutableCheck(
        this.id,
        this.name,
        this.notes,
        this.output,
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.serviceId,
        this.serviceTags,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheck
        && equalTo((ImmutableCheck) another);
  }

  private boolean equalTo(ImmutableCheck another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(notes, another.notes)
        && Objects.equals(output, another.output)
        && Objects.equals(args, another.args)
        && Objects.equals(interval, another.interval)
        && Objects.equals(ttl, another.ttl)
        && Objects.equals(http, another.http)
        && Objects.equals(tcp, another.tcp)
        && Objects.equals(grpc, another.grpc)
        && Objects.equals(grpcUseTls, another.grpcUseTls)
        && Objects.equals(serviceId, another.serviceId)
        && serviceTags.equals(another.serviceTags)
        && Objects.equals(deregisterCriticalServiceAfter, another.deregisterCriticalServiceAfter);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code notes}, {@code output}, {@code args}, {@code interval}, {@code ttl}, {@code http}, {@code tcp}, {@code grpc}, {@code grpcUseTls}, {@code serviceId}, {@code serviceTags}, {@code deregisterCriticalServiceAfter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(notes);
    h += (h << 5) + Objects.hashCode(output);
    h += (h << 5) + Objects.hashCode(args);
    h += (h << 5) + Objects.hashCode(interval);
    h += (h << 5) + Objects.hashCode(ttl);
    h += (h << 5) + Objects.hashCode(http);
    h += (h << 5) + Objects.hashCode(tcp);
    h += (h << 5) + Objects.hashCode(grpc);
    h += (h << 5) + Objects.hashCode(grpcUseTls);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + serviceTags.hashCode();
    h += (h << 5) + Objects.hashCode(deregisterCriticalServiceAfter);
    return h;
  }

  /**
   * Prints the immutable value {@code Check} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Check")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("notes", notes)
        .add("output", output)
        .add("args", args)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .add("tcp", tcp)
        .add("grpc", grpc)
        .add("grpcUseTls", grpcUseTls)
        .add("serviceId", serviceId)
        .add("serviceTags", serviceTags)
        .add("deregisterCriticalServiceAfter", deregisterCriticalServiceAfter)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Check", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Check {
    @Nullable String id;
    @Nullable String name;
    @Nullable Optional<String> notes = Optional.empty();
    @Nullable Optional<String> output = Optional.empty();
    @Nullable Optional<List<String>> args = Optional.empty();
    @Nullable Optional<String> interval = Optional.empty();
    @Nullable Optional<String> ttl = Optional.empty();
    @Nullable Optional<String> http = Optional.empty();
    @Nullable Optional<String> tcp = Optional.empty();
    @Nullable Optional<String> grpc = Optional.empty();
    @Nullable Optional<Boolean> grpcUseTls = Optional.empty();
    @Nullable Optional<String> serviceId = Optional.empty();
    @Nullable List<String> serviceTags = ImmutableList.of();
    @Nullable Optional<String> deregisterCriticalServiceAfter = Optional.empty();
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty("Output")
    public void setOutput(Optional<String> output) {
      this.output = output;
    }
    @JsonProperty("Args")
    public void setArgs(Optional<List<String>> args) {
      this.args = args;
    }
    @JsonProperty("Interval")
    public void setInterval(Optional<String> interval) {
      this.interval = interval;
    }
    @JsonProperty("TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty("HTTP")
    public void setHttp(Optional<String> http) {
      this.http = http;
    }
    @JsonProperty("TCP")
    public void setTcp(Optional<String> tcp) {
      this.tcp = tcp;
    }
    @JsonProperty("GRPC")
    public void setGrpc(Optional<String> grpc) {
      this.grpc = grpc;
    }
    @JsonProperty("GRPCUseTLS")
    public void setGrpcUseTls(Optional<Boolean> grpcUseTls) {
      this.grpcUseTls = grpcUseTls;
    }
    @JsonProperty("ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("ServiceTags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setServiceTags(List<String> serviceTags) {
      this.serviceTags = serviceTags;
    }
    @JsonProperty("DeregisterCriticalServiceAfter")
    public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOutput() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getArgs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInterval() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHttp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTcp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getGrpc() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getGrpcUseTls() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getServiceTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDeregisterCriticalServiceAfter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheck fromJson(Json json) {
    ImmutableCheck.Builder builder = ImmutableCheck.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.args != null) {
      builder.args(json.args);
    }
    if (json.interval != null) {
      builder.interval(json.interval);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.http != null) {
      builder.http(json.http);
    }
    if (json.tcp != null) {
      builder.tcp(json.tcp);
    }
    if (json.grpc != null) {
      builder.grpc(json.grpc);
    }
    if (json.grpcUseTls != null) {
      builder.grpcUseTls(json.grpcUseTls);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceTags != null) {
      builder.addAllServiceTags(json.serviceTags);
    }
    if (json.deregisterCriticalServiceAfter != null) {
      builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
    }
    return builder.build();
  }

  private static ImmutableCheck validate(ImmutableCheck instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Check} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Check instance
   */
  public static ImmutableCheck copyOf(Check instance) {
    if (instance instanceof ImmutableCheck) {
      return (ImmutableCheck) instance;
    }
    return ImmutableCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheck ImmutableCheck}.
   * <pre>
   * ImmutableCheck.builder()
   *    .id(String) // required {@link Check#getId() id}
   *    .name(String) // required {@link Check#getName() name}
   *    .notes(String) // optional {@link Check#getNotes() notes}
   *    .output(String) // optional {@link Check#getOutput() output}
   *    .args(List&amp;lt;String&amp;gt;) // optional {@link Check#getArgs() args}
   *    .interval(String) // optional {@link Check#getInterval() interval}
   *    .ttl(String) // optional {@link Check#getTtl() ttl}
   *    .http(String) // optional {@link Check#getHttp() http}
   *    .tcp(String) // optional {@link Check#getTcp() tcp}
   *    .grpc(String) // optional {@link Check#getGrpc() grpc}
   *    .grpcUseTls(Boolean) // optional {@link Check#getGrpcUseTls() grpcUseTls}
   *    .serviceId(String) // optional {@link Check#getServiceId() serviceId}
   *    .addServiceTags|addAllServiceTags(String) // {@link Check#getServiceTags() serviceTags} elements
   *    .deregisterCriticalServiceAfter(String) // optional {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter}
   *    .build();
   * </pre>
   * @return A new ImmutableCheck builder
   */
  public static ImmutableCheck.Builder builder() {
    return new ImmutableCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheck ImmutableCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Check", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String notes;
    private @Nullable String output;
    private @Nullable List<String> args;
    private @Nullable String interval;
    private @Nullable String ttl;
    private @Nullable String http;
    private @Nullable String tcp;
    private @Nullable String grpc;
    private @Nullable Boolean grpcUseTls;
    private @Nullable String serviceId;
    private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();
    private @Nullable String deregisterCriticalServiceAfter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Check} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Check instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<List<String>> argsOptional = instance.getArgs();
      if (argsOptional.isPresent()) {
        args(argsOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> tcpOptional = instance.getTcp();
      if (tcpOptional.isPresent()) {
        tcp(tcpOptional);
      }
      Optional<String> grpcOptional = instance.getGrpc();
      if (grpcOptional.isPresent()) {
        grpc(grpcOptional);
      }
      Optional<Boolean> grpcUseTlsOptional = instance.getGrpcUseTls();
      if (grpcUseTlsOptional.isPresent()) {
        grpcUseTls(grpcUseTlsOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      addAllServiceTags(instance.getServiceTags());
      Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
      if (deregisterCriticalServiceAfterOptional.isPresent()) {
        deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Check#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder notes(String notes) {
      this.notes = Objects.requireNonNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Notes")
    public final Builder notes(Optional<String> notes) {
      this.notes = notes.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder output(String output) {
      this.output = Objects.requireNonNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Output")
    public final Builder output(Optional<String> output) {
      this.output = output.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(List<String> args) {
      this.args = Objects.requireNonNull(args, "args");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Args")
    public final Builder args(Optional<? extends List<String>> args) {
      this.args = args.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder interval(String interval) {
      this.interval = Objects.requireNonNull(interval, "interval");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Interval")
    public final Builder interval(Optional<String> interval) {
      this.interval = interval.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ttl(String ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TTL")
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = ttl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder http(String http) {
      this.http = Objects.requireNonNull(http, "http");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("HTTP")
    public final Builder http(Optional<String> http) {
      this.http = http.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tcp(String tcp) {
      this.tcp = Objects.requireNonNull(tcp, "tcp");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TCP")
    public final Builder tcp(Optional<String> tcp) {
      this.tcp = tcp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getGrpc() grpc} to grpc.
     * @param grpc The value for grpc
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder grpc(String grpc) {
      this.grpc = Objects.requireNonNull(grpc, "grpc");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getGrpc() grpc} to grpc.
     * @param grpc The value for grpc
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("GRPC")
    public final Builder grpc(Optional<String> grpc) {
      this.grpc = grpc.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getGrpcUseTls() grpcUseTls} to grpcUseTls.
     * @param grpcUseTls The value for grpcUseTls
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder grpcUseTls(boolean grpcUseTls) {
      this.grpcUseTls = grpcUseTls;
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getGrpcUseTls() grpcUseTls} to grpcUseTls.
     * @param grpcUseTls The value for grpcUseTls
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("GRPCUseTLS")
    public final Builder grpcUseTls(Optional<Boolean> grpcUseTls) {
      this.grpcUseTls = grpcUseTls.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceID")
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = serviceId.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Check#getServiceTags() serviceTags} list.
     * @param element A serviceTags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String element) {
      this.serviceTags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Check#getServiceTags() serviceTags} list.
     * @param elements An array of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String... elements) {
      this.serviceTags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Check#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceTags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public final Builder serviceTags(Iterable<String> elements) {
      this.serviceTags = ImmutableList.builder();
      return addAllServiceTags(elements);
    }

    /**
     * Adds elements to {@link Check#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServiceTags(Iterable<String> elements) {
      this.serviceTags.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = Objects.requireNonNull(deregisterCriticalServiceAfter, "deregisterCriticalServiceAfter");
      return this;
    }

    /**
     * Initializes the optional value {@link Check#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DeregisterCriticalServiceAfter")
    public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheck ImmutableCheck}.
     * @return An immutable instance of Check
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableCheck.validate(new ImmutableCheck(
          id,
          name,
          notes,
          output,
          args,
          interval,
          ttl,
          http,
          tcp,
          grpc,
          grpcUseTls,
          serviceId,
          serviceTags.build(),
          deregisterCriticalServiceAfter));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Check, some of required attributes are not set " + attributes;
    }
  }
}
