package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WriteRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWriteRequest.builder()}.
 */
@Generated(from = "WriteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableWriteRequest extends WriteRequest {
  private final String token;

  private ImmutableWriteRequest(String token) {
    this.token = token;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty("Token")
  @Override
  public String token() {
    return token;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WriteRequest#token() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWriteRequest withToken(String value) {
    String newValue = Objects.requireNonNull(value, "token");
    if (this.token.equals(newValue)) return this;
    return new ImmutableWriteRequest(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWriteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWriteRequest
        && equalTo((ImmutableWriteRequest) another);
  }

  private boolean equalTo(ImmutableWriteRequest another) {
    return token.equals(another.token);
  }

  /**
   * Computes a hash code from attributes: {@code token}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + token.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WriteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WriteRequest")
        .omitNullValues()
        .add("token", token)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "WriteRequest", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends WriteRequest {
    @Nullable String token;
    @JsonProperty("Token")
    public void setToken(String token) {
      this.token = token;
    }
    @Override
    public String token() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWriteRequest fromJson(Json json) {
    ImmutableWriteRequest.Builder builder = ImmutableWriteRequest.builder();
    if (json.token != null) {
      builder.token(json.token);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link WriteRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WriteRequest instance
   */
  public static ImmutableWriteRequest copyOf(WriteRequest instance) {
    if (instance instanceof ImmutableWriteRequest) {
      return (ImmutableWriteRequest) instance;
    }
    return ImmutableWriteRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWriteRequest ImmutableWriteRequest}.
   * <pre>
   * ImmutableWriteRequest.builder()
   *    .token(String) // required {@link WriteRequest#token() token}
   *    .build();
   * </pre>
   * @return A new ImmutableWriteRequest builder
   */
  public static ImmutableWriteRequest.Builder builder() {
    return new ImmutableWriteRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWriteRequest ImmutableWriteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WriteRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String token;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WriteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WriteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      token(instance.token());
      return this;
    }

    /**
     * Initializes the value for the {@link WriteRequest#token() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Token")
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWriteRequest ImmutableWriteRequest}.
     * @return An immutable instance of WriteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWriteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWriteRequest(token);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      return "Cannot build WriteRequest, some of required attributes are not set " + attributes;
    }
  }
}
