package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AclResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAclResponse.builder()}.
 */
@Generated(from = "AclResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableAclResponse extends AclResponse {
  private final BigInteger createIndex;
  private final BigInteger modifyIndex;
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String type;
  private final @Nullable String rules;

  private ImmutableAclResponse(
      BigInteger createIndex,
      BigInteger modifyIndex,
      @Nullable String id,
      @Nullable String name,
      @Nullable String type,
      @Nullable String rules) {
    this.createIndex = createIndex;
    this.modifyIndex = modifyIndex;
    this.id = id;
    this.name = name;
    this.type = type;
    this.rules = rules;
  }

  /**
   * @return The value of the {@code createIndex} attribute
   */
  @JsonProperty("CreateIndex")
  @Override
  public BigInteger createIndex() {
    return createIndex;
  }

  /**
   * @return The value of the {@code modifyIndex} attribute
   */
  @JsonProperty("ModifyIndex")
  @Override
  public BigInteger modifyIndex() {
    return modifyIndex;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public Optional<String> name() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("Type")
  @Override
  public Optional<String> type() {
    return Optional.ofNullable(type);
  }

  /**
   * @return The value of the {@code rules} attribute
   */
  @JsonProperty("Rules")
  @Override
  public Optional<String> rules() {
    return Optional.ofNullable(rules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AclResponse#createIndex() createIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAclResponse withCreateIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "createIndex");
    if (this.createIndex.equals(newValue)) return this;
    return new ImmutableAclResponse(newValue, this.modifyIndex, this.id, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AclResponse#modifyIndex() modifyIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifyIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAclResponse withModifyIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
    if (this.modifyIndex.equals(newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, newValue, this.id, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, newValue, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, value, this.name, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#name() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, newValue, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#name() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, value, this.type, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#type() type} attribute.
   * @param value The value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "type");
    if (Objects.equals(this.type, newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, newValue, this.rules);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#type() type} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, value, this.rules);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AclResponse#rules() rules} attribute.
   * @param value The value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withRules(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "rules");
    if (Objects.equals(this.rules, newValue)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AclResponse#rules() rules} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAclResponse withRules(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rules, value)) return this;
    return new ImmutableAclResponse(this.createIndex, this.modifyIndex, this.id, this.name, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAclResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAclResponse
        && equalTo((ImmutableAclResponse) another);
  }

  private boolean equalTo(ImmutableAclResponse another) {
    return createIndex.equals(another.createIndex)
        && modifyIndex.equals(another.modifyIndex)
        && Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(type, another.type)
        && Objects.equals(rules, another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code createIndex}, {@code modifyIndex}, {@code id}, {@code name}, {@code type}, {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + createIndex.hashCode();
    h += (h << 5) + modifyIndex.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(rules);
    return h;
  }

  /**
   * Prints the immutable value {@code AclResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AclResponse")
        .omitNullValues()
        .add("createIndex", createIndex)
        .add("modifyIndex", modifyIndex)
        .add("id", id)
        .add("name", name)
        .add("type", type)
        .add("rules", rules)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AclResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AclResponse {
    @Nullable BigInteger createIndex;
    @Nullable BigInteger modifyIndex;
    @Nullable Optional<String> id = Optional.empty();
    @Nullable Optional<String> name = Optional.empty();
    @Nullable Optional<String> type = Optional.empty();
    @Nullable Optional<String> rules = Optional.empty();
    @JsonProperty("CreateIndex")
    public void setCreateIndex(BigInteger createIndex) {
      this.createIndex = createIndex;
    }
    @JsonProperty("ModifyIndex")
    public void setModifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = modifyIndex;
    }
    @JsonProperty("ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty("Name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty("Type")
    public void setType(Optional<String> type) {
      this.type = type;
    }
    @JsonProperty("Rules")
    public void setRules(Optional<String> rules) {
      this.rules = rules;
    }
    @Override
    public BigInteger createIndex() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger modifyIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> type() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rules() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAclResponse fromJson(Json json) {
    ImmutableAclResponse.Builder builder = ImmutableAclResponse.builder();
    if (json.createIndex != null) {
      builder.createIndex(json.createIndex);
    }
    if (json.modifyIndex != null) {
      builder.modifyIndex(json.modifyIndex);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.rules != null) {
      builder.rules(json.rules);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AclResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AclResponse instance
   */
  public static ImmutableAclResponse copyOf(AclResponse instance) {
    if (instance instanceof ImmutableAclResponse) {
      return (ImmutableAclResponse) instance;
    }
    return ImmutableAclResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAclResponse ImmutableAclResponse}.
   * <pre>
   * ImmutableAclResponse.builder()
   *    .createIndex(java.math.BigInteger) // required {@link AclResponse#createIndex() createIndex}
   *    .modifyIndex(java.math.BigInteger) // required {@link AclResponse#modifyIndex() modifyIndex}
   *    .id(String) // optional {@link AclResponse#id() id}
   *    .name(String) // optional {@link AclResponse#name() name}
   *    .type(String) // optional {@link AclResponse#type() type}
   *    .rules(String) // optional {@link AclResponse#rules() rules}
   *    .build();
   * </pre>
   * @return A new ImmutableAclResponse builder
   */
  public static ImmutableAclResponse.Builder builder() {
    return new ImmutableAclResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAclResponse ImmutableAclResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AclResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATE_INDEX = 0x1L;
    private static final long INIT_BIT_MODIFY_INDEX = 0x2L;
    private long initBits = 0x3L;

    private @Nullable BigInteger createIndex;
    private @Nullable BigInteger modifyIndex;
    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String type;
    private @Nullable String rules;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AclResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AclResponse instance) {
      Objects.requireNonNull(instance, "instance");
      createIndex(instance.createIndex());
      modifyIndex(instance.modifyIndex());
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> nameOptional = instance.name();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      Optional<String> typeOptional = instance.type();
      if (typeOptional.isPresent()) {
        type(typeOptional);
      }
      Optional<String> rulesOptional = instance.rules();
      if (rulesOptional.isPresent()) {
        rules(rulesOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AclResponse#createIndex() createIndex} attribute.
     * @param createIndex The value for createIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CreateIndex")
    public final Builder createIndex(BigInteger createIndex) {
      this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
      initBits &= ~INIT_BIT_CREATE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link AclResponse#modifyIndex() modifyIndex} attribute.
     * @param modifyIndex The value for modifyIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ModifyIndex")
    public final Builder modifyIndex(BigInteger modifyIndex) {
      this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
      initBits &= ~INIT_BIT_MODIFY_INDEX;
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#name() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Type")
    public final Builder type(Optional<String> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rules(String rules) {
      this.rules = Objects.requireNonNull(rules, "rules");
      return this;
    }

    /**
     * Initializes the optional value {@link AclResponse#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Rules")
    public final Builder rules(Optional<String> rules) {
      this.rules = rules.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAclResponse ImmutableAclResponse}.
     * @return An immutable instance of AclResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAclResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAclResponse(createIndex, modifyIndex, id, name, type, rules);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATE_INDEX) != 0) attributes.add("createIndex");
      if ((initBits & INIT_BIT_MODIFY_INDEX) != 0) attributes.add("modifyIndex");
      return "Cannot build AclResponse, some of required attributes are not set " + attributes;
    }
  }
}
