package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CatalogNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogNode.builder()}.
 */
@Generated(from = "CatalogNode", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogNode extends CatalogNode {
  private final Node node;
  private final ImmutableMap<String, Service> services;

  private ImmutableCatalogNode(
      Node node,
      ImmutableMap<String, Service> services) {
    this.node = node;
    this.services = services;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Node getNode() {
    return node;
  }

  /**
   * @return The value of the {@code services} attribute
   */
  @JsonProperty("Services")
  @Override
  public ImmutableMap<String, Service> getServices() {
    return services;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogNode#getNode() node} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogNode withNode(Node value) {
    if (this.node == value) return this;
    Node newValue = Objects.requireNonNull(value, "node");
    return new ImmutableCatalogNode(newValue, this.services);
  }

  /**
   * Copy the current immutable object by replacing the {@link CatalogNode#getServices() services} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the services map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogNode withServices(Map<String, ? extends Service> entries) {
    if (this.services == entries) return this;
    ImmutableMap<String, Service> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCatalogNode(this.node, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogNode
        && equalTo((ImmutableCatalogNode) another);
  }

  private boolean equalTo(ImmutableCatalogNode another) {
    return node.equals(another.node)
        && services.equals(another.services);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code services}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + services.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogNode")
        .omitNullValues()
        .add("node", node)
        .add("services", services)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CatalogNode", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends CatalogNode {
    @Nullable Node node;
    @Nullable Map<String, Service> services = ImmutableMap.of();
    @JsonProperty("Node")
    public void setNode(Node node) {
      this.node = node;
    }
    @JsonProperty("Services")
    public void setServices(Map<String, Service> services) {
      this.services = services;
    }
    @Override
    public Node getNode() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Service> getServices() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCatalogNode fromJson(Json json) {
    ImmutableCatalogNode.Builder builder = ImmutableCatalogNode.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.services != null) {
      builder.putAllServices(json.services);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogNode instance
   */
  public static ImmutableCatalogNode copyOf(CatalogNode instance) {
    if (instance instanceof ImmutableCatalogNode) {
      return (ImmutableCatalogNode) instance;
    }
    return ImmutableCatalogNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogNode ImmutableCatalogNode}.
   * <pre>
   * ImmutableCatalogNode.builder()
   *    .node(com.orbitz.consul.model.health.Node) // required {@link CatalogNode#getNode() node}
   *    .putServices|putAllServices(String =&gt; com.orbitz.consul.model.health.Service) // {@link CatalogNode#getServices() services} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCatalogNode builder
   */
  public static ImmutableCatalogNode.Builder builder() {
    return new ImmutableCatalogNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogNode ImmutableCatalogNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CatalogNode", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Node node;
    private ImmutableMap.Builder<String, Service> services = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogNode} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CatalogNode instance) {
      Objects.requireNonNull(instance, "instance");
      node(instance.getNode());
      putAllServices(instance.getServices());
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogNode#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(Node node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Put one entry to the {@link CatalogNode#getServices() services} map.
     * @param key The key in the services map
     * @param value The associated value in the services map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putServices(String key, Service value) {
      this.services.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putServices(Map.Entry<String, ? extends Service> entry) {
      this.services.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entries The entries that will be added to the services map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Services")
    public final Builder services(Map<String, ? extends Service> entries) {
      this.services = ImmutableMap.builder();
      return putAllServices(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entries The entries that will be added to the services map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllServices(Map<String, ? extends Service> entries) {
      this.services.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogNode ImmutableCatalogNode}.
     * @return An immutable instance of CatalogNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogNode(node, services.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      return "Cannot build CatalogNode, some of required attributes are not set " + attributes;
    }
  }
}
