package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TxError}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTxError.builder()}.
 */
@Generated(from = "TxError", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTxError extends TxError {
  private final @Nullable BigInteger opIndex;
  private final @Nullable String what;

  private ImmutableTxError(
      @Nullable BigInteger opIndex,
      @Nullable String what) {
    this.opIndex = opIndex;
    this.what = what;
  }

  /**
   * @return The value of the {@code opIndex} attribute
   */
  @JsonProperty("OpIndex")
  @Override
  public Optional<BigInteger> opIndex() {
    return Optional.ofNullable(opIndex);
  }

  /**
   * @return The value of the {@code what} attribute
   */
  @JsonProperty("What")
  @Override
  public Optional<String> what() {
    return Optional.ofNullable(what);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TxError#opIndex() opIndex} attribute.
   * @param value The value for opIndex
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxError withOpIndex(BigInteger value) {
    @Nullable BigInteger newValue = Objects.requireNonNull(value, "opIndex");
    if (Objects.equals(this.opIndex, newValue)) return this;
    return new ImmutableTxError(newValue, this.what);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TxError#opIndex() opIndex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opIndex
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableTxError withOpIndex(Optional<? extends BigInteger> optional) {
    @Nullable BigInteger value = optional.orElse(null);
    if (Objects.equals(this.opIndex, value)) return this;
    return new ImmutableTxError(value, this.what);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TxError#what() what} attribute.
   * @param value The value for what
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxError withWhat(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "what");
    if (Objects.equals(this.what, newValue)) return this;
    return new ImmutableTxError(this.opIndex, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TxError#what() what} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for what
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxError withWhat(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.what, value)) return this;
    return new ImmutableTxError(this.opIndex, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTxError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTxError
        && equalTo((ImmutableTxError) another);
  }

  private boolean equalTo(ImmutableTxError another) {
    return Objects.equals(opIndex, another.opIndex)
        && Objects.equals(what, another.what);
  }

  /**
   * Computes a hash code from attributes: {@code opIndex}, {@code what}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(opIndex);
    h += (h << 5) + Objects.hashCode(what);
    return h;
  }

  /**
   * Prints the immutable value {@code TxError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TxError")
        .omitNullValues()
        .add("opIndex", opIndex)
        .add("what", what)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TxError", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TxError {
    @Nullable Optional<BigInteger> opIndex = Optional.empty();
    @Nullable Optional<String> what = Optional.empty();
    @JsonProperty("OpIndex")
    public void setOpIndex(Optional<BigInteger> opIndex) {
      this.opIndex = opIndex;
    }
    @JsonProperty("What")
    public void setWhat(Optional<String> what) {
      this.what = what;
    }
    @Override
    public Optional<BigInteger> opIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> what() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTxError fromJson(Json json) {
    ImmutableTxError.Builder builder = ImmutableTxError.builder();
    if (json.opIndex != null) {
      builder.opIndex(json.opIndex);
    }
    if (json.what != null) {
      builder.what(json.what);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TxError} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TxError instance
   */
  public static ImmutableTxError copyOf(TxError instance) {
    if (instance instanceof ImmutableTxError) {
      return (ImmutableTxError) instance;
    }
    return ImmutableTxError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTxError ImmutableTxError}.
   * <pre>
   * ImmutableTxError.builder()
   *    .opIndex(java.math.BigInteger) // optional {@link TxError#opIndex() opIndex}
   *    .what(String) // optional {@link TxError#what() what}
   *    .build();
   * </pre>
   * @return A new ImmutableTxError builder
   */
  public static ImmutableTxError.Builder builder() {
    return new ImmutableTxError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTxError ImmutableTxError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TxError", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable BigInteger opIndex;
    private @Nullable String what;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TxError} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TxError instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<BigInteger> opIndexOptional = instance.opIndex();
      if (opIndexOptional.isPresent()) {
        opIndex(opIndexOptional);
      }
      Optional<String> whatOptional = instance.what();
      if (whatOptional.isPresent()) {
        what(whatOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link TxError#opIndex() opIndex} to opIndex.
     * @param opIndex The value for opIndex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opIndex(BigInteger opIndex) {
      this.opIndex = Objects.requireNonNull(opIndex, "opIndex");
      return this;
    }

    /**
     * Initializes the optional value {@link TxError#opIndex() opIndex} to opIndex.
     * @param opIndex The value for opIndex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("OpIndex")
    public final Builder opIndex(Optional<? extends BigInteger> opIndex) {
      this.opIndex = opIndex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TxError#what() what} to what.
     * @param what The value for what
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder what(String what) {
      this.what = Objects.requireNonNull(what, "what");
      return this;
    }

    /**
     * Initializes the optional value {@link TxError#what() what} to what.
     * @param what The value for what
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("What")
    public final Builder what(Optional<String> what) {
      this.what = what.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTxError ImmutableTxError}.
     * @return An immutable instance of TxError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTxError build() {
      return new ImmutableTxError(opIndex, what);
    }
  }
}
