package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Registration.RegCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRegCheck.builder()}.
 */
@Generated(from = "Registration.RegCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRegCheck extends Registration.RegCheck {
  private final @Nullable List<String> args;
  private final @Nullable String interval;
  private final @Nullable String ttl;
  private final @Nullable String http;
  private final @Nullable String tcp;
  private final @Nullable String grpc;
  private final @Nullable Boolean grpcUseTls;
  private final @Nullable String timeout;
  private final @Nullable String notes;
  private final @Nullable String deregisterCriticalServiceAfter;
  private final @Nullable Boolean tlsSkipVerify;
  private final @Nullable String status;
  private final @Nullable Integer successBeforePassing;
  private final @Nullable Integer failuresBeforeCritical;

  private ImmutableRegCheck(
      @Nullable List<String> args,
      @Nullable String interval,
      @Nullable String ttl,
      @Nullable String http,
      @Nullable String tcp,
      @Nullable String grpc,
      @Nullable Boolean grpcUseTls,
      @Nullable String timeout,
      @Nullable String notes,
      @Nullable String deregisterCriticalServiceAfter,
      @Nullable Boolean tlsSkipVerify,
      @Nullable String status,
      @Nullable Integer successBeforePassing,
      @Nullable Integer failuresBeforeCritical) {
    this.args = args;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.tcp = tcp;
    this.grpc = grpc;
    this.grpcUseTls = grpcUseTls;
    this.timeout = timeout;
    this.notes = notes;
    this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    this.tlsSkipVerify = tlsSkipVerify;
    this.status = status;
    this.successBeforePassing = successBeforePassing;
    this.failuresBeforeCritical = failuresBeforeCritical;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @JsonProperty("Args")
  @Override
  public Optional<List<String>> getArgs() {
    return Optional.ofNullable(args);
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @JsonProperty("Interval")
  @Override
  public Optional<String> getInterval() {
    return Optional.ofNullable(interval);
  }

  /**
   * @return The value of the {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public Optional<String> getTtl() {
    return Optional.ofNullable(ttl);
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty("HTTP")
  @Override
  public Optional<String> getHttp() {
    return Optional.ofNullable(http);
  }

  /**
   * @return The value of the {@code tcp} attribute
   */
  @JsonProperty("TCP")
  @Override
  public Optional<String> getTcp() {
    return Optional.ofNullable(tcp);
  }

  /**
   * @return The value of the {@code grpc} attribute
   */
  @JsonProperty("GRPC")
  @Override
  public Optional<String> getGrpc() {
    return Optional.ofNullable(grpc);
  }

  /**
   * @return The value of the {@code grpcUseTls} attribute
   */
  @JsonProperty("GRPCUseTLS")
  @Override
  public Optional<Boolean> getGrpcUseTls() {
    return Optional.ofNullable(grpcUseTls);
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @JsonProperty("Timeout")
  @Override
  public Optional<String> getTimeout() {
    return Optional.ofNullable(timeout);
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty("Notes")
  @Override
  public Optional<String> getNotes() {
    return Optional.ofNullable(notes);
  }

  /**
   * @return The value of the {@code deregisterCriticalServiceAfter} attribute
   */
  @JsonProperty("DeregisterCriticalServiceAfter")
  @Override
  public Optional<String> getDeregisterCriticalServiceAfter() {
    return Optional.ofNullable(deregisterCriticalServiceAfter);
  }

  /**
   * @return The value of the {@code tlsSkipVerify} attribute
   */
  @JsonProperty("TLSSkipVerify")
  @Override
  public Optional<Boolean> getTlsSkipVerify() {
    return Optional.ofNullable(tlsSkipVerify);
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public Optional<String> getStatus() {
    return Optional.ofNullable(status);
  }

  /**
   * @return The value of the {@code successBeforePassing} attribute
   */
  @JsonProperty("SuccessBeforePassing")
  @Override
  public Optional<Integer> getSuccessBeforePassing() {
    return Optional.ofNullable(successBeforePassing);
  }

  /**
   * @return The value of the {@code failuresBeforeCritical} attribute
   */
  @JsonProperty("FailuresBeforeCritical")
  @Override
  public Optional<Integer> getFailuresBeforeCritical() {
    return Optional.ofNullable(failuresBeforeCritical);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getArgs() args} attribute.
   * @param value The value for args
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withArgs(List<String> value) {
    @Nullable List<String> newValue = Objects.requireNonNull(value, "args");
    if (this.args == newValue) return this;
    return validate(new ImmutableRegCheck(
        newValue,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getArgs() args} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for args
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRegCheck withArgs(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.args == value) return this;
    return validate(new ImmutableRegCheck(
        value,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getInterval() interval} attribute.
   * @param value The value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "interval");
    if (Objects.equals(this.interval, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        newValue,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getInterval() interval} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for interval
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.interval, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        value,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTtl() ttl} attribute.
   * @param value The value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "ttl");
    if (Objects.equals(this.ttl, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        newValue,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTtl() ttl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ttl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.ttl, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        value,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getHttp() http} attribute.
   * @param value The value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "http");
    if (Objects.equals(this.http, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        newValue,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getHttp() http} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for http
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.http, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        value,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTcp() tcp} attribute.
   * @param value The value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTcp(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "tcp");
    if (Objects.equals(this.tcp, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        newValue,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTcp() tcp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tcp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTcp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tcp, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        value,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getGrpc() grpc} attribute.
   * @param value The value for grpc
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withGrpc(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "grpc");
    if (Objects.equals(this.grpc, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        newValue,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getGrpc() grpc} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for grpc
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withGrpc(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.grpc, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        value,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getGrpcUseTls() grpcUseTls} attribute.
   * @param value The value for grpcUseTls
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withGrpcUseTls(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.grpcUseTls, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        newValue,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getGrpcUseTls() grpcUseTls} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for grpcUseTls
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withGrpcUseTls(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.grpcUseTls, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        value,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTimeout() timeout} attribute.
   * @param value The value for timeout
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTimeout(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "timeout");
    if (Objects.equals(this.timeout, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        newValue,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTimeout() timeout} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timeout
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTimeout(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.timeout, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        value,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withNotes(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "notes");
    if (Objects.equals(this.notes, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        newValue,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getNotes() notes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withNotes(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notes, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        value,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * @param value The value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withDeregisterCriticalServiceAfter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "deregisterCriticalServiceAfter");
    if (Objects.equals(this.deregisterCriticalServiceAfter, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        newValue,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deregisterCriticalServiceAfter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.deregisterCriticalServiceAfter, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        value,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getTlsSkipVerify() tlsSkipVerify} attribute.
   * @param value The value for tlsSkipVerify
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTlsSkipVerify(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.tlsSkipVerify, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        newValue,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getTlsSkipVerify() tlsSkipVerify} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tlsSkipVerify
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTlsSkipVerify(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.tlsSkipVerify, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        value,
        this.status,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getStatus() status} attribute.
   * @param value The value for status
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withStatus(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "status");
    if (Objects.equals(this.status, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        newValue,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getStatus() status} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for status
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withStatus(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.status, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        value,
        this.successBeforePassing,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getSuccessBeforePassing() successBeforePassing} attribute.
   * @param value The value for successBeforePassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withSuccessBeforePassing(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.successBeforePassing, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        newValue,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getSuccessBeforePassing() successBeforePassing} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for successBeforePassing
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withSuccessBeforePassing(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.successBeforePassing, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        value,
        this.failuresBeforeCritical));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Registration.RegCheck#getFailuresBeforeCritical() failuresBeforeCritical} attribute.
   * @param value The value for failuresBeforeCritical
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withFailuresBeforeCritical(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.failuresBeforeCritical, newValue)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Registration.RegCheck#getFailuresBeforeCritical() failuresBeforeCritical} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for failuresBeforeCritical
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRegCheck withFailuresBeforeCritical(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.failuresBeforeCritical, value)) return this;
    return validate(new ImmutableRegCheck(
        this.args,
        this.interval,
        this.ttl,
        this.http,
        this.tcp,
        this.grpc,
        this.grpcUseTls,
        this.timeout,
        this.notes,
        this.deregisterCriticalServiceAfter,
        this.tlsSkipVerify,
        this.status,
        this.successBeforePassing,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRegCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRegCheck
        && equalTo((ImmutableRegCheck) another);
  }

  private boolean equalTo(ImmutableRegCheck another) {
    return Objects.equals(args, another.args)
        && Objects.equals(interval, another.interval)
        && Objects.equals(ttl, another.ttl)
        && Objects.equals(http, another.http)
        && Objects.equals(tcp, another.tcp)
        && Objects.equals(grpc, another.grpc)
        && Objects.equals(grpcUseTls, another.grpcUseTls)
        && Objects.equals(timeout, another.timeout)
        && Objects.equals(notes, another.notes)
        && Objects.equals(deregisterCriticalServiceAfter, another.deregisterCriticalServiceAfter)
        && Objects.equals(tlsSkipVerify, another.tlsSkipVerify)
        && Objects.equals(status, another.status)
        && Objects.equals(successBeforePassing, another.successBeforePassing)
        && Objects.equals(failuresBeforeCritical, another.failuresBeforeCritical);
  }

  /**
   * Computes a hash code from attributes: {@code args}, {@code interval}, {@code ttl}, {@code http}, {@code tcp}, {@code grpc}, {@code grpcUseTls}, {@code timeout}, {@code notes}, {@code deregisterCriticalServiceAfter}, {@code tlsSkipVerify}, {@code status}, {@code successBeforePassing}, {@code failuresBeforeCritical}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(args);
    h += (h << 5) + Objects.hashCode(interval);
    h += (h << 5) + Objects.hashCode(ttl);
    h += (h << 5) + Objects.hashCode(http);
    h += (h << 5) + Objects.hashCode(tcp);
    h += (h << 5) + Objects.hashCode(grpc);
    h += (h << 5) + Objects.hashCode(grpcUseTls);
    h += (h << 5) + Objects.hashCode(timeout);
    h += (h << 5) + Objects.hashCode(notes);
    h += (h << 5) + Objects.hashCode(deregisterCriticalServiceAfter);
    h += (h << 5) + Objects.hashCode(tlsSkipVerify);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(successBeforePassing);
    h += (h << 5) + Objects.hashCode(failuresBeforeCritical);
    return h;
  }

  /**
   * Prints the immutable value {@code RegCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RegCheck")
        .omitNullValues()
        .add("args", args)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .add("tcp", tcp)
        .add("grpc", grpc)
        .add("grpcUseTls", grpcUseTls)
        .add("timeout", timeout)
        .add("notes", notes)
        .add("deregisterCriticalServiceAfter", deregisterCriticalServiceAfter)
        .add("tlsSkipVerify", tlsSkipVerify)
        .add("status", status)
        .add("successBeforePassing", successBeforePassing)
        .add("failuresBeforeCritical", failuresBeforeCritical)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Registration.RegCheck", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Registration.RegCheck {
    @Nullable Optional<List<String>> args = Optional.empty();
    @Nullable Optional<String> interval = Optional.empty();
    @Nullable Optional<String> ttl = Optional.empty();
    @Nullable Optional<String> http = Optional.empty();
    @Nullable Optional<String> tcp = Optional.empty();
    @Nullable Optional<String> grpc = Optional.empty();
    @Nullable Optional<Boolean> grpcUseTls = Optional.empty();
    @Nullable Optional<String> timeout = Optional.empty();
    @Nullable Optional<String> notes = Optional.empty();
    @Nullable Optional<String> deregisterCriticalServiceAfter = Optional.empty();
    @Nullable Optional<Boolean> tlsSkipVerify = Optional.empty();
    @Nullable Optional<String> status = Optional.empty();
    @Nullable Optional<Integer> successBeforePassing = Optional.empty();
    @Nullable Optional<Integer> failuresBeforeCritical = Optional.empty();
    @JsonProperty("Args")
    public void setArgs(Optional<List<String>> args) {
      this.args = args;
    }
    @JsonProperty("Interval")
    public void setInterval(Optional<String> interval) {
      this.interval = interval;
    }
    @JsonProperty("TTL")
    public void setTtl(Optional<String> ttl) {
      this.ttl = ttl;
    }
    @JsonProperty("HTTP")
    public void setHttp(Optional<String> http) {
      this.http = http;
    }
    @JsonProperty("TCP")
    public void setTcp(Optional<String> tcp) {
      this.tcp = tcp;
    }
    @JsonProperty("GRPC")
    public void setGrpc(Optional<String> grpc) {
      this.grpc = grpc;
    }
    @JsonProperty("GRPCUseTLS")
    public void setGrpcUseTls(Optional<Boolean> grpcUseTls) {
      this.grpcUseTls = grpcUseTls;
    }
    @JsonProperty("Timeout")
    public void setTimeout(Optional<String> timeout) {
      this.timeout = timeout;
    }
    @JsonProperty("Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty("DeregisterCriticalServiceAfter")
    public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }
    @JsonProperty("TLSSkipVerify")
    public void setTlsSkipVerify(Optional<Boolean> tlsSkipVerify) {
      this.tlsSkipVerify = tlsSkipVerify;
    }
    @JsonProperty("Status")
    public void setStatus(Optional<String> status) {
      this.status = status;
    }
    @JsonProperty("SuccessBeforePassing")
    public void setSuccessBeforePassing(Optional<Integer> successBeforePassing) {
      this.successBeforePassing = successBeforePassing;
    }
    @JsonProperty("FailuresBeforeCritical")
    public void setFailuresBeforeCritical(Optional<Integer> failuresBeforeCritical) {
      this.failuresBeforeCritical = failuresBeforeCritical;
    }
    @Override
    public Optional<List<String>> getArgs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInterval() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHttp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTcp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getGrpc() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getGrpcUseTls() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTimeout() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDeregisterCriticalServiceAfter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getTlsSkipVerify() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getSuccessBeforePassing() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getFailuresBeforeCritical() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRegCheck fromJson(Json json) {
    ImmutableRegCheck.Builder builder = ImmutableRegCheck.builder();
    if (json.args != null) {
      builder.args(json.args);
    }
    if (json.interval != null) {
      builder.interval(json.interval);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.http != null) {
      builder.http(json.http);
    }
    if (json.tcp != null) {
      builder.tcp(json.tcp);
    }
    if (json.grpc != null) {
      builder.grpc(json.grpc);
    }
    if (json.grpcUseTls != null) {
      builder.grpcUseTls(json.grpcUseTls);
    }
    if (json.timeout != null) {
      builder.timeout(json.timeout);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.deregisterCriticalServiceAfter != null) {
      builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
    }
    if (json.tlsSkipVerify != null) {
      builder.tlsSkipVerify(json.tlsSkipVerify);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.successBeforePassing != null) {
      builder.successBeforePassing(json.successBeforePassing);
    }
    if (json.failuresBeforeCritical != null) {
      builder.failuresBeforeCritical(json.failuresBeforeCritical);
    }
    return builder.build();
  }

  private static ImmutableRegCheck validate(ImmutableRegCheck instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Registration.RegCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RegCheck instance
   */
  public static ImmutableRegCheck copyOf(Registration.RegCheck instance) {
    if (instance instanceof ImmutableRegCheck) {
      return (ImmutableRegCheck) instance;
    }
    return ImmutableRegCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRegCheck ImmutableRegCheck}.
   * <pre>
   * ImmutableRegCheck.builder()
   *    .args(List&amp;lt;String&amp;gt;) // optional {@link Registration.RegCheck#getArgs() args}
   *    .interval(String) // optional {@link Registration.RegCheck#getInterval() interval}
   *    .ttl(String) // optional {@link Registration.RegCheck#getTtl() ttl}
   *    .http(String) // optional {@link Registration.RegCheck#getHttp() http}
   *    .tcp(String) // optional {@link Registration.RegCheck#getTcp() tcp}
   *    .grpc(String) // optional {@link Registration.RegCheck#getGrpc() grpc}
   *    .grpcUseTls(Boolean) // optional {@link Registration.RegCheck#getGrpcUseTls() grpcUseTls}
   *    .timeout(String) // optional {@link Registration.RegCheck#getTimeout() timeout}
   *    .notes(String) // optional {@link Registration.RegCheck#getNotes() notes}
   *    .deregisterCriticalServiceAfter(String) // optional {@link Registration.RegCheck#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter}
   *    .tlsSkipVerify(Boolean) // optional {@link Registration.RegCheck#getTlsSkipVerify() tlsSkipVerify}
   *    .status(String) // optional {@link Registration.RegCheck#getStatus() status}
   *    .successBeforePassing(Integer) // optional {@link Registration.RegCheck#getSuccessBeforePassing() successBeforePassing}
   *    .failuresBeforeCritical(Integer) // optional {@link Registration.RegCheck#getFailuresBeforeCritical() failuresBeforeCritical}
   *    .build();
   * </pre>
   * @return A new ImmutableRegCheck builder
   */
  public static ImmutableRegCheck.Builder builder() {
    return new ImmutableRegCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRegCheck ImmutableRegCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Registration.RegCheck", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable List<String> args;
    private @Nullable String interval;
    private @Nullable String ttl;
    private @Nullable String http;
    private @Nullable String tcp;
    private @Nullable String grpc;
    private @Nullable Boolean grpcUseTls;
    private @Nullable String timeout;
    private @Nullable String notes;
    private @Nullable String deregisterCriticalServiceAfter;
    private @Nullable Boolean tlsSkipVerify;
    private @Nullable String status;
    private @Nullable Integer successBeforePassing;
    private @Nullable Integer failuresBeforeCritical;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RegCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Registration.RegCheck instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<List<String>> argsOptional = instance.getArgs();
      if (argsOptional.isPresent()) {
        args(argsOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> tcpOptional = instance.getTcp();
      if (tcpOptional.isPresent()) {
        tcp(tcpOptional);
      }
      Optional<String> grpcOptional = instance.getGrpc();
      if (grpcOptional.isPresent()) {
        grpc(grpcOptional);
      }
      Optional<Boolean> grpcUseTlsOptional = instance.getGrpcUseTls();
      if (grpcUseTlsOptional.isPresent()) {
        grpcUseTls(grpcUseTlsOptional);
      }
      Optional<String> timeoutOptional = instance.getTimeout();
      if (timeoutOptional.isPresent()) {
        timeout(timeoutOptional);
      }
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
      if (deregisterCriticalServiceAfterOptional.isPresent()) {
        deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
      }
      Optional<Boolean> tlsSkipVerifyOptional = instance.getTlsSkipVerify();
      if (tlsSkipVerifyOptional.isPresent()) {
        tlsSkipVerify(tlsSkipVerifyOptional);
      }
      Optional<String> statusOptional = instance.getStatus();
      if (statusOptional.isPresent()) {
        status(statusOptional);
      }
      Optional<Integer> successBeforePassingOptional = instance.getSuccessBeforePassing();
      if (successBeforePassingOptional.isPresent()) {
        successBeforePassing(successBeforePassingOptional);
      }
      Optional<Integer> failuresBeforeCriticalOptional = instance.getFailuresBeforeCritical();
      if (failuresBeforeCriticalOptional.isPresent()) {
        failuresBeforeCritical(failuresBeforeCriticalOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(List<String> args) {
      this.args = Objects.requireNonNull(args, "args");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Args")
    public final Builder args(Optional<? extends List<String>> args) {
      this.args = args.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder interval(String interval) {
      this.interval = Objects.requireNonNull(interval, "interval");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getInterval() interval} to interval.
     * @param interval The value for interval
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Interval")
    public final Builder interval(Optional<String> interval) {
      this.interval = interval.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ttl(String ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTtl() ttl} to ttl.
     * @param ttl The value for ttl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TTL")
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = ttl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder http(String http) {
      this.http = Objects.requireNonNull(http, "http");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getHttp() http} to http.
     * @param http The value for http
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("HTTP")
    public final Builder http(Optional<String> http) {
      this.http = http.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tcp(String tcp) {
      this.tcp = Objects.requireNonNull(tcp, "tcp");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTcp() tcp} to tcp.
     * @param tcp The value for tcp
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TCP")
    public final Builder tcp(Optional<String> tcp) {
      this.tcp = tcp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getGrpc() grpc} to grpc.
     * @param grpc The value for grpc
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder grpc(String grpc) {
      this.grpc = Objects.requireNonNull(grpc, "grpc");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getGrpc() grpc} to grpc.
     * @param grpc The value for grpc
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("GRPC")
    public final Builder grpc(Optional<String> grpc) {
      this.grpc = grpc.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getGrpcUseTls() grpcUseTls} to grpcUseTls.
     * @param grpcUseTls The value for grpcUseTls
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder grpcUseTls(boolean grpcUseTls) {
      this.grpcUseTls = grpcUseTls;
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getGrpcUseTls() grpcUseTls} to grpcUseTls.
     * @param grpcUseTls The value for grpcUseTls
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("GRPCUseTLS")
    public final Builder grpcUseTls(Optional<Boolean> grpcUseTls) {
      this.grpcUseTls = grpcUseTls.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTimeout() timeout} to timeout.
     * @param timeout The value for timeout
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder timeout(String timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTimeout() timeout} to timeout.
     * @param timeout The value for timeout
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Timeout")
    public final Builder timeout(Optional<String> timeout) {
      this.timeout = timeout.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder notes(String notes) {
      this.notes = Objects.requireNonNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Notes")
    public final Builder notes(Optional<String> notes) {
      this.notes = notes.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = Objects.requireNonNull(deregisterCriticalServiceAfter, "deregisterCriticalServiceAfter");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getDeregisterCriticalServiceAfter() deregisterCriticalServiceAfter} to deregisterCriticalServiceAfter.
     * @param deregisterCriticalServiceAfter The value for deregisterCriticalServiceAfter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DeregisterCriticalServiceAfter")
    public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
      this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTlsSkipVerify() tlsSkipVerify} to tlsSkipVerify.
     * @param tlsSkipVerify The value for tlsSkipVerify
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tlsSkipVerify(boolean tlsSkipVerify) {
      this.tlsSkipVerify = tlsSkipVerify;
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getTlsSkipVerify() tlsSkipVerify} to tlsSkipVerify.
     * @param tlsSkipVerify The value for tlsSkipVerify
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TLSSkipVerify")
    public final Builder tlsSkipVerify(Optional<Boolean> tlsSkipVerify) {
      this.tlsSkipVerify = tlsSkipVerify.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getStatus() status} to status.
     * @param status The value for status
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(String status) {
      this.status = Objects.requireNonNull(status, "status");
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getStatus() status} to status.
     * @param status The value for status
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Status")
    public final Builder status(Optional<String> status) {
      this.status = status.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getSuccessBeforePassing() successBeforePassing} to successBeforePassing.
     * @param successBeforePassing The value for successBeforePassing
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder successBeforePassing(int successBeforePassing) {
      this.successBeforePassing = successBeforePassing;
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getSuccessBeforePassing() successBeforePassing} to successBeforePassing.
     * @param successBeforePassing The value for successBeforePassing
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("SuccessBeforePassing")
    public final Builder successBeforePassing(Optional<Integer> successBeforePassing) {
      this.successBeforePassing = successBeforePassing.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getFailuresBeforeCritical() failuresBeforeCritical} to failuresBeforeCritical.
     * @param failuresBeforeCritical The value for failuresBeforeCritical
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder failuresBeforeCritical(int failuresBeforeCritical) {
      this.failuresBeforeCritical = failuresBeforeCritical;
      return this;
    }

    /**
     * Initializes the optional value {@link Registration.RegCheck#getFailuresBeforeCritical() failuresBeforeCritical} to failuresBeforeCritical.
     * @param failuresBeforeCritical The value for failuresBeforeCritical
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("FailuresBeforeCritical")
    public final Builder failuresBeforeCritical(Optional<Integer> failuresBeforeCritical) {
      this.failuresBeforeCritical = failuresBeforeCritical.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRegCheck ImmutableRegCheck}.
     * @return An immutable instance of RegCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRegCheck build() {
      return ImmutableRegCheck.validate(new ImmutableRegCheck(
          args,
          interval,
          ttl,
          http,
          tcp,
          grpc,
          grpcUseTls,
          timeout,
          notes,
          deregisterCriticalServiceAfter,
          tlsSkipVerify,
          status,
          successBeforePassing,
          failuresBeforeCritical));
    }
  }
}
