package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.orbitz.consul.model.health.ServiceHealth;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QueryResults}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryResults.builder()}.
 */
@Generated(from = "QueryResults", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableQueryResults extends QueryResults {
  private final String service;
  private final ImmutableList<ServiceHealth> nodes;

  private ImmutableQueryResults(
      String service,
      ImmutableList<ServiceHealth> nodes) {
    this.service = service;
    this.nodes = nodes;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public String service() {
    return service;
  }

  /**
   * @return The value of the {@code nodes} attribute
   */
  @JsonProperty("Nodes")
  @Override
  public ImmutableList<ServiceHealth> nodes() {
    return nodes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResults#service() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResults withService(String value) {
    String newValue = Objects.requireNonNull(value, "service");
    if (this.service.equals(newValue)) return this;
    return new ImmutableQueryResults(newValue, this.nodes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResults#nodes() nodes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResults withNodes(ServiceHealth... elements) {
    ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResults(this.service, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResults#nodes() nodes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResults withNodes(Iterable<? extends ServiceHealth> elements) {
    if (this.nodes == elements) return this;
    ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResults(this.service, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryResults} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryResults
        && equalTo((ImmutableQueryResults) another);
  }

  private boolean equalTo(ImmutableQueryResults another) {
    return service.equals(another.service)
        && nodes.equals(another.nodes);
  }

  /**
   * Computes a hash code from attributes: {@code service}, {@code nodes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + service.hashCode();
    h += (h << 5) + nodes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryResults} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryResults")
        .omitNullValues()
        .add("service", service)
        .add("nodes", nodes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "QueryResults", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends QueryResults {
    @Nullable String service;
    @Nullable List<ServiceHealth> nodes = ImmutableList.of();
    @JsonProperty("Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty("Nodes")
    public void setNodes(List<ServiceHealth> nodes) {
      this.nodes = nodes;
    }
    @Override
    public String service() { throw new UnsupportedOperationException(); }
    @Override
    public List<ServiceHealth> nodes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQueryResults fromJson(Json json) {
    ImmutableQueryResults.Builder builder = ImmutableQueryResults.builder();
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.nodes != null) {
      builder.addAllNodes(json.nodes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QueryResults} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryResults instance
   */
  public static ImmutableQueryResults copyOf(QueryResults instance) {
    if (instance instanceof ImmutableQueryResults) {
      return (ImmutableQueryResults) instance;
    }
    return ImmutableQueryResults.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryResults ImmutableQueryResults}.
   * <pre>
   * ImmutableQueryResults.builder()
   *    .service(String) // required {@link QueryResults#service() service}
   *    .addNodes|addAllNodes(com.orbitz.consul.model.health.ServiceHealth) // {@link QueryResults#nodes() nodes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableQueryResults builder
   */
  public static ImmutableQueryResults.Builder builder() {
    return new ImmutableQueryResults.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryResults ImmutableQueryResults}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QueryResults", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SERVICE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String service;
    private ImmutableList.Builder<ServiceHealth> nodes = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryResults} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QueryResults instance) {
      Objects.requireNonNull(instance, "instance");
      service(instance.service());
      addAllNodes(instance.nodes());
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResults#service() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(String service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link QueryResults#nodes() nodes} list.
     * @param element A nodes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodes(ServiceHealth element) {
      this.nodes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryResults#nodes() nodes} list.
     * @param elements An array of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodes(ServiceHealth... elements) {
      this.nodes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link QueryResults#nodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Nodes")
    public final Builder nodes(Iterable<? extends ServiceHealth> elements) {
      this.nodes = ImmutableList.builder();
      return addAllNodes(elements);
    }

    /**
     * Adds elements to {@link QueryResults#nodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNodes(Iterable<? extends ServiceHealth> elements) {
      this.nodes.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryResults ImmutableQueryResults}.
     * @return An immutable instance of QueryResults
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryResults build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryResults(service, nodes.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build QueryResults, some of required attributes are not set " + attributes;
    }
  }
}
