/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.BaseClient;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.acl.AclResponse;
import com.orbitz.consul.model.acl.AclToken;
import com.orbitz.consul.model.acl.AclTokenId;
import com.orbitz.consul.model.acl.Policy;
import com.orbitz.consul.model.acl.PolicyResponse;
import com.orbitz.consul.model.acl.Token;
import com.orbitz.consul.model.acl.TokenListResponse;
import com.orbitz.consul.model.acl.TokenResponse;
import com.orbitz.consul.monitoring.ClientEventCallback;
import java.util.List;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public class AclClient
extends BaseClient {
    private static String CLIENT_NAME = "acl";
    private final Api api;

    AclClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public String createAcl(AclToken aclToken) {
        return this.http.extract(this.api.createAcl(aclToken), new Integer[0]).id();
    }

    public void updateAcl(AclToken aclToken) {
        this.http.handle(this.api.updateAcl(aclToken), new Integer[0]);
    }

    public void destroyAcl(String id) {
        this.http.handle(this.api.destroyAcl(id), new Integer[0]);
    }

    public List<AclResponse> getAclInfo(String id) {
        return this.http.extract(this.api.getAclInfo(id), new Integer[0]);
    }

    public String cloneAcl(String id) {
        return this.http.extract(this.api.cloneAcl(id), new Integer[0]).id();
    }

    public List<AclResponse> listAcls() {
        return this.http.extract(this.api.listAcls(), new Integer[0]);
    }

    public PolicyResponse createPolicy(Policy policy) {
        return this.http.extract(this.api.createPolicy(policy), new Integer[0]);
    }

    public PolicyResponse readPolicy(String id) {
        return this.http.extract(this.api.readPolicy(id), new Integer[0]);
    }

    public PolicyResponse updatePolicy(String id, Policy policy) {
        return this.http.extract(this.api.updatePolicy(id, policy), new Integer[0]);
    }

    public void deletePolicy(String id) {
        this.http.extract(this.api.deletePolicy(id), new Integer[0]);
    }

    public List<PolicyResponse> listPolicies() {
        return this.http.extract(this.api.listPolicies(), new Integer[0]);
    }

    public TokenResponse createToken(Token token) {
        return this.http.extract(this.api.createToken(token), new Integer[0]);
    }

    public TokenResponse readToken(String id) {
        return this.http.extract(this.api.readToken(id), new Integer[0]);
    }

    public TokenResponse readSelfToken() {
        return this.http.extract(this.api.readToken("self"), new Integer[0]);
    }

    public TokenResponse updateToken(String id, Token token) {
        return this.http.extract(this.api.updateToken(id, token), new Integer[0]);
    }

    public List<TokenListResponse> listTokens() {
        return this.http.extract(this.api.listTokens(), new Integer[0]);
    }

    public void deleteToken(String id) {
        this.http.extract(this.api.deleteToken(id), new Integer[0]);
    }

    static interface Api {
        @PUT(value="acl/create")
        public Call<AclTokenId> createAcl(@Body AclToken var1);

        @PUT(value="acl/update")
        public Call<Void> updateAcl(@Body AclToken var1);

        @PUT(value="acl/destroy/{id}")
        public Call<Void> destroyAcl(@Path(value="id") String var1);

        @GET(value="acl/info/{id}")
        public Call<List<AclResponse>> getAclInfo(@Path(value="id") String var1);

        @PUT(value="acl/clone/{id}")
        public Call<AclTokenId> cloneAcl(@Path(value="id") String var1);

        @GET(value="acl/list")
        public Call<List<AclResponse>> listAcls();

        @PUT(value="acl/policy")
        public Call<PolicyResponse> createPolicy(@Body Policy var1);

        @GET(value="acl/policy/{id}")
        public Call<PolicyResponse> readPolicy(@Path(value="id") String var1);

        @PUT(value="acl/policy/{id}")
        public Call<PolicyResponse> updatePolicy(@Path(value="id") String var1, @Body Policy var2);

        @DELETE(value="acl/policy/{id}")
        public Call<Void> deletePolicy(@Path(value="id") String var1);

        @GET(value="acl/policies")
        public Call<List<PolicyResponse>> listPolicies();

        @PUT(value="acl/token")
        public Call<TokenResponse> createToken(@Body Token var1);

        @GET(value="acl/token/{id}")
        public Call<TokenResponse> readToken(@Path(value="id") String var1);

        @PUT(value="acl/token/{id}")
        public Call<TokenResponse> updateToken(@Path(value="id") String var1, @Body Token var2);

        @GET(value="acl/tokens")
        public Call<List<TokenListResponse>> listTokens();

        @DELETE(value="acl/token/{id}")
        public Call<Void> deleteToken(@Path(value="id") String var1);
    }
}

