package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransactionOptions.builder()}.
 */
@Generated(from = "TransactionOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransactionOptions extends TransactionOptions {
  private final @Nullable String datacenter;
  private final ConsistencyMode consistencyMode;

  private ImmutableTransactionOptions(ImmutableTransactionOptions.Builder builder) {
    this.datacenter = builder.datacenter;
    this.consistencyMode = builder.consistencyMode != null
        ? builder.consistencyMode
        : Objects.requireNonNull(super.getConsistencyMode(), "consistencyMode");
  }

  private ImmutableTransactionOptions(
      @Nullable String datacenter,
      ConsistencyMode consistencyMode) {
    this.datacenter = datacenter;
    this.consistencyMode = consistencyMode;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code consistencyMode} attribute
   */
  @Override
  public ConsistencyMode getConsistencyMode() {
    return consistencyMode;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TransactionOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransactionOptions withDatacenter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableTransactionOptions(newValue, this.consistencyMode);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TransactionOptions#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransactionOptions withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableTransactionOptions(value, this.consistencyMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionOptions#getConsistencyMode() consistencyMode} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionOptions withConsistencyMode(ConsistencyMode value) {
    if (this.consistencyMode == value) return this;
    ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
    return new ImmutableTransactionOptions(this.datacenter, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransactionOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransactionOptions
        && equalTo((ImmutableTransactionOptions) another);
  }

  private boolean equalTo(ImmutableTransactionOptions another) {
    return Objects.equals(datacenter, another.datacenter)
        && consistencyMode.equals(another.consistencyMode);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code consistencyMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + consistencyMode.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransactionOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionOptions")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("consistencyMode", consistencyMode)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransactionOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransactionOptions instance
   */
  public static ImmutableTransactionOptions copyOf(TransactionOptions instance) {
    if (instance instanceof ImmutableTransactionOptions) {
      return (ImmutableTransactionOptions) instance;
    }
    return ImmutableTransactionOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransactionOptions ImmutableTransactionOptions}.
   * <pre>
   * ImmutableTransactionOptions.builder()
   *    .datacenter(String) // optional {@link TransactionOptions#getDatacenter() datacenter}
   *    .consistencyMode(com.orbitz.consul.option.ConsistencyMode) // optional {@link TransactionOptions#getConsistencyMode() consistencyMode}
   *    .build();
   * </pre>
   * @return A new ImmutableTransactionOptions builder
   */
  public static ImmutableTransactionOptions.Builder builder() {
    return new ImmutableTransactionOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransactionOptions ImmutableTransactionOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionOptions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String datacenter;
    private @Nullable ConsistencyMode consistencyMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransactionOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransactionOptions instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      consistencyMode(instance.getConsistencyMode());
      return this;
    }

    /**
     * Initializes the optional value {@link TransactionOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link TransactionOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionOptions#getConsistencyMode() consistencyMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionOptions#getConsistencyMode() consistencyMode}.</em>
     * @param consistencyMode The value for consistencyMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder consistencyMode(ConsistencyMode consistencyMode) {
      this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransactionOptions ImmutableTransactionOptions}.
     * @return An immutable instance of TransactionOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransactionOptions build() {
      return new ImmutableTransactionOptions(this);
    }
  }
}
