package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceProxy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceProxy.builder()}.
 */
@Generated(from = "ServiceProxy", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceProxy extends ServiceProxy {
  private final String destinationServiceName;
  private final String destinationServiceId;
  private final String localServiceAddress;
  private final int localServicePort;
  private final ImmutableMap<String, String> config;
  private final ImmutableList<ServiceProxyUpstream> upstreams;

  private ImmutableServiceProxy(
      String destinationServiceName,
      String destinationServiceId,
      String localServiceAddress,
      int localServicePort,
      ImmutableMap<String, String> config,
      ImmutableList<ServiceProxyUpstream> upstreams) {
    this.destinationServiceName = destinationServiceName;
    this.destinationServiceId = destinationServiceId;
    this.localServiceAddress = localServiceAddress;
    this.localServicePort = localServicePort;
    this.config = config;
    this.upstreams = upstreams;
  }

  /**
   * @return The value of the {@code destinationServiceName} attribute
   */
  @JsonProperty("DestinationServiceName")
  @Override
  public String getDestinationServiceName() {
    return destinationServiceName;
  }

  /**
   * @return The value of the {@code destinationServiceId} attribute
   */
  @JsonProperty("DestinationServiceID")
  @Override
  public String getDestinationServiceId() {
    return destinationServiceId;
  }

  /**
   * @return The value of the {@code localServiceAddress} attribute
   */
  @JsonProperty("LocalServiceAddress")
  @Override
  public String getLocalServiceAddress() {
    return localServiceAddress;
  }

  /**
   * @return The value of the {@code localServicePort} attribute
   */
  @JsonProperty("LocalServicePort")
  @Override
  public int getLocalServicePort() {
    return localServicePort;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("Config")
  @Override
  public ImmutableMap<String, String> getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code upstreams} attribute
   */
  @JsonProperty("Upstreams")
  @JsonDeserialize(as = ImmutableList.class, contentAs = ServiceProxyUpstream.class)
  @Override
  public ImmutableList<ServiceProxyUpstream> getUpstreams() {
    return upstreams;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxy#getDestinationServiceName() destinationServiceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destinationServiceName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxy withDestinationServiceName(String value) {
    String newValue = Objects.requireNonNull(value, "destinationServiceName");
    if (this.destinationServiceName.equals(newValue)) return this;
    return new ImmutableServiceProxy(
        newValue,
        this.destinationServiceId,
        this.localServiceAddress,
        this.localServicePort,
        this.config,
        this.upstreams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxy#getDestinationServiceId() destinationServiceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destinationServiceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxy withDestinationServiceId(String value) {
    String newValue = Objects.requireNonNull(value, "destinationServiceId");
    if (this.destinationServiceId.equals(newValue)) return this;
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        newValue,
        this.localServiceAddress,
        this.localServicePort,
        this.config,
        this.upstreams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxy#getLocalServiceAddress() localServiceAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for localServiceAddress
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxy withLocalServiceAddress(String value) {
    String newValue = Objects.requireNonNull(value, "localServiceAddress");
    if (this.localServiceAddress.equals(newValue)) return this;
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        this.destinationServiceId,
        newValue,
        this.localServicePort,
        this.config,
        this.upstreams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceProxy#getLocalServicePort() localServicePort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for localServicePort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceProxy withLocalServicePort(int value) {
    if (this.localServicePort == value) return this;
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        this.destinationServiceId,
        this.localServiceAddress,
        value,
        this.config,
        this.upstreams);
  }

  /**
   * Copy the current immutable object by replacing the {@link ServiceProxy#getConfig() config} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the config map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceProxy withConfig(Map<String, ? extends String> entries) {
    if (this.config == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        this.destinationServiceId,
        this.localServiceAddress,
        this.localServicePort,
        newValue,
        this.upstreams);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ServiceProxy#getUpstreams() upstreams}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceProxy withUpstreams(ServiceProxyUpstream... elements) {
    ImmutableList<ServiceProxyUpstream> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        this.destinationServiceId,
        this.localServiceAddress,
        this.localServicePort,
        this.config,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ServiceProxy#getUpstreams() upstreams}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of upstreams elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServiceProxy withUpstreams(Iterable<? extends ServiceProxyUpstream> elements) {
    if (this.upstreams == elements) return this;
    ImmutableList<ServiceProxyUpstream> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceProxy(
        this.destinationServiceName,
        this.destinationServiceId,
        this.localServiceAddress,
        this.localServicePort,
        this.config,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceProxy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceProxy
        && equalTo((ImmutableServiceProxy) another);
  }

  private boolean equalTo(ImmutableServiceProxy another) {
    return destinationServiceName.equals(another.destinationServiceName)
        && destinationServiceId.equals(another.destinationServiceId)
        && localServiceAddress.equals(another.localServiceAddress)
        && localServicePort == another.localServicePort
        && config.equals(another.config)
        && upstreams.equals(another.upstreams);
  }

  /**
   * Computes a hash code from attributes: {@code destinationServiceName}, {@code destinationServiceId}, {@code localServiceAddress}, {@code localServicePort}, {@code config}, {@code upstreams}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destinationServiceName.hashCode();
    h += (h << 5) + destinationServiceId.hashCode();
    h += (h << 5) + localServiceAddress.hashCode();
    h += (h << 5) + localServicePort;
    h += (h << 5) + config.hashCode();
    h += (h << 5) + upstreams.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceProxy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceProxy")
        .omitNullValues()
        .add("destinationServiceName", destinationServiceName)
        .add("destinationServiceId", destinationServiceId)
        .add("localServiceAddress", localServiceAddress)
        .add("localServicePort", localServicePort)
        .add("config", config)
        .add("upstreams", upstreams)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ServiceProxy", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ServiceProxy {
    @Nullable String destinationServiceName;
    @Nullable String destinationServiceId;
    @Nullable String localServiceAddress;
    int localServicePort;
    boolean localServicePortIsSet;
    @Nullable Map<String, String> config = ImmutableMap.of();
    @Nullable List<ServiceProxyUpstream> upstreams = ImmutableList.of();
    @JsonProperty("DestinationServiceName")
    public void setDestinationServiceName(String destinationServiceName) {
      this.destinationServiceName = destinationServiceName;
    }
    @JsonProperty("DestinationServiceID")
    public void setDestinationServiceId(String destinationServiceId) {
      this.destinationServiceId = destinationServiceId;
    }
    @JsonProperty("LocalServiceAddress")
    public void setLocalServiceAddress(String localServiceAddress) {
      this.localServiceAddress = localServiceAddress;
    }
    @JsonProperty("LocalServicePort")
    public void setLocalServicePort(int localServicePort) {
      this.localServicePort = localServicePort;
      this.localServicePortIsSet = true;
    }
    @JsonProperty("Config")
    public void setConfig(Map<String, String> config) {
      this.config = config;
    }
    @JsonProperty("Upstreams")
    @JsonDeserialize(as = ImmutableList.class, contentAs = ServiceProxyUpstream.class)
    public void setUpstreams(List<ServiceProxyUpstream> upstreams) {
      this.upstreams = upstreams;
    }
    @Override
    public String getDestinationServiceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDestinationServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocalServiceAddress() { throw new UnsupportedOperationException(); }
    @Override
    public int getLocalServicePort() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getConfig() { throw new UnsupportedOperationException(); }
    @Override
    public List<ServiceProxyUpstream> getUpstreams() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServiceProxy fromJson(Json json) {
    ImmutableServiceProxy.Builder builder = ImmutableServiceProxy.builder();
    if (json.destinationServiceName != null) {
      builder.destinationServiceName(json.destinationServiceName);
    }
    if (json.destinationServiceId != null) {
      builder.destinationServiceId(json.destinationServiceId);
    }
    if (json.localServiceAddress != null) {
      builder.localServiceAddress(json.localServiceAddress);
    }
    if (json.localServicePortIsSet) {
      builder.localServicePort(json.localServicePort);
    }
    if (json.config != null) {
      builder.putAllConfig(json.config);
    }
    if (json.upstreams != null) {
      builder.addAllUpstreams(json.upstreams);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceProxy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceProxy instance
   */
  public static ImmutableServiceProxy copyOf(ServiceProxy instance) {
    if (instance instanceof ImmutableServiceProxy) {
      return (ImmutableServiceProxy) instance;
    }
    return ImmutableServiceProxy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceProxy ImmutableServiceProxy}.
   * <pre>
   * ImmutableServiceProxy.builder()
   *    .destinationServiceName(String) // required {@link ServiceProxy#getDestinationServiceName() destinationServiceName}
   *    .destinationServiceId(String) // required {@link ServiceProxy#getDestinationServiceId() destinationServiceId}
   *    .localServiceAddress(String) // required {@link ServiceProxy#getLocalServiceAddress() localServiceAddress}
   *    .localServicePort(int) // required {@link ServiceProxy#getLocalServicePort() localServicePort}
   *    .putConfig|putAllConfig(String =&gt; String) // {@link ServiceProxy#getConfig() config} mappings
   *    .addUpstreams|addAllUpstreams(com.orbitz.consul.model.agent.ServiceProxyUpstream) // {@link ServiceProxy#getUpstreams() upstreams} elements
   *    .build();
   * </pre>
   * @return A new ImmutableServiceProxy builder
   */
  public static ImmutableServiceProxy.Builder builder() {
    return new ImmutableServiceProxy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceProxy ImmutableServiceProxy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceProxy", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION_SERVICE_NAME = 0x1L;
    private static final long INIT_BIT_DESTINATION_SERVICE_ID = 0x2L;
    private static final long INIT_BIT_LOCAL_SERVICE_ADDRESS = 0x4L;
    private static final long INIT_BIT_LOCAL_SERVICE_PORT = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String destinationServiceName;
    private @Nullable String destinationServiceId;
    private @Nullable String localServiceAddress;
    private int localServicePort;
    private ImmutableMap.Builder<String, String> config = ImmutableMap.builder();
    private ImmutableList.Builder<ServiceProxyUpstream> upstreams = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceProxy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceProxy instance) {
      Objects.requireNonNull(instance, "instance");
      destinationServiceName(instance.getDestinationServiceName());
      destinationServiceId(instance.getDestinationServiceId());
      localServiceAddress(instance.getLocalServiceAddress());
      localServicePort(instance.getLocalServicePort());
      putAllConfig(instance.getConfig());
      addAllUpstreams(instance.getUpstreams());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxy#getDestinationServiceName() destinationServiceName} attribute.
     * @param destinationServiceName The value for destinationServiceName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DestinationServiceName")
    public final Builder destinationServiceName(String destinationServiceName) {
      this.destinationServiceName = Objects.requireNonNull(destinationServiceName, "destinationServiceName");
      initBits &= ~INIT_BIT_DESTINATION_SERVICE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxy#getDestinationServiceId() destinationServiceId} attribute.
     * @param destinationServiceId The value for destinationServiceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DestinationServiceID")
    public final Builder destinationServiceId(String destinationServiceId) {
      this.destinationServiceId = Objects.requireNonNull(destinationServiceId, "destinationServiceId");
      initBits &= ~INIT_BIT_DESTINATION_SERVICE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxy#getLocalServiceAddress() localServiceAddress} attribute.
     * @param localServiceAddress The value for localServiceAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LocalServiceAddress")
    public final Builder localServiceAddress(String localServiceAddress) {
      this.localServiceAddress = Objects.requireNonNull(localServiceAddress, "localServiceAddress");
      initBits &= ~INIT_BIT_LOCAL_SERVICE_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceProxy#getLocalServicePort() localServicePort} attribute.
     * @param localServicePort The value for localServicePort 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LocalServicePort")
    public final Builder localServicePort(int localServicePort) {
      this.localServicePort = localServicePort;
      initBits &= ~INIT_BIT_LOCAL_SERVICE_PORT;
      return this;
    }

    /**
     * Put one entry to the {@link ServiceProxy#getConfig() config} map.
     * @param key The key in the config map
     * @param value The associated value in the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putConfig(String key, String value) {
      this.config.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ServiceProxy#getConfig() config} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
      this.config.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ServiceProxy#getConfig() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Config")
    public final Builder config(Map<String, ? extends String> entries) {
      this.config = ImmutableMap.builder();
      return putAllConfig(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ServiceProxy#getConfig() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllConfig(Map<String, ? extends String> entries) {
      this.config.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link ServiceProxy#getUpstreams() upstreams} list.
     * @param element A upstreams element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUpstreams(ServiceProxyUpstream element) {
      this.upstreams.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ServiceProxy#getUpstreams() upstreams} list.
     * @param elements An array of upstreams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUpstreams(ServiceProxyUpstream... elements) {
      this.upstreams.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceProxy#getUpstreams() upstreams} list.
     * @param elements An iterable of upstreams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Upstreams")
    @JsonDeserialize(as = ImmutableList.class, contentAs = ServiceProxyUpstream.class)
    public final Builder upstreams(Iterable<? extends ServiceProxyUpstream> elements) {
      this.upstreams = ImmutableList.builder();
      return addAllUpstreams(elements);
    }

    /**
     * Adds elements to {@link ServiceProxy#getUpstreams() upstreams} list.
     * @param elements An iterable of upstreams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllUpstreams(Iterable<? extends ServiceProxyUpstream> elements) {
      this.upstreams.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceProxy ImmutableServiceProxy}.
     * @return An immutable instance of ServiceProxy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceProxy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceProxy(
          destinationServiceName,
          destinationServiceId,
          localServiceAddress,
          localServicePort,
          config.build(),
          upstreams.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION_SERVICE_NAME) != 0) attributes.add("destinationServiceName");
      if ((initBits & INIT_BIT_DESTINATION_SERVICE_ID) != 0) attributes.add("destinationServiceId");
      if ((initBits & INIT_BIT_LOCAL_SERVICE_ADDRESS) != 0) attributes.add("localServiceAddress");
      if ((initBits & INIT_BIT_LOCAL_SERVICE_PORT) != 0) attributes.add("localServicePort");
      return "Cannot build ServiceProxy, some of required attributes are not set " + attributes;
    }
  }
}
