package com.orbitz.consul.model.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Event}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvent.builder()}.
 */
@Generated(from = "Event", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEvent extends Event {
  private final String id;
  private final String name;
  private final @Nullable String payload;
  private final @Nullable String nodeFilter;
  private final @Nullable String serviceFilter;
  private final @Nullable String tagFilter;
  private final int version;
  private final Long lTime;

  private ImmutableEvent(
      String id,
      String name,
      @Nullable String payload,
      @Nullable String nodeFilter,
      @Nullable String serviceFilter,
      @Nullable String tagFilter,
      int version,
      Long lTime) {
    this.id = id;
    this.name = name;
    this.payload = payload;
    this.nodeFilter = nodeFilter;
    this.serviceFilter = serviceFilter;
    this.tagFilter = tagFilter;
    this.version = version;
    this.lTime = lTime;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code payload} attribute
   */
  @JsonProperty("Payload")
  @JsonDeserialize(using = Base64EncodingDeserializer.class)
  @Override
  public Optional<String> getPayload() {
    return Optional.ofNullable(payload);
  }

  /**
   * @return The value of the {@code nodeFilter} attribute
   */
  @JsonProperty("NodeFilter")
  @Override
  public Optional<String> getNodeFilter() {
    return Optional.ofNullable(nodeFilter);
  }

  /**
   * @return The value of the {@code serviceFilter} attribute
   */
  @JsonProperty("ServiceFilter")
  @Override
  public Optional<String> getServiceFilter() {
    return Optional.ofNullable(serviceFilter);
  }

  /**
   * @return The value of the {@code tagFilter} attribute
   */
  @JsonProperty("TagFilter")
  @Override
  public Optional<String> getTagFilter() {
    return Optional.ofNullable(tagFilter);
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code lTime} attribute
   */
  @JsonProperty("LTime")
  @Override
  public Long getLTime() {
    return lTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableEvent(
        newValue,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        newValue,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getPayload() payload} attribute.
   * @param value The value for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "payload");
    if (Objects.equals(this.payload, newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        newValue,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getPayload() payload} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.payload, value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        value,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getNodeFilter() nodeFilter} attribute.
   * @param value The value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "nodeFilter");
    if (Objects.equals(this.nodeFilter, newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        newValue,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getNodeFilter() nodeFilter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.nodeFilter, value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        value,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getServiceFilter() serviceFilter} attribute.
   * @param value The value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serviceFilter");
    if (Objects.equals(this.serviceFilter, newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        newValue,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getServiceFilter() serviceFilter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceFilter, value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        value,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getTagFilter() tagFilter} attribute.
   * @param value The value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "tagFilter");
    if (Objects.equals(this.tagFilter, newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        newValue,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getTagFilter() tagFilter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tagFilter, value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        value,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        value,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getLTime() lTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withLTime(Long value) {
    Long newValue = Objects.requireNonNull(value, "lTime");
    if (this.lTime.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvent
        && equalTo((ImmutableEvent) another);
  }

  private boolean equalTo(ImmutableEvent another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(payload, another.payload)
        && Objects.equals(nodeFilter, another.nodeFilter)
        && Objects.equals(serviceFilter, another.serviceFilter)
        && Objects.equals(tagFilter, another.tagFilter)
        && version == another.version
        && lTime.equals(another.lTime);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code payload}, {@code nodeFilter}, {@code serviceFilter}, {@code tagFilter}, {@code version}, {@code lTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(payload);
    h += (h << 5) + Objects.hashCode(nodeFilter);
    h += (h << 5) + Objects.hashCode(serviceFilter);
    h += (h << 5) + Objects.hashCode(tagFilter);
    h += (h << 5) + version;
    h += (h << 5) + lTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Event} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Event")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("payload", payload)
        .add("nodeFilter", nodeFilter)
        .add("serviceFilter", serviceFilter)
        .add("tagFilter", tagFilter)
        .add("version", version)
        .add("lTime", lTime)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Event", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Event {
    @Nullable String id;
    @Nullable String name;
    @Nullable Optional<String> payload = Optional.empty();
    @Nullable Optional<String> nodeFilter = Optional.empty();
    @Nullable Optional<String> serviceFilter = Optional.empty();
    @Nullable Optional<String> tagFilter = Optional.empty();
    int version;
    boolean versionIsSet;
    @Nullable Long lTime;
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Payload")
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public void setPayload(Optional<String> payload) {
      this.payload = payload;
    }
    @JsonProperty("NodeFilter")
    public void setNodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = nodeFilter;
    }
    @JsonProperty("ServiceFilter")
    public void setServiceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = serviceFilter;
    }
    @JsonProperty("TagFilter")
    public void setTagFilter(Optional<String> tagFilter) {
      this.tagFilter = tagFilter;
    }
    @JsonProperty("Version")
    public void setVersion(int version) {
      this.version = version;
      this.versionIsSet = true;
    }
    @JsonProperty("LTime")
    public void setLTime(Long lTime) {
      this.lTime = lTime;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPayload() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNodeFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTagFilter() { throw new UnsupportedOperationException(); }
    @Override
    public int getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEvent fromJson(Json json) {
    ImmutableEvent.Builder builder = ImmutableEvent.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    if (json.nodeFilter != null) {
      builder.nodeFilter(json.nodeFilter);
    }
    if (json.serviceFilter != null) {
      builder.serviceFilter(json.serviceFilter);
    }
    if (json.tagFilter != null) {
      builder.tagFilter(json.tagFilter);
    }
    if (json.versionIsSet) {
      builder.version(json.version);
    }
    if (json.lTime != null) {
      builder.lTime(json.lTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Event} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Event instance
   */
  public static ImmutableEvent copyOf(Event instance) {
    if (instance instanceof ImmutableEvent) {
      return (ImmutableEvent) instance;
    }
    return ImmutableEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvent ImmutableEvent}.
   * <pre>
   * ImmutableEvent.builder()
   *    .id(String) // required {@link Event#getId() id}
   *    .name(String) // required {@link Event#getName() name}
   *    .payload(String) // optional {@link Event#getPayload() payload}
   *    .nodeFilter(String) // optional {@link Event#getNodeFilter() nodeFilter}
   *    .serviceFilter(String) // optional {@link Event#getServiceFilter() serviceFilter}
   *    .tagFilter(String) // optional {@link Event#getTagFilter() tagFilter}
   *    .version(int) // required {@link Event#getVersion() version}
   *    .lTime(Long) // required {@link Event#getLTime() lTime}
   *    .build();
   * </pre>
   * @return A new ImmutableEvent builder
   */
  public static ImmutableEvent.Builder builder() {
    return new ImmutableEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvent ImmutableEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Event", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private static final long INIT_BIT_L_TIME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String payload;
    private @Nullable String nodeFilter;
    private @Nullable String serviceFilter;
    private @Nullable String tagFilter;
    private int version;
    private @Nullable Long lTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Event} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Event instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      Optional<String> payloadOptional = instance.getPayload();
      if (payloadOptional.isPresent()) {
        payload(payloadOptional);
      }
      Optional<String> nodeFilterOptional = instance.getNodeFilter();
      if (nodeFilterOptional.isPresent()) {
        nodeFilter(nodeFilterOptional);
      }
      Optional<String> serviceFilterOptional = instance.getServiceFilter();
      if (serviceFilterOptional.isPresent()) {
        serviceFilter(serviceFilterOptional);
      }
      Optional<String> tagFilterOptional = instance.getTagFilter();
      if (tagFilterOptional.isPresent()) {
        tagFilter(tagFilterOptional);
      }
      version(instance.getVersion());
      lTime(instance.getLTime());
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getPayload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder payload(String payload) {
      this.payload = Objects.requireNonNull(payload, "payload");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getPayload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Payload")
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public final Builder payload(Optional<String> payload) {
      this.payload = payload.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nodeFilter(String nodeFilter) {
      this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeFilter")
    public final Builder nodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = nodeFilter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceFilter(String serviceFilter) {
      this.serviceFilter = Objects.requireNonNull(serviceFilter, "serviceFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceFilter")
    public final Builder serviceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = serviceFilter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tagFilter(String tagFilter) {
      this.tagFilter = Objects.requireNonNull(tagFilter, "tagFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TagFilter")
    public final Builder tagFilter(Optional<String> tagFilter) {
      this.tagFilter = tagFilter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Version")
    public final Builder version(int version) {
      this.version = version;
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getLTime() lTime} attribute.
     * @param lTime The value for lTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("LTime")
    public final Builder lTime(Long lTime) {
      this.lTime = Objects.requireNonNull(lTime, "lTime");
      initBits &= ~INIT_BIT_L_TIME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvent ImmutableEvent}.
     * @return An immutable instance of Event
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvent(id, name, payload, nodeFilter, serviceFilter, tagFilter, version, lTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_L_TIME) != 0) attributes.add("lTime");
      return "Cannot build Event, some of required attributes are not set " + attributes;
    }
  }
}
