package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeleteOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteOptions.builder()}.
 */
@Generated(from = "DeleteOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteOptions extends DeleteOptions {
  private final ImmutableList<String> toQueryParameters;
  private final ImmutableMap<String, String> toHeaders;
  private final @Nullable Long cas;
  private final @Nullable Boolean recurse;
  private final @Nullable String datacenter;
  private transient final boolean isRecurse;

  private ImmutableDeleteOptions(
      ImmutableList<String> toQueryParameters,
      ImmutableMap<String, String> toHeaders,
      @Nullable Long cas,
      @Nullable Boolean recurse,
      @Nullable String datacenter) {
    this.toQueryParameters = toQueryParameters;
    this.toHeaders = toHeaders;
    this.cas = cas;
    this.recurse = recurse;
    this.datacenter = datacenter;
    this.isRecurse = super.isRecurse();
  }

  /**
   * @return The value of the {@code toQueryParameters} attribute
   */
  @Override
  public ImmutableList<String> toQueryParameters() {
    return toQueryParameters;
  }

  /**
   * @return The value of the {@code toHeaders} attribute
   */
  @Override
  public ImmutableMap<String, String> toHeaders() {
    return toHeaders;
  }

  /**
   * @return The value of the {@code cas} attribute
   */
  @Override
  public Optional<Long> getCas() {
    return Optional.ofNullable(cas);
  }

  /**
   * @return The value of the {@code recurse} attribute
   */
  @Override
  public Optional<Boolean> getRecurse() {
    return Optional.ofNullable(recurse);
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The computed-at-construction value of the {@code isRecurse} attribute
   */
  @Override
  public boolean isRecurse() {
    return isRecurse;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeleteOptions#toQueryParameters() toQueryParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withToQueryParameters(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDeleteOptions(newValue, this.toHeaders, this.cas, this.recurse, this.datacenter);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeleteOptions#toQueryParameters() toQueryParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toQueryParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withToQueryParameters(Iterable<String> elements) {
    if (this.toQueryParameters == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDeleteOptions(newValue, this.toHeaders, this.cas, this.recurse, this.datacenter);
  }

  /**
   * Copy the current immutable object by replacing the {@link DeleteOptions#toHeaders() toHeaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the toHeaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withToHeaders(Map<String, ? extends String> entries) {
    if (this.toHeaders == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableDeleteOptions(this.toQueryParameters, newValue, this.cas, this.recurse, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DeleteOptions#getCas() cas} attribute.
   * @param value The value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withCas(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.cas, newValue)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, newValue, this.recurse, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DeleteOptions#getCas() cas} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withCas(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.cas, value)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, value, this.recurse, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DeleteOptions#getRecurse() recurse} attribute.
   * @param value The value for recurse
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withRecurse(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.recurse, newValue)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, newValue, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DeleteOptions#getRecurse() recurse} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for recurse
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withRecurse(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.recurse, value)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, value, this.datacenter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DeleteOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withDatacenter(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, this.recurse, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DeleteOptions#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeleteOptions withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, this.recurse, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteOptions
        && equalTo((ImmutableDeleteOptions) another);
  }

  private boolean equalTo(ImmutableDeleteOptions another) {
    return toQueryParameters.equals(another.toQueryParameters)
        && toHeaders.equals(another.toHeaders)
        && Objects.equals(cas, another.cas)
        && Objects.equals(recurse, another.recurse)
        && Objects.equals(datacenter, another.datacenter)
        && isRecurse == another.isRecurse;
  }

  /**
   * Computes a hash code from attributes: {@code toQueryParameters}, {@code toHeaders}, {@code cas}, {@code recurse}, {@code datacenter}, {@code isRecurse}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toQueryParameters.hashCode();
    h += (h << 5) + toHeaders.hashCode();
    h += (h << 5) + Objects.hashCode(cas);
    h += (h << 5) + Objects.hashCode(recurse);
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + Booleans.hashCode(isRecurse);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteOptions")
        .omitNullValues()
        .add("toQueryParameters", toQueryParameters)
        .add("toHeaders", toHeaders)
        .add("cas", cas)
        .add("recurse", recurse)
        .add("datacenter", datacenter)
        .add("isRecurse", isRecurse)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DeleteOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteOptions instance
   */
  public static ImmutableDeleteOptions copyOf(DeleteOptions instance) {
    if (instance instanceof ImmutableDeleteOptions) {
      return (ImmutableDeleteOptions) instance;
    }
    return ImmutableDeleteOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
   * <pre>
   * ImmutableDeleteOptions.builder()
   *    .addToQueryParameters|addAllToQueryParameters(String) // {@link DeleteOptions#toQueryParameters() toQueryParameters} elements
   *    .putToHeaders|putAllToHeaders(String =&gt; String) // {@link DeleteOptions#toHeaders() toHeaders} mappings
   *    .cas(Long) // optional {@link DeleteOptions#getCas() cas}
   *    .recurse(Boolean) // optional {@link DeleteOptions#getRecurse() recurse}
   *    .datacenter(String) // optional {@link DeleteOptions#getDatacenter() datacenter}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteOptions builder
   */
  public static ImmutableDeleteOptions.Builder builder() {
    return new ImmutableDeleteOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeleteOptions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
    private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
    private @Nullable Long cas;
    private @Nullable Boolean recurse;
    private @Nullable String datacenter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.option.ParamAdder} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParamAdder instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.option.DeleteOptions} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeleteOptions instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ParamAdder) {
        ParamAdder instance = (ParamAdder) object;
        addAllToQueryParameters(instance.toQueryParameters());
        putAllToHeaders(instance.toHeaders());
      }
      if (object instanceof DeleteOptions) {
        DeleteOptions instance = (DeleteOptions) object;
        Optional<Long> casOptional = instance.getCas();
        if (casOptional.isPresent()) {
          cas(casOptional);
        }
        Optional<Boolean> recurseOptional = instance.getRecurse();
        if (recurseOptional.isPresent()) {
          recurse(recurseOptional);
        }
        Optional<String> datacenterOptional = instance.getDatacenter();
        if (datacenterOptional.isPresent()) {
          datacenter(datacenterOptional);
        }
      }
    }

    /**
     * Adds one element to {@link DeleteOptions#toQueryParameters() toQueryParameters} list.
     * @param element A toQueryParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String element) {
      this.toQueryParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DeleteOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An array of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String... elements) {
      this.toQueryParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DeleteOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toQueryParameters(Iterable<String> elements) {
      this.toQueryParameters = ImmutableList.builder();
      return addAllToQueryParameters(elements);
    }

    /**
     * Adds elements to {@link DeleteOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToQueryParameters(Iterable<String> elements) {
      this.toQueryParameters.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link DeleteOptions#toHeaders() toHeaders} map.
     * @param key The key in the toHeaders map
     * @param value The associated value in the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putToHeaders(String key, String value) {
      this.toHeaders.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DeleteOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
      this.toHeaders.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DeleteOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toHeaders(Map<String, ? extends String> entries) {
      this.toHeaders = ImmutableMap.builder();
      return putAllToHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DeleteOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
      this.toHeaders.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cas(long cas) {
      this.cas = cas;
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cas(Optional<Long> cas) {
      this.cas = cas.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getRecurse() recurse} to recurse.
     * @param recurse The value for recurse
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder recurse(boolean recurse) {
      this.recurse = recurse;
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getRecurse() recurse} to recurse.
     * @param recurse The value for recurse
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder recurse(Optional<Boolean> recurse) {
      this.recurse = recurse.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link DeleteOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteOptions ImmutableDeleteOptions}.
     * @return An immutable instance of DeleteOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteOptions build() {
      return new ImmutableDeleteOptions(toQueryParameters.build(), toHeaders.build(), cas, recurse, datacenter);
    }
  }
}
