package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RoleOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRoleOptions.builder()}.
 */
@Generated(from = "RoleOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRoleOptions extends RoleOptions {
  private final ImmutableList<String> toQueryParameters;
  private final ImmutableMap<String, String> toHeaders;
  private final @Nullable String policy;
  private final @Nullable String namespace;

  private ImmutableRoleOptions(
      ImmutableList<String> toQueryParameters,
      ImmutableMap<String, String> toHeaders,
      @Nullable String policy,
      @Nullable String namespace) {
    this.toQueryParameters = toQueryParameters;
    this.toHeaders = toHeaders;
    this.policy = policy;
    this.namespace = namespace;
  }

  /**
   * @return The value of the {@code toQueryParameters} attribute
   */
  @Override
  public ImmutableList<String> toQueryParameters() {
    return toQueryParameters;
  }

  /**
   * @return The value of the {@code toHeaders} attribute
   */
  @Override
  public ImmutableMap<String, String> toHeaders() {
    return toHeaders;
  }

  /**
   * @return The value of the {@code policy} attribute
   */
  @Override
  public Optional<String> getPolicy() {
    return Optional.ofNullable(policy);
  }

  /**
   * @return The value of the {@code namespace} attribute
   */
  @Override
  public Optional<String> getNamespace() {
    return Optional.ofNullable(namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleOptions#toQueryParameters() toQueryParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withToQueryParameters(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleOptions(newValue, this.toHeaders, this.policy, this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RoleOptions#toQueryParameters() toQueryParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toQueryParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withToQueryParameters(Iterable<String> elements) {
    if (this.toQueryParameters == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleOptions(newValue, this.toHeaders, this.policy, this.namespace);
  }

  /**
   * Copy the current immutable object by replacing the {@link RoleOptions#toHeaders() toHeaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the toHeaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withToHeaders(Map<String, ? extends String> entries) {
    if (this.toHeaders == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRoleOptions(this.toQueryParameters, newValue, this.policy, this.namespace);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RoleOptions#getPolicy() policy} attribute.
   * @param value The value for policy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withPolicy(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "policy");
    if (Objects.equals(this.policy, newValue)) return this;
    return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, newValue, this.namespace);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RoleOptions#getPolicy() policy} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for policy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withPolicy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.policy, value)) return this;
    return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, value, this.namespace);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RoleOptions#getNamespace() namespace} attribute.
   * @param value The value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withNamespace(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "namespace");
    if (Objects.equals(this.namespace, newValue)) return this;
    return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, this.policy, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RoleOptions#getNamespace() namespace} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleOptions withNamespace(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.namespace, value)) return this;
    return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, this.policy, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRoleOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRoleOptions
        && equalTo((ImmutableRoleOptions) another);
  }

  private boolean equalTo(ImmutableRoleOptions another) {
    return toQueryParameters.equals(another.toQueryParameters)
        && toHeaders.equals(another.toHeaders)
        && Objects.equals(policy, another.policy)
        && Objects.equals(namespace, another.namespace);
  }

  /**
   * Computes a hash code from attributes: {@code toQueryParameters}, {@code toHeaders}, {@code policy}, {@code namespace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toQueryParameters.hashCode();
    h += (h << 5) + toHeaders.hashCode();
    h += (h << 5) + Objects.hashCode(policy);
    h += (h << 5) + Objects.hashCode(namespace);
    return h;
  }

  /**
   * Prints the immutable value {@code RoleOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RoleOptions")
        .omitNullValues()
        .add("toQueryParameters", toQueryParameters)
        .add("toHeaders", toHeaders)
        .add("policy", policy)
        .add("namespace", namespace)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RoleOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleOptions instance
   */
  public static ImmutableRoleOptions copyOf(RoleOptions instance) {
    if (instance instanceof ImmutableRoleOptions) {
      return (ImmutableRoleOptions) instance;
    }
    return ImmutableRoleOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRoleOptions ImmutableRoleOptions}.
   * <pre>
   * ImmutableRoleOptions.builder()
   *    .addToQueryParameters|addAllToQueryParameters(String) // {@link RoleOptions#toQueryParameters() toQueryParameters} elements
   *    .putToHeaders|putAllToHeaders(String =&gt; String) // {@link RoleOptions#toHeaders() toHeaders} mappings
   *    .policy(String) // optional {@link RoleOptions#getPolicy() policy}
   *    .namespace(String) // optional {@link RoleOptions#getNamespace() namespace}
   *    .build();
   * </pre>
   * @return A new ImmutableRoleOptions builder
   */
  public static ImmutableRoleOptions.Builder builder() {
    return new ImmutableRoleOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRoleOptions ImmutableRoleOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RoleOptions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
    private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
    private @Nullable String policy;
    private @Nullable String namespace;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.option.ParamAdder} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParamAdder instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.orbitz.consul.option.RoleOptions} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RoleOptions instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ParamAdder) {
        ParamAdder instance = (ParamAdder) object;
        addAllToQueryParameters(instance.toQueryParameters());
        putAllToHeaders(instance.toHeaders());
      }
      if (object instanceof RoleOptions) {
        RoleOptions instance = (RoleOptions) object;
        Optional<String> namespaceOptional = instance.getNamespace();
        if (namespaceOptional.isPresent()) {
          namespace(namespaceOptional);
        }
        Optional<String> policyOptional = instance.getPolicy();
        if (policyOptional.isPresent()) {
          policy(policyOptional);
        }
      }
    }

    /**
     * Adds one element to {@link RoleOptions#toQueryParameters() toQueryParameters} list.
     * @param element A toQueryParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String element) {
      this.toQueryParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RoleOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An array of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String... elements) {
      this.toQueryParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RoleOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toQueryParameters(Iterable<String> elements) {
      this.toQueryParameters = ImmutableList.builder();
      return addAllToQueryParameters(elements);
    }

    /**
     * Adds elements to {@link RoleOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToQueryParameters(Iterable<String> elements) {
      this.toQueryParameters.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link RoleOptions#toHeaders() toHeaders} map.
     * @param key The key in the toHeaders map
     * @param value The associated value in the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putToHeaders(String key, String value) {
      this.toHeaders.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link RoleOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
      this.toHeaders.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RoleOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toHeaders(Map<String, ? extends String> entries) {
      this.toHeaders = ImmutableMap.builder();
      return putAllToHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RoleOptions#toHeaders() toHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the toHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
      this.toHeaders.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link RoleOptions#getPolicy() policy} to policy.
     * @param policy The value for policy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder policy(String policy) {
      this.policy = Objects.requireNonNull(policy, "policy");
      return this;
    }

    /**
     * Initializes the optional value {@link RoleOptions#getPolicy() policy} to policy.
     * @param policy The value for policy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder policy(Optional<String> policy) {
      this.policy = policy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RoleOptions#getNamespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namespace(String namespace) {
      this.namespace = Objects.requireNonNull(namespace, "namespace");
      return this;
    }

    /**
     * Initializes the optional value {@link RoleOptions#getNamespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namespace(Optional<String> namespace) {
      this.namespace = namespace.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRoleOptions ImmutableRoleOptions}.
     * @return An immutable instance of RoleOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRoleOptions build() {
      return new ImmutableRoleOptions(toQueryParameters.build(), toHeaders.build(), policy, namespace);
    }
  }
}
