/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.vad4j;

import com.orctom.vad4j.Bytes;
import com.orctom.vad4j.VadMode;
import com.orctom.vad4j.VadWindowSize;
import com.orctom.vad4j.exception.VADException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VAD
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VAD.class);
    public static final float THRESHOLD = 0.6f;
    private static final int CODE_SUCCESS = 0;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private Pointer state = Detector.INSTANCE.create_kika_vad_detector();

    public VAD() {
        this(VadWindowSize._10ms, VadMode.aggressive);
    }

    public VAD(VadWindowSize vadWindowSize, VadMode vadMode) {
        int n = vadWindowSize.getCode();
        int n2 = vadMode.getCode();
        int n3 = Detector.INSTANCE.init_kika_vad_detector(this.state, n, n2);
        if (0 != n3) {
            throw new VADException("Failed to init VAD");
        }
    }

    public float speechProbability(byte[] byArray) {
        if (null == byArray || byArray.length < 320) {
            return 0.0f;
        }
        short[] sArray = Bytes.toShortArray(byArray);
        try {
            float f = Detector.INSTANCE.process_kika_vad_prob(this.state, sArray, sArray.length);
            LOGGER.trace("score: {}", (Object)Float.valueOf(f));
            return f;
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            return 0.0f;
        }
    }

    public boolean isSpeech(byte[] byArray) {
        return this.speechProbability(byArray) >= 0.6f;
    }

    public boolean isSilent(byte[] byArray) {
        return this.speechProbability(byArray) < 0.6f;
    }

    @Override
    public void close() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        LOGGER.info("closing VAD");
        Detector.INSTANCE.destroy_kika_vad_detector(this.state);
    }

    public static interface Detector
    extends Library {
        public static final Detector INSTANCE = (Detector)Native.loadLibrary((String)"kvad", Detector.class);

        public Pointer create_kika_vad_detector();

        public int init_kika_vad_detector(Pointer var1, int var2, int var3);

        public int reset_kika_vad_detector(Pointer var1);

        public int process_kika_vad(Pointer var1, short[] var2, int var3);

        public float process_kika_vad_prob(Pointer var1, short[] var2, int var3);

        public void destroy_kika_vad_detector(Pointer var1);
    }
}

