/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.app.Activity;
import android.content.Context;
import android.view.Display;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import com.orhanobut.dialogplus.DialogPlusBuilder;
import com.orhanobut.dialogplus.ExpandTouchListener;
import com.orhanobut.dialogplus.Holder;
import com.orhanobut.dialogplus.HolderAdapter;
import com.orhanobut.dialogplus.OnBackPressListener;
import com.orhanobut.dialogplus.OnCancelListener;
import com.orhanobut.dialogplus.OnClickListener;
import com.orhanobut.dialogplus.OnDismissListener;
import com.orhanobut.dialogplus.OnHolderListener;
import com.orhanobut.dialogplus.OnItemClickListener;
import com.orhanobut.dialogplus.R;
import com.orhanobut.dialogplus.Utils;
import com.orhanobut.dialogplus.ViewHolder;

public class DialogPlus {
    private static final int INVALID = -1;
    private final ViewGroup rootView;
    private final ViewGroup contentContainer;
    private final boolean isCancelable;
    private boolean isDismissing;
    private final OnItemClickListener onItemClickListener;
    private final OnClickListener onClickListener;
    private final OnDismissListener onDismissListener;
    private final OnCancelListener onCancelListener;
    private final OnBackPressListener onBackPressListener;
    private final Holder holder;
    private final ViewGroup decorView;
    private final Animation outAnim;
    private final Animation inAnim;
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                if (DialogPlus.this.onCancelListener != null) {
                    DialogPlus.this.onCancelListener.onCancel(DialogPlus.this);
                }
                DialogPlus.this.dismiss();
            }
            return false;
        }
    };

    DialogPlus(DialogPlusBuilder builder) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)builder.getContext());
        Activity activity = (Activity)builder.getContext();
        this.holder = builder.getHolder();
        this.onItemClickListener = builder.getOnItemClickListener();
        this.onClickListener = builder.getOnClickListener();
        this.onDismissListener = builder.getOnDismissListener();
        this.onCancelListener = builder.getOnCancelListener();
        this.onBackPressListener = builder.getOnBackPressListener();
        this.isCancelable = builder.isCancelable();
        this.decorView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.base_container, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)builder.getOutmostLayoutParams());
        View outmostView = this.rootView.findViewById(R.id.dialogplus_outmost_container);
        outmostView.setBackgroundResource(builder.getOverlayBackgroundResource());
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.dialogplus_content_container);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)builder.getContentParams());
        this.outAnim = builder.getOutAnimation();
        this.inAnim = builder.getInAnimation();
        this.initContentView(layoutInflater, builder.getHeaderView(), builder.getFooterView(), builder.getAdapter(), builder.getContentPadding(), builder.getContentMargin());
        this.initCancelable();
        if (builder.isExpanded()) {
            this.initExpandAnimator(activity, builder.getDefaultContentHeight(), builder.getContentParams().gravity);
        }
    }

    public static DialogPlusBuilder newDialog(Context context) {
        return new DialogPlusBuilder(context);
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        View view = this.decorView.findViewById(R.id.dialogplus_outmost_container);
        return view != null;
    }

    public void dismiss() {
        if (this.isDismissing) {
            return;
        }
        this.outAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                DialogPlus.this.decorView.post(new Runnable(){

                    @Override
                    public void run() {
                        DialogPlus.this.decorView.removeView((View)DialogPlus.this.rootView);
                        DialogPlus.this.isDismissing = false;
                        if (DialogPlus.this.onDismissListener != null) {
                            DialogPlus.this.onDismissListener.onDismiss(DialogPlus.this);
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.contentContainer.startAnimation(this.outAnim);
        this.isDismissing = true;
    }

    public View findViewById(int resourceId) {
        return this.contentContainer.findViewById(resourceId);
    }

    public View getHeaderView() {
        return this.holder.getHeader();
    }

    public View getFooterView() {
        return this.holder.getFooter();
    }

    public View getHolderView() {
        return this.holder.getInflatedView();
    }

    private void initExpandAnimator(Activity activity, int defaultHeight, int gravity) {
        View view;
        Display display = activity.getWindowManager().getDefaultDisplay();
        int displayHeight = display.getHeight() - Utils.getStatusBarHeight((Context)activity);
        if (defaultHeight == 0) {
            defaultHeight = displayHeight * 2 / 5;
        }
        if (!((view = this.holder.getInflatedView()) instanceof AbsListView)) {
            return;
        }
        AbsListView absListView = (AbsListView)view;
        view.setOnTouchListener((View.OnTouchListener)ExpandTouchListener.newListener((Context)activity, absListView, (View)this.contentContainer, gravity, displayHeight, defaultHeight));
    }

    private void initContentView(LayoutInflater inflater, View header, View footer, BaseAdapter adapter, int[] padding, int[] margin) {
        View contentView = this.createView(inflater, header, footer, adapter);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.setMargins(margin[0], margin[1], margin[2], margin[3]);
        contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.getHolderView().setPadding(padding[0], padding[1], padding[2], padding[3]);
        this.contentContainer.addView(contentView);
    }

    private void initCancelable() {
        if (!this.isCancelable) {
            return;
        }
        View view = this.rootView.findViewById(R.id.dialogplus_outmost_container);
        view.setOnTouchListener(this.onCancelableTouchListener);
    }

    private View createView(LayoutInflater inflater, View headerView, View footerView, BaseAdapter adapter) {
        View view = this.holder.getView(inflater, this.rootView);
        if (this.holder instanceof ViewHolder) {
            this.assignClickListenerRecursively(view);
        }
        this.assignClickListenerRecursively(headerView);
        this.holder.addHeader(headerView);
        this.assignClickListenerRecursively(footerView);
        this.holder.addFooter(footerView);
        if (adapter != null && this.holder instanceof HolderAdapter) {
            HolderAdapter holderAdapter = (HolderAdapter)this.holder;
            holderAdapter.setAdapter(adapter);
            holderAdapter.setOnItemClickListener(new OnHolderListener(){

                @Override
                public void onItemClick(Object item, View view, int position) {
                    if (DialogPlus.this.onItemClickListener == null) {
                        return;
                    }
                    DialogPlus.this.onItemClickListener.onItemClick(DialogPlus.this, item, view, position);
                }
            });
        }
        return view;
    }

    private void assignClickListenerRecursively(View parent) {
        if (parent == null) {
            return;
        }
        if (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            int childCount = viewGroup.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = viewGroup.getChildAt(i);
                this.assignClickListenerRecursively(child);
            }
        }
        this.setClickListener(parent);
    }

    private void setClickListener(View view) {
        if (view.getId() == -1) {
            return;
        }
        if (view instanceof AdapterView) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DialogPlus.this.onClickListener == null) {
                    return;
                }
                DialogPlus.this.onClickListener.onClick(DialogPlus.this, v);
            }
        });
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
        this.contentContainer.requestFocus();
        this.holder.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                switch (event.getAction()) {
                    case 1: {
                        if (keyCode != 4) break;
                        if (DialogPlus.this.onBackPressListener != null) {
                            DialogPlus.this.onBackPressListener.onBackPressed(DialogPlus.this);
                        }
                        if (DialogPlus.this.isCancelable) {
                            DialogPlus.this.onBackPressed(DialogPlus.this);
                        }
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public void onBackPressed(DialogPlus dialogPlus) {
        if (this.onCancelListener != null) {
            this.onCancelListener.onCancel(this);
        }
        this.dismiss();
    }
}

