/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.orhanobut.hawk.AesEncryption;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.DataUtil;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.GsonParser;
import com.orhanobut.hawk.HawkEncoder;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.SharedPreferencesStorage;
import com.orhanobut.hawk.Storage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Hawk {
    private static final String TAG = "HAWK";
    private static final String TAG_CRYPTO = "324909sdfsd98098";
    private static final String KEY_NO_CRYPTO = "dfsklj2342nasdfoasdfcrpknasdf";
    private static Encoder encoder;
    private static Storage storage;
    private static Encryption encryption;
    private static LogLevel logLevel;
    private static ExecutorService executorService;
    private static boolean noEncryption;

    private Hawk() {
    }

    public static void init(Context context) {
        Hawk.init(context, null, LogLevel.NONE);
    }

    public static void init(Context context, String password, Callback callback) {
        Hawk.init(context, password, LogLevel.NONE, callback);
    }

    public static void init(Context context, String password) {
        Hawk.init(context, password, LogLevel.NONE);
    }

    public static void init(Context context, String password, LogLevel logLevel) {
        Context appContext = context.getApplicationContext();
        Hawk.logLevel = logLevel;
        storage = new SharedPreferencesStorage(appContext, TAG);
        encoder = new HawkEncoder(new GsonParser(new Gson()));
        if (storage.contains(KEY_NO_CRYPTO)) {
            noEncryption = true;
            return;
        }
        SharedPreferencesStorage cryptoStorage = new SharedPreferencesStorage(appContext, TAG_CRYPTO);
        encryption = new AesEncryption(cryptoStorage, encoder, password);
        boolean result = encryption.init();
        Hawk.setEncryptionMode(result);
    }

    public static void initWithoutEncryption(Context context, LogLevel logLevel) {
        Context appContext = context.getApplicationContext();
        Hawk.logLevel = logLevel;
        storage = new SharedPreferencesStorage(appContext, TAG);
        encoder = new HawkEncoder(new GsonParser(new Gson()));
        noEncryption = true;
    }

    private static void setEncryptionMode(boolean isCryptoSupported) {
        if (isCryptoSupported) {
            noEncryption = false;
            return;
        }
        storage.put(KEY_NO_CRYPTO, true);
        noEncryption = true;
    }

    public static void init(final Context context, final String password, final LogLevel logLevel, final Callback callback) {
        executorService = Executors.newSingleThreadExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Hawk.init(context, password, logLevel);
                    callback.onSuccess();
                }
                catch (Exception e) {
                    Logger.e("Exception occurred while initialization : ", e);
                    callback.onFail(e);
                }
            }
        };
        executorService.execute(runnable);
        executorService.shutdown();
    }

    public static <T> boolean put(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (value == null) {
            return Hawk.remove(key);
        }
        String encodedText = Hawk.encode(value);
        return encodedText != null && storage.put(key, encodedText);
    }

    public static <T> boolean put(String key, List<T> value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (value == null) {
            return Hawk.remove(key);
        }
        String encodedText = Hawk.encode(value);
        return encodedText != null && storage.put(key, encodedText);
    }

    private static <T> String encode(T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        byte[] encodedValue = encoder.encode(value);
        String cipherText = noEncryption ? Base64.encodeToString((byte[])encodedValue, (int)0) : encryption.encrypt(encodedValue);
        if (cipherText == null) {
            return null;
        }
        return DataUtil.addTypeAsObject(cipherText, value.getClass());
    }

    private static <T> String encode(List<T> list) {
        if (list == null) {
            throw new NullPointerException("List<T> cannot be null");
        }
        if (list.size() == 0) {
            throw new IllegalStateException("List<T> cannot be empty");
        }
        byte[] encodedValue = encoder.encode(list);
        String cipherText = noEncryption ? Base64.encodeToString((byte[])encodedValue, (int)0) : encryption.encrypt(encodedValue);
        if (cipherText == null) {
            return null;
        }
        Class<?> clazz = list.get(0).getClass();
        return DataUtil.addTypeAsList(cipherText, clazz);
    }

    public static <T> T get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        String fullText = (String)storage.get(key);
        if (fullText == null) {
            return null;
        }
        DataInfo dataInfo = DataUtil.getDataInfo(fullText);
        byte[] bytes = noEncryption ? Base64.decode((String)dataInfo.getCipherText(), (int)0) : encryption.decrypt(dataInfo.getCipherText());
        try {
            return encoder.decode(bytes, dataInfo);
        }
        catch (Exception e) {
            Logger.d(e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T defaultValue) {
        T t = Hawk.get(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static Chain chain() {
        return new Chain();
    }

    public static Chain chain(int capacity) {
        return new Chain(capacity);
    }

    public static int count() {
        return storage.count();
    }

    public static boolean clear() {
        return storage.clear();
    }

    public static boolean remove(String key) {
        return storage.remove(key);
    }

    public static boolean remove(String ... keys) {
        return storage.remove(keys);
    }

    public static boolean contains(String key) {
        return storage.contains(key);
    }

    public static boolean resetCrypto() {
        return encryption == null || encryption.reset();
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static interface Callback {
        public void onSuccess();

        public void onFail(Exception var1);
    }

    public static final class Chain {
        private final List<Pair<String, ?>> items;

        public Chain() {
            this(10);
        }

        public Chain(int capacity) {
            this.items = new ArrayList(capacity);
        }

        public <T> Chain put(String key, T value) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            String encodedText = Hawk.encode(value);
            if (encodedText == null) {
                Log.d((String)Hawk.TAG, (String)("Key : " + key + " is not added, encryption failed"));
                return this;
            }
            this.items.add(new Pair((Object)key, (Object)encodedText));
            return this;
        }

        public <T> Chain put(String key, List<T> list) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            String encodedText = Hawk.encode(list);
            if (encodedText == null) {
                Log.d((String)Hawk.TAG, (String)("Key : " + key + " is not added, encryption failed"));
                return this;
            }
            this.items.add(new Pair((Object)key, (Object)encodedText));
            return this;
        }

        public boolean commit() {
            return storage.put(this.items);
        }
    }
}

