/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.Logger;
import java.io.Serializable;

final class DataUtil {
    private static final String DELIMITER = "@";
    private static final char FLAG_NON_SERIALIZABLE = '0';
    private static final char FLAG_SERIALIZABLE = '1';
    private static final char TYPE_LIST = '1';
    private static final char TYPE_OBJECT = '0';

    private DataUtil() {
    }

    static DataInfo getDataInfo(String storedText) {
        if (storedText == null) {
            throw new NullPointerException("Text should not be null");
        }
        int index = storedText.indexOf(DELIMITER);
        if (index == 0) {
            throw new IllegalArgumentException("Text should contain delimiter");
        }
        String text = storedText.substring(0, index);
        boolean isSerializable = text.charAt(text.length() - 1) == '1';
        boolean isList = text.charAt(text.length() - 2) == '1';
        String className = text.substring(0, text.length() - 2);
        String cipherText = storedText.substring(index + 1);
        Class<?> clazz = null;
        if (isList || !isSerializable) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logger.d(e.getMessage());
            }
        }
        return new DataInfo(isSerializable, isList, cipherText, clazz);
    }

    static String addTypeAsObject(String cipherText, Class clazz) {
        String className = clazz.getCanonicalName();
        char serializable = Serializable.class.isAssignableFrom(clazz) ? (char)'1' : '0';
        return className + '0' + serializable + DELIMITER + cipherText;
    }

    static String addTypeAsList(String cipherText, Class clazz) {
        String className = clazz.getCanonicalName();
        return className + '1' + '0' + DELIMITER + cipherText;
    }
}

