/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.google.gson.reflect.TypeToken;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Parser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

final class HawkEncoder
implements Encoder {
    private final Parser parser;

    public HawkEncoder(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser may not be null");
        }
        this.parser = parser;
    }

    @Override
    public <T> byte[] encode(T value) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        if (value instanceof Serializable) {
            bytes = this.fromSerializable((Serializable)value);
        } else {
            String json = this.parser.toJson(value);
            bytes = json.getBytes();
        }
        return bytes;
    }

    @Override
    public <T> byte[] encode(List<T> value) {
        if (value == null) {
            return null;
        }
        String json = this.parser.toJson(value);
        return json.getBytes();
    }

    @Override
    public <T> T decode(byte[] bytes, DataInfo info) throws Exception {
        if (bytes == null) {
            return null;
        }
        boolean isList = info.isList();
        if (!isList && info.isSerializable()) {
            return this.toSerializable(bytes);
        }
        String json = new String(bytes);
        Class type = info.getClazz();
        if (!isList) {
            return this.parser.fromJson(json, type);
        }
        return this.fromJsonList(json, type);
    }

    @Override
    public <T> T decodeSerializable(String value) throws Exception {
        return this.toSerializable(value.getBytes());
    }

    private <T> T fromJsonList(String json, Class<?> type) throws Exception {
        ArrayList list = (ArrayList)this.parser.fromJson(json, new TypeToken<ArrayList<T>>(){}.getType());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.parser.fromJson(this.parser.toJson(list.get(i)), type));
        }
        return (T)list;
    }

    private byte[] fromSerializable(Serializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] result = null;
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            oos.close();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    private <T> T toSerializable(byte[] bytes) {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            Logger.d(e.getMessage());
        }
        if (inputStream == null) {
            return null;
        }
        Object result = null;
        try {
            result = inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.d(e.getMessage());
        }
        return (T)result;
    }
}

