/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.orhanobut.hawk.DataHelper;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.HawkBuilder;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Utils;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public final class Hawk {
    private static HawkBuilder hawkBuilder;

    private Hawk() {
    }

    public static HawkBuilder init(Context context) {
        hawkBuilder = new HawkBuilder(context);
        return hawkBuilder;
    }

    public static <T> boolean put(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (value == null) {
            return Hawk.remove(key);
        }
        String encodedText = Hawk.zip(value);
        return encodedText != null && hawkBuilder.getStorage().put(key, encodedText);
    }

    public static <T> Observable<Boolean> putObservable(final String key, final T value) {
        Hawk.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(Subscriber<? super Boolean> subscriber) {
                block3: {
                    try {
                        boolean result = Hawk.put(key, value);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)result);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    private static void checkRx() {
        if (!Utils.hasRxJavaOnClasspath()) {
            throw new NoClassDefFoundError("RxJava is not on classpath, make sure that you have it in your dependencies");
        }
    }

    private static <T> String zip(T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        byte[] encodedValue = hawkBuilder.getEncoder().encode(value);
        String cipherText = !hawkBuilder.isEncrypted() ? DataHelper.encodeBase64(encodedValue) : hawkBuilder.getEncryption().encrypt(encodedValue);
        if (cipherText == null) {
            return null;
        }
        return DataHelper.addType(cipherText, value);
    }

    public static <T> T get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        String fullText = (String)hawkBuilder.getStorage().get(key);
        if (fullText == null) {
            return null;
        }
        DataInfo dataInfo = DataHelper.getDataInfo(fullText);
        byte[] bytes = !hawkBuilder.isEncrypted() ? DataHelper.decodeBase64(dataInfo.getCipherText()) : hawkBuilder.getEncryption().decrypt(dataInfo.getCipherText());
        if (bytes == null) {
            return null;
        }
        try {
            return hawkBuilder.getEncoder().decode(bytes, dataInfo);
        }
        catch (Exception e) {
            Logger.d(e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T defaultValue) {
        T t = Hawk.get(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static <T> Observable<T> getObservable(String key) {
        Hawk.checkRx();
        return Hawk.getObservable(key, null);
    }

    public static <T> Observable<T> getObservable(final String key, final T defaultValue) {
        Hawk.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                block3: {
                    try {
                        Object t = Hawk.get(key, defaultValue);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(t);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    public static Chain chain() {
        return new Chain();
    }

    public static Chain chain(int capacity) {
        return new Chain(capacity);
    }

    public static long count() {
        return hawkBuilder.getStorage().count();
    }

    public static boolean clear() {
        return hawkBuilder.getStorage().clear();
    }

    public static boolean remove(String key) {
        return hawkBuilder.getStorage().remove(key);
    }

    public static boolean remove(String ... keys) {
        return hawkBuilder.getStorage().remove(keys);
    }

    public static boolean contains(String key) {
        return hawkBuilder.getStorage().contains(key);
    }

    public static boolean resetCrypto() {
        return hawkBuilder.getEncryption() == null || hawkBuilder.getEncryption().reset();
    }

    public static LogLevel getLogLevel() {
        return hawkBuilder.getLogLevel();
    }

    public static final class Chain {
        private final List<Pair<String, ?>> items;

        public Chain() {
            this(10);
        }

        public Chain(int capacity) {
            this.items = new ArrayList(capacity);
        }

        public <T> Chain put(String key, T value) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            String encodedText = Hawk.zip(value);
            if (encodedText == null) {
                Log.d((String)"HAWK", (String)("Key : " + key + " is not added, encryption failed"));
                return this;
            }
            this.items.add(new Pair((Object)key, (Object)encodedText));
            return this;
        }

        public boolean commit() {
            return hawkBuilder.getStorage().put(this.items);
        }
    }
}

