/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.orhanobut.hawk.AesEncryption;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.GsonParser;
import com.orhanobut.hawk.HawkEncoder;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Parser;
import com.orhanobut.hawk.SharedPreferencesStorage;
import com.orhanobut.hawk.SqliteStorage;
import com.orhanobut.hawk.Storage;

public class HawkBuilder {
    private static final String TAG = "HAWK";
    private static final String TAG_INFO = "324909sdfsd98098";
    private static final String KEY_NO_CRYPTO = "dfsklj2342nasdfoasdfcrpknasdf";
    private Context context;
    private EncryptionMethod encryptionMethod;
    private String password;
    private LogLevel logLevel;
    private Storage cryptoStorage;
    private Encoder encoder;
    private Parser parser;
    private Encryption encryption;
    private Callback callback;

    public HawkBuilder(Context context) {
        this.context = context.getApplicationContext();
    }

    public HawkBuilder setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        return this;
    }

    public HawkBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public HawkBuilder setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public HawkBuilder setStorage(Storage storage) {
        this.cryptoStorage = storage;
        return this;
    }

    public HawkBuilder setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public EncryptionMethod getEncryptionMethod() {
        if (this.encryptionMethod == null) {
            this.encryptionMethod = EncryptionMethod.MEDIUM;
        }
        return this.encryptionMethod;
    }

    public String getPassword() {
        return this.password;
    }

    public LogLevel getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = LogLevel.NONE;
        }
        return this.logLevel;
    }

    public Storage getStorage() {
        if (this.cryptoStorage == null) {
            this.cryptoStorage = new SharedPreferencesStorage(this.context, TAG);
        }
        return this.cryptoStorage;
    }

    public Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new HawkEncoder(this.getParser());
        }
        return this.encoder;
    }

    public Storage getInfoStorage() {
        return new SharedPreferencesStorage(this.context, TAG_INFO);
    }

    public Parser getParser() {
        if (this.parser == null) {
            this.parser = new GsonParser(new Gson());
        }
        return this.parser;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public boolean isEncrypted() {
        return this.encryptionMethod != EncryptionMethod.NO_ENCRYPTION;
    }

    private void validate() {
        if (this.getEncryptionMethod() == EncryptionMethod.HIGHEST && TextUtils.isEmpty((CharSequence)this.getPassword())) {
            throw new IllegalStateException("Password cannot be null if encryption mode is highest");
        }
    }

    public void build() {
        if (this.callback != null) {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        HawkBuilder.this.startBuild();
                        HawkBuilder.this.callback.onSuccess();
                    }
                    catch (Exception e) {
                        HawkBuilder.this.callback.onFail(e);
                    }
                }
            });
            return;
        }
        this.startBuild();
    }

    private void startBuild() {
        this.validate();
        this.setEncryption();
    }

    private void setEncryption() {
        switch (this.getEncryptionMethod()) {
            case NO_ENCRYPTION: {
                break;
            }
            case HIGHEST: {
                this.encryption = new AesEncryption(this.getStorage(), this.getPassword());
                if (this.getEncryption().init()) break;
                this.getInfoStorage().put(KEY_NO_CRYPTO, true);
                this.encryptionMethod = EncryptionMethod.NO_ENCRYPTION;
                break;
            }
            case MEDIUM: {
                this.encryption = new AesEncryption(this.getStorage(), null);
                if (this.getEncryption().init()) break;
                this.getInfoStorage().put(KEY_NO_CRYPTO, true);
                this.encryptionMethod = EncryptionMethod.NO_ENCRYPTION;
            }
        }
    }

    public static Storage newSharedPrefStorage(Context context) {
        return new SharedPreferencesStorage(context, TAG);
    }

    public static Storage newSqliteStorage(Context context) {
        return new SqliteStorage(context);
    }

    public static interface Callback {
        public void onSuccess();

        public void onFail(Exception var1);
    }

    public static enum EncryptionMethod {
        HIGHEST,
        MEDIUM,
        NO_ENCRYPTION;

    }
}

