/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.text.TextUtils;
import com.orhanobut.hawk.AesCbcWithIntegrity;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Storage;
import java.security.GeneralSecurityException;

final class AesEncryption
implements Encryption {
    private static final String KEY_STORAGE_SALT = "asdf3242klj";
    private AesCbcWithIntegrity.SecretKeys key;
    private String saltKey;
    private Storage storage;

    AesEncryption(Storage storage, String password) {
        this.storage = storage;
        this.saltKey = (String)storage.get(KEY_STORAGE_SALT);
        this.generateSecretKey(password);
    }

    @Override
    public String encrypt(byte[] value) {
        if (value == null) {
            return null;
        }
        String result = null;
        try {
            AesCbcWithIntegrity.CipherTextIvMac civ = AesCbcWithIntegrity.encrypt(value, this.key);
            result = civ.toString();
        }
        catch (GeneralSecurityException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    @Override
    public byte[] decrypt(String value) {
        if (value == null) {
            return null;
        }
        byte[] result = null;
        try {
            AesCbcWithIntegrity.CipherTextIvMac civ = this.getCipherTextIvMac(value);
            result = AesCbcWithIntegrity.decrypt(civ, this.key);
        }
        catch (GeneralSecurityException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean reset() {
        return this.storage.clear();
    }

    private AesCbcWithIntegrity.CipherTextIvMac getCipherTextIvMac(String cipherText) {
        return new AesCbcWithIntegrity.CipherTextIvMac(cipherText);
    }

    private void generateSecretKey(String password) {
        try {
            if (TextUtils.isEmpty((CharSequence)this.saltKey)) {
                this.saltKey = AesCbcWithIntegrity.saltString(AesCbcWithIntegrity.generateSalt());
                this.storage.put(KEY_STORAGE_SALT, this.saltKey);
            }
            this.key = AesCbcWithIntegrity.generateKeyFromPassword(password, this.saltKey);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

