/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.google.gson.reflect.TypeToken;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.DataUtil;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Parser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

final class HawkEncoder
implements Encoder {
    private final Encryption encryption;
    private final Parser parser;

    public HawkEncoder(Encryption encryption, Parser parser) {
        if (encryption == null) {
            throw new NullPointerException("Encryption may not be null");
        }
        if (parser == null) {
            throw new NullPointerException("Parser may not be null");
        }
        this.encryption = encryption;
        this.parser = parser;
    }

    @Override
    public <T> String encode(T value) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        if (value instanceof Serializable) {
            bytes = this.fromSerializable((Serializable)value);
        } else {
            String json = this.parser.toJson(value);
            bytes = json.getBytes();
        }
        if (bytes == null) {
            return null;
        }
        return this.encryption.encrypt(bytes);
    }

    @Override
    public <T> String encode(List<T> value) {
        if (value == null) {
            return null;
        }
        String json = this.parser.toJson(value);
        byte[] bytes = json.getBytes();
        return this.encryption.encrypt(bytes);
    }

    @Override
    public <T> T decode(String value) throws Exception {
        if (value == null) {
            return null;
        }
        DataInfo info = DataUtil.getDataInfo(value);
        boolean isList = info.isList();
        byte[] bytes = this.encryption.decrypt(info.getCipherText());
        if (bytes == null) {
            return null;
        }
        if (!isList && info.isSerializable()) {
            return this.toSerializable(bytes);
        }
        String json = new String(bytes);
        Class type = info.getClazz();
        if (!isList) {
            return this.parser.fromJson(json, type);
        }
        return this.fromJsonList(json, type);
    }

    private <T> T fromJsonList(String json, Class<?> type) throws Exception {
        ArrayList list = (ArrayList)this.parser.fromJson(json, new TypeToken<ArrayList<T>>(){}.getType());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.parser.fromJson(this.parser.toJson(list.get(i)), type));
        }
        return (T)list;
    }

    private byte[] fromSerializable(Serializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] result = null;
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            oos.close();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            Logger.d(e.getMessage());
        }
        return result;
    }

    private <T> T toSerializable(byte[] bytes) {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            Logger.d(e.getMessage());
        }
        if (inputStream == null) {
            return null;
        }
        Object result = null;
        try {
            result = inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.d(e.getMessage());
        }
        return (T)result;
    }
}

