/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.Serializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HawkSerializer
implements Serializer {
    private static final char DELIMITER = '@';
    private static final String INFO_DELIMITER = "#";
    private static final char NEW_VERSION = 'V';

    HawkSerializer() {
    }

    @Override
    public <T> String serialize(String cipherText, T originalGivenValue) {
        char dataType;
        HawkUtils.checkNullOrEmpty("Cipher text", cipherText);
        HawkUtils.checkNull("Value", originalGivenValue);
        String keyClassName = "";
        String valueClassName = "";
        if (List.class.isAssignableFrom(originalGivenValue.getClass())) {
            List list = (List)originalGivenValue;
            if (!list.isEmpty()) {
                keyClassName = list.get(0).getClass().getName();
            }
            dataType = '1';
        } else if (Map.class.isAssignableFrom(originalGivenValue.getClass())) {
            Iterator iterator;
            dataType = '2';
            Map map = (Map)originalGivenValue;
            if (!map.isEmpty() && (iterator = map.entrySet().iterator()).hasNext()) {
                Map.Entry entry = iterator.next();
                keyClassName = entry.getKey().getClass().getName();
                valueClassName = entry.getValue().getClass().getName();
            }
        } else if (Set.class.isAssignableFrom(originalGivenValue.getClass())) {
            Iterator iterator;
            Set set = (Set)originalGivenValue;
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                keyClassName = iterator.next().getClass().getName();
            }
            dataType = '3';
        } else {
            dataType = '0';
            keyClassName = originalGivenValue.getClass().getName();
        }
        return keyClassName + INFO_DELIMITER + valueClassName + INFO_DELIMITER + dataType + 'V' + '@' + cipherText;
    }

    @Override
    public DataInfo deserialize(String serializedText) {
        String[] infos = serializedText.split(INFO_DELIMITER);
        char type = infos[2].charAt(0);
        Class<?> keyClazz = null;
        String firstElement = infos[0];
        if (firstElement != null && firstElement.length() != 0) {
            try {
                keyClazz = Class.forName(firstElement);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Class<?> valueClazz = null;
        String secondElement = infos[1];
        if (secondElement != null && secondElement.length() != 0) {
            try {
                valueClazz = Class.forName(secondElement);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        String cipherText = this.getCipherText(infos[infos.length - 1]);
        return new DataInfo(type, cipherText, keyClazz, valueClazz);
    }

    private String getCipherText(String serializedText) {
        int index = serializedText.indexOf(64);
        if (index == -1) {
            throw new IllegalArgumentException("Text should contain delimiter");
        }
        return serializedText.substring(index + 1);
    }
}

