/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OIterableObjectArray;
import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OSizeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OMultiValue {
    public static boolean isMultiValue(Class<?> iType) {
        return iType.isArray() || Collection.class.isAssignableFrom(iType) || Map.class.isAssignableFrom(iType);
    }

    public static boolean isMultiValue(Object iObject) {
        return iObject == null ? false : OMultiValue.isMultiValue(iObject.getClass());
    }

    public static boolean isIterable(Object iObject) {
        return iObject == null ? false : (iObject instanceof Iterable ? true : iObject instanceof Iterator);
    }

    public static int getSize(Object iObject) {
        if (iObject == null) {
            return 0;
        }
        if (iObject instanceof OSizeable) {
            return ((OSizeable)iObject).size();
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return 0;
        }
        if (iObject instanceof Collection) {
            return ((Collection)iObject).size();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).size();
        }
        if (iObject.getClass().isArray()) {
            return Array.getLength(iObject);
        }
        return 0;
    }

    public static Object getFirstValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject) || OMultiValue.getSize(iObject) == 0) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(0);
            }
            if (iObject instanceof Collection) {
                return ((Collection)iObject).iterator().next();
            }
            if (iObject instanceof Map) {
                return ((Map)iObject).values().iterator().next();
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, 0);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getLastValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(((List)iObject).size() - 1);
            }
            if (iObject instanceof Collection) {
                Object last = null;
                for (Object o : (Collection)iObject) {
                    last = o;
                }
                return last;
            }
            if (iObject instanceof Map) {
                Object last = null;
                for (Object o : ((Map)iObject).values()) {
                    last = o;
                }
                return last;
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, Array.getLength(iObject) - 1);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the last item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getValue(Object iObject, int iIndex) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        if (iIndex > OMultiValue.getSize(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(iIndex);
            }
            if (iObject instanceof Set) {
                int i = 0;
                for (Object o : (Set)iObject) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else if (iObject instanceof Map) {
                int i = 0;
                for (Object o : ((Map)iObject).values()) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else if (iObject.getClass().isArray()) {
                return Array.get(iObject, iIndex);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Iterable<Object> getMultiValueIterable(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof Iterable) {
            return (Iterable)iObject;
        }
        if (iObject instanceof Collection) {
            return (Collection)iObject;
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray<Object>(iObject);
        }
        if (iObject instanceof Iterator) {
            ArrayList<Object> temp = new ArrayList<Object>();
            Iterator it = (Iterator)iObject;
            while (it.hasNext()) {
                temp.add(it.next());
            }
            return temp;
        }
        return null;
    }

    public static Iterator<Object> getMultiValueIterator(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof Iterator) {
            return (Iterator)iObject;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        if (iObject instanceof Collection) {
            return ((Collection)iObject).iterator();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values().iterator();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray(iObject).iterator();
        }
        return null;
    }

    public static String toString(Object iObject) {
        StringBuilder sb = new StringBuilder();
        if (iObject instanceof Collection) {
            Collection coll = (Collection)iObject;
            sb.append('[');
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                try {
                    Object e = it.next();
                    sb.append((Object)(e == iObject ? "(this Collection)" : e));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append(']').toString();
        }
        if (iObject instanceof Map) {
            Map map = (Map)iObject;
            sb.append('{');
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry e = it.next();
                    sb.append((String)e.getKey());
                    sb.append(":");
                    sb.append((Object)(e.getValue() == iObject ? "(this Map)" : e.getValue()));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append('}').toString();
        }
        return iObject.toString();
    }

    public static Object add(Object iObject, Object iToAdd) {
        if (iObject != null) {
            if (iObject instanceof Collection) {
                Collection coll = (Collection)iObject;
                if (iToAdd instanceof Collection) {
                    for (Object o : (Collection)iToAdd) {
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.add(coll, o);
                            continue;
                        }
                        coll.add(o);
                    }
                } else if (iToAdd != null && iToAdd.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(iToAdd); ++i) {
                        Object o = Array.get(iToAdd, i);
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.add(coll, o);
                            continue;
                        }
                        coll.add(o);
                    }
                } else if (iToAdd instanceof Map) {
                    for (Map.Entry entry : ((Map)iToAdd).entrySet()) {
                        coll.add(entry.getValue());
                    }
                } else if (iToAdd instanceof Iterable) {
                    for (Object o : (Iterable)iToAdd) {
                        coll.add(o);
                    }
                } else if (iToAdd instanceof Iterator) {
                    Iterator it = (Iterator)iToAdd;
                    while (it.hasNext()) {
                        coll.add(it.next());
                    }
                } else {
                    coll.add(iToAdd);
                }
            } else {
                if (iObject.getClass().isArray()) {
                    Object[] copy;
                    if (iToAdd instanceof Collection) {
                        int tot = Array.getLength(iObject) + ((Collection)iToAdd).size();
                        copy = Arrays.copyOf((Object[])iObject, tot);
                        Iterator it = ((Collection)iToAdd).iterator();
                        for (int i = Array.getLength(iObject); i < tot; ++i) {
                            copy[i] = it.next();
                        }
                    } else if (iToAdd != null && iToAdd.getClass().isArray()) {
                        int tot = Array.getLength(iObject) + Array.getLength(iToAdd);
                        copy = Arrays.copyOf((Object[])iObject, tot);
                        System.arraycopy(iToAdd, 0, iObject, Array.getLength(iObject), Array.getLength(iToAdd));
                    } else {
                        copy = Arrays.copyOf((Object[])iObject, Array.getLength(iObject) + 1);
                        copy[copy.length - 1] = iToAdd;
                    }
                    return copy;
                }
                throw new IllegalArgumentException("Object " + iObject + " is not a multi value");
            }
        }
        return iObject;
    }

    public static Object remove(Object iObject, Object iToRemove, boolean iAllOccurrences) {
        if (iObject != null) {
            if (iObject instanceof OMultiCollectionIterator) {
                LinkedList list = new LinkedList();
                for (Object t : (OMultiCollectionIterator)((Object)iObject)) {
                    list.add(t);
                }
                iObject = list;
            }
            if (iToRemove instanceof OMultiCollectionIterator) {
                HashSet set = new HashSet();
                for (Object t : (OMultiCollectionIterator)((Object)iToRemove)) {
                    set.add(t);
                }
                iToRemove = set;
            }
            if (iObject instanceof Collection) {
                Collection coll = iObject;
                if (iToRemove instanceof Collection) {
                    for (Object object : (Collection)iToRemove) {
                        if (OMultiValue.isMultiValue(object)) {
                            OMultiValue.remove(coll, object, iAllOccurrences);
                            continue;
                        }
                        coll.remove(object);
                    }
                } else if (iToRemove != null && iToRemove.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(iToRemove); ++i) {
                        Object object = Array.get(iToRemove, i);
                        if (OMultiValue.isMultiValue(object)) {
                            OMultiValue.remove(coll, object, iAllOccurrences);
                            continue;
                        }
                        coll.remove(object);
                    }
                } else if (iToRemove instanceof Map) {
                    for (Map.Entry entry : ((Map)((Object)iToRemove)).entrySet()) {
                        coll.remove(entry.getKey());
                    }
                } else if (iToRemove instanceof Iterator) {
                    Iterator it;
                    if (iToRemove instanceof OMultiCollectionIterator) {
                        ((OMultiCollectionIterator)((Object)iToRemove)).reset();
                    }
                    if (iAllOccurrences) {
                        it = (OMultiCollectionIterator)((Object)iToRemove);
                        OMultiValue.batchRemove(coll, it);
                    } else {
                        it = (Iterator)((Object)iToRemove);
                        while (it.hasNext()) {
                            Object t = it.next();
                            while (coll.remove(t) && iAllOccurrences) {
                            }
                        }
                    }
                } else {
                    coll.remove(iToRemove);
                }
            } else {
                if (iObject.getClass().isArray()) {
                    Object[] copy;
                    if (iToRemove instanceof Collection) {
                        int sourceTot = Array.getLength(iObject);
                        int n = sourceTot - ((Collection)iToRemove).size();
                        copy = new Object[n];
                        int k = 0;
                        for (int i = 0; i < sourceTot; ++i) {
                            Object o = Array.get(iObject, i);
                            if (o == null) continue;
                            boolean found = false;
                            for (Object toRemove : (Collection)iToRemove) {
                                if (!o.equals(toRemove)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            copy[k++] = o;
                        }
                    } else {
                        if (iToRemove != null && iToRemove.getClass().isArray()) {
                            throw new UnsupportedOperationException("Cannot execute remove() against an array");
                        }
                        throw new UnsupportedOperationException("Cannot execute remove() against an array");
                    }
                    return copy;
                }
                throw new IllegalArgumentException("Object " + iObject + " is not a multi value");
            }
        }
        return iObject;
    }

    private static void batchRemove(Collection<Object> coll, Iterator<?> it) {
        int approximateRemainingSize = it instanceof OSizeable ? ((OSizeable)((Object)it)).size() : -1;
        while (it.hasNext()) {
            Set batch = OMultiValue.prepareBatch(it, approximateRemainingSize);
            coll.removeAll(batch);
            approximateRemainingSize -= batch.size();
        }
    }

    private static Set prepareBatch(Iterator<?> it, int approximateRemainingSize) {
        HashSet<Object> batch = approximateRemainingSize > -1 ? (approximateRemainingSize > 10000 ? new HashSet(13400) : new HashSet((int)((double)approximateRemainingSize / 0.75))) : new HashSet();
        for (int count = 0; count < 10000 && it.hasNext(); ++count) {
            batch.add(it.next());
        }
        return batch;
    }

    public static Object[] array(Object iValue) {
        return OMultiValue.array(iValue, Object.class);
    }

    public static <T> T[] array(Object iValue, Class<? extends T> iClass) {
        return OMultiValue.array(iValue, iClass, null);
    }

    public static <T> T[] array(Object iValue, Class<? extends T> iClass, OCallable<Object, Object> iCallback) {
        Object[] result;
        if (iValue == null) {
            return null;
        }
        if (OMultiValue.isMultiValue(iValue)) {
            result = (Object[])Array.newInstance(iClass, OMultiValue.getSize(iValue));
            int i = 0;
            Iterator<Object> it = OMultiValue.getMultiValueIterator(iValue);
            while (it.hasNext()) {
                result[i] = OMultiValue.convert(it.next(), iCallback);
                ++i;
            }
        } else if (OMultiValue.isIterable(iValue)) {
            ArrayList<Object> temp = new ArrayList<Object>();
            Iterator<Object> it = OMultiValue.getMultiValueIterator(iValue);
            while (it.hasNext()) {
                temp.add(OMultiValue.convert(it.next(), iCallback));
            }
            result = iClass.equals(Object.class) ? temp.toArray() : temp.toArray((Object[])Array.newInstance(iClass, OMultiValue.getSize(iValue)));
        } else {
            result = (Object[])Array.newInstance(iClass, 1);
            result[0] = OMultiValue.convert(iValue, iCallback);
        }
        return result;
    }

    public static Object convert(Object iObject, OCallable<Object, Object> iCallback) {
        return iCallback != null ? iCallback.call(iObject) : iObject;
    }
}

